/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import org.dspace.browse.ItemCountDAO;
import org.dspace.browse.ItemCountDAOSolr;
import org.dspace.browse.ItemCountException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class ItemCountDAOFactory {
    public static ItemCountDAO getInstance(Context context) throws ItemCountException {
        ItemCountDAO dao = null;
        String className = ConfigurationManager.getProperty("ItemCountDAO.class");
        if (className == null) {
            dao = new ItemCountDAOSolr();
        } else {
            try {
                dao = (ItemCountDAO)Class.forName(className.trim()).newInstance();
            }
            catch (Exception e) {
                throw new ItemCountException("The configuration for ItemCountDAO is invalid: " + className, e);
            }
        }
        dao.setContext(context);
        return dao;
    }
}

