/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import org.apache.commons.lang.ArrayUtils;
import org.dspace.content.authority.Choice;

public class Choices {
    public static final int CF_ACCEPTED = 600;
    public static final int CF_UNCERTAIN = 500;
    public static final int CF_AMBIGUOUS = 400;
    public static final int CF_NOTFOUND = 300;
    public static final int CF_FAILED = 200;
    public static final int CF_REJECTED = 100;
    public static final int CF_NOVALUE = 0;
    public static final int CF_UNSET = -1;
    private static final int[] confidenceValue = new int[]{-1, 0, 100, 200, 300, 400, 500, 600};
    private static final String[] confidenceText = new String[]{"UNSET", "NOVALUE", "REJECTED", "FAILED", "NOTFOUND", "AMBIGUOUS", "UNCERTAIN", "ACCEPTED"};
    public Choice[] values = null;
    public int confidence = 0;
    public int start = 0;
    public int total = 0;
    public int defaultSelected = -1;
    public boolean more = false;

    public Choices(Choice[] values, int start, int total, int confidence, boolean more) {
        this.values = (Choice[])ArrayUtils.clone((Object[])values);
        this.start = start;
        this.total = total;
        this.confidence = confidence;
        this.more = more;
    }

    public Choices(Choice[] values, int start, int total, int confidence, boolean more, int defaultSelected) {
        this.values = (Choice[])ArrayUtils.clone((Object[])values);
        this.start = start;
        this.total = total;
        this.confidence = confidence;
        this.more = more;
        this.defaultSelected = defaultSelected;
    }

    public Choices(int confidence) {
        this.values = new Choice[0];
        this.confidence = confidence;
    }

    public Choices(boolean isError) {
        this.values = new Choice[0];
        this.confidence = isError ? 200 : 0;
    }

    public boolean isError() {
        return this.confidence == 200 || this.confidence == 100;
    }

    public static String getConfidenceText(int cv) {
        String novalue = null;
        for (int i = 0; i < confidenceValue.length; ++i) {
            if (confidenceValue[i] == cv) {
                return confidenceText[i];
            }
            if (confidenceValue[i] != 0) continue;
            novalue = confidenceText[i];
        }
        return novalue;
    }

    public static int getConfidenceValue(String ct) {
        return Choices.getConfidenceValue(ct, 0);
    }

    public static int getConfidenceValue(String ct, int dflt) {
        for (int i = 0; i < confidenceText.length; ++i) {
            if (!confidenceText[i].equalsIgnoreCase(ct)) continue;
            return confidenceValue[i];
        }
        return dflt;
    }
}

