/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.DataLoader;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.TransformationEngine;
import gr.ekt.bte.dataloader.FileDataLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dspace.submit.lookup.MultipleSubmissionLookupDataLoader;
import org.dspace.submit.lookup.NetworkSubmissionLookupDataLoader;
import org.dspace.submit.lookup.SubmissionLookupDataLoader;
import org.dspace.submit.lookup.SubmissionLookupUtils;
import org.dspace.submit.util.SubmissionLookupDTO;

public class SubmissionLookupService {
    public static final String CFG_MODULE = "submission-lookup";
    public static final String SL_NAMESPACE_PREFIX = "http://www.dspace.org/sl/";
    public static final String MANUAL_USER_INPUT = "manual";
    public static final String PROVIDER_NAME_FIELD = "provider_name_field";
    private static Logger log = Logger.getLogger(SubmissionLookupService.class);
    public static final String SEPARATOR_VALUE = "#######";
    public static final String SEPARATOR_VALUE_REGEX = "#######";
    private List<DataLoader> providers;
    private Map<String, List<String>> idents2provs;
    private List<String> searchProviders;
    private List<String> fileProviders;
    private TransformationEngine phase1TransformationEngine;
    private TransformationEngine phase2TransformationEngine;

    public void setPhase2TransformationEngine(TransformationEngine phase2TransformationEngine) {
        this.phase2TransformationEngine = phase2TransformationEngine;
    }

    public void setPhase1TransformationEngine(TransformationEngine phase1TransformationEngine) {
        this.phase1TransformationEngine = phase1TransformationEngine;
        MultipleSubmissionLookupDataLoader dataLoader = (MultipleSubmissionLookupDataLoader)phase1TransformationEngine.getDataLoader();
        this.idents2provs = new HashMap<String, List<String>>();
        this.searchProviders = new ArrayList<String>();
        this.fileProviders = new ArrayList<String>();
        if (this.providers == null) {
            this.providers = new ArrayList<DataLoader>();
            for (String providerName : dataLoader.getProvidersMap().keySet()) {
                List<String> suppIdentifiers;
                DataLoader p = dataLoader.getProvidersMap().get(providerName);
                this.providers.add(p);
                if (p instanceof FileDataLoader) {
                    this.fileProviders.add(providerName);
                    continue;
                }
                if (!(p instanceof NetworkSubmissionLookupDataLoader)) continue;
                NetworkSubmissionLookupDataLoader p2 = (NetworkSubmissionLookupDataLoader)p;
                p2.setProviderName(providerName);
                if (p2.isSearchProvider()) {
                    this.searchProviders.add(providerName);
                }
                if ((suppIdentifiers = p2.getSupportedIdentifiers()) == null) continue;
                for (String ident : suppIdentifiers) {
                    List<String> tmp = this.idents2provs.get(ident);
                    if (tmp == null) {
                        tmp = new ArrayList<String>();
                        this.idents2provs.put(ident, tmp);
                    }
                    tmp.add(providerName);
                }
            }
        }
    }

    public TransformationEngine getPhase1TransformationEngine() {
        return this.phase1TransformationEngine;
    }

    public TransformationEngine getPhase2TransformationEngine() {
        return this.phase2TransformationEngine;
    }

    public List<String> getIdentifiers() {
        ArrayList<String> allSupportedIdentifiers = new ArrayList<String>();
        MultipleSubmissionLookupDataLoader dataLoader = (MultipleSubmissionLookupDataLoader)this.phase1TransformationEngine.getDataLoader();
        for (String providerName : dataLoader.getProvidersMap().keySet()) {
            DataLoader provider = dataLoader.getProvidersMap().get(providerName);
            if (!(provider instanceof SubmissionLookupDataLoader)) continue;
            for (String identifier : ((SubmissionLookupDataLoader)provider).getSupportedIdentifiers()) {
                if (allSupportedIdentifiers.contains(identifier)) continue;
                allSupportedIdentifiers.add(identifier);
            }
        }
        return allSupportedIdentifiers;
    }

    public Map<String, List<String>> getProvidersIdentifiersMap() {
        return this.idents2provs;
    }

    public SubmissionLookupDTO getSubmissionLookupDTO(HttpServletRequest request, String uuidSubmission) {
        SubmissionLookupDTO dto = (SubmissionLookupDTO)request.getSession().getAttribute("submission_lookup_" + uuidSubmission);
        if (dto == null) {
            dto = new SubmissionLookupDTO();
            this.storeDTOs(request, uuidSubmission, dto);
        }
        return dto;
    }

    public void invalidateDTOs(HttpServletRequest request, String uuidSubmission) {
        request.getSession().removeAttribute("submission_lookup_" + uuidSubmission);
    }

    public void storeDTOs(HttpServletRequest request, String uuidSubmission, SubmissionLookupDTO dto) {
        request.getSession().setAttribute("submission_lookup_" + uuidSubmission, (Object)dto);
    }

    public List<String> getSearchProviders() {
        return this.searchProviders;
    }

    public List<DataLoader> getProviders() {
        return this.providers;
    }

    public static String getProviderName(Record rec) {
        return SubmissionLookupUtils.getFirstValue(rec, PROVIDER_NAME_FIELD);
    }

    public static String getType(Record rec) {
        return SubmissionLookupUtils.getFirstValue(rec, "type");
    }

    public List<String> getFileProviders() {
        return this.fileProviders;
    }
}

