/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.Value;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.content.MetadataSchema;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.submit.lookup.LookupProvidersCheck;

public class SubmissionLookupUtils {
    private static Logger log = Logger.getLogger(SubmissionLookupUtils.class);
    private static final String configFilePath = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "crosswalks" + File.separator;
    private static final Pattern converterPattern = Pattern.compile(".*\\((.*)\\)");

    public static LookupProvidersCheck getProvidersCheck(Context context, Item item, String dcSchema, String dcElement, String dcQualifier) {
        try {
            LookupProvidersCheck check = new LookupProvidersCheck();
            MetadataSchema[] schemas = MetadataSchema.findAll(context);
            DCValue[] values = item.getMetadata(dcSchema, dcElement, dcQualifier, "*");
            for (MetadataSchema schema : schemas) {
                DCValue[] slCache;
                boolean error = false;
                if (!schema.getNamespace().startsWith("http://www.dspace.org/sl/") || (slCache = item.getMetadata(schema.getName(), dcElement, dcQualifier, "*")).length == 0) continue;
                if (slCache.length != values.length) {
                    error = true;
                } else {
                    for (int idx = 0; idx < values.length; ++idx) {
                        DCValue v = values[idx];
                        DCValue sl = slCache[idx];
                        if (v.value.equals(sl.value)) continue;
                        error = true;
                        break;
                    }
                }
                if (error) {
                    check.getProvidersErr().add(schema.getName());
                    continue;
                }
                check.getProvidersOk().add(schema.getName());
            }
            return check;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String normalizeDOI(String doi) {
        if (doi != null) {
            return doi.trim().replaceAll("^http://dx.doi.org/", "").replaceAll("^doi:", "");
        }
        return null;
    }

    public static String getFirstValue(Record rec, String field) {
        List values = rec.getValues(field);
        String value = null;
        if (values != null && values.size() > 0) {
            value = ((Value)values.get(0)).getAsString();
        }
        return value;
    }

    public static List<String> getValues(Record rec, String field) {
        ArrayList<String> result = new ArrayList<String>();
        List values = rec.getValues(field);
        if (values != null && values.size() > 0) {
            for (Value value : values) {
                result.add(value.getAsString());
            }
        }
        return result;
    }

    public static String getPrintableString(Record record) {
        StringBuilder result = new StringBuilder();
        result.append("\nPublication {\n");
        for (String field : record.getFields()) {
            result.append("--" + field + ":\n");
            List values = record.getValues(field);
            for (Value value : values) {
                result.append("\t" + value.getAsString() + "\n");
            }
        }
        result.append("}\n");
        return result.toString();
    }
}

