/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.Context;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierService;
import org.dspace.utils.DSpace;
import org.dspace.versioning.AbstractVersionProvider;
import org.dspace.versioning.ItemVersionProvider;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;

public class DefaultItemVersionProvider
extends AbstractVersionProvider
implements ItemVersionProvider {
    @Override
    public Item createNewItemAndAddItInWorkspace(Context context, Item nativeItem) {
        try {
            WorkspaceItem workspaceItem = WorkspaceItem.create(context, nativeItem.getOwningCollection(), false);
            Item itemNew = workspaceItem.getItem();
            itemNew.update();
            return itemNew;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void deleteVersionedItem(Context c, Version versionToDelete, VersionHistory history) {
        try {
            if (history.isLastVersion(versionToDelete) && history.size() > 1) {
                Item item = history.getPrevious(versionToDelete).getItem();
                item.setArchived(true);
                item.update();
            }
            IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
            Item itemToDelete = versionToDelete.getItem();
            identifierService.delete(c, itemToDelete);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IdentifierException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Item updateItemState(Context c, Item itemNew, Item previousItem) {
        try {
            this.copyMetadata(itemNew, previousItem);
            this.createBundlesAndAddBitstreams(c, itemNew, previousItem);
            IdentifierService identifierService = (IdentifierService)new DSpace().getSingletonService(IdentifierService.class);
            try {
                identifierService.reserve(c, itemNew);
            }
            catch (IdentifierException e) {
                throw new RuntimeException("Can't create Identifier!");
            }
            itemNew.update();
            return itemNew;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (AuthorizeException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

