/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sherpa;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.sherpa.SHERPAResponse;
import org.dspace.core.ConfigurationManager;

public class SHERPAService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SHERPAResponse searchByJournalISSN(String query) {
        String endpoint = ConfigurationManager.getProperty("sherpa.romeo.url");
        String apiKey = ConfigurationManager.getProperty("sherpa.romeo.apikey");
        GetMethod method = null;
        try {
            HttpClient client = new HttpClient();
            method = new GetMethod(endpoint);
            NameValuePair id = new NameValuePair("issn", query);
            NameValuePair versions = new NameValuePair("versions", "all");
            NameValuePair[] params = null;
            if (StringUtils.isNotBlank((String)apiKey)) {
                NameValuePair ak = new NameValuePair("ak", apiKey);
                params = new NameValuePair[]{id, versions, ak};
            } else {
                params = new NameValuePair[]{id, versions};
            }
            method.setQueryString(params);
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                SHERPAResponse sHERPAResponse = new SHERPAResponse("SHERPA/RoMEO return not OK status: " + statusCode);
                return sHERPAResponse;
            }
            SHERPAResponse sHERPAResponse = new SHERPAResponse(method.getResponseBodyAsStream());
            return sHERPAResponse;
        }
        catch (Exception e) {
            SHERPAResponse sHERPAResponse = new SHERPAResponse("Error processing the SHERPA/RoMEO answer");
            return sHERPAResponse;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

