/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.core.ConfigurationManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DCInputsReader {
    public static final String DEFAULT_COLLECTION = "default";
    static final String FORM_DEF_FILE = "input-forms.xml";
    static final String PAIR_TYPE_NAME = "value-pairs-name";
    private String defsFile = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "input-forms.xml";
    private Map<String, String> whichForms = null;
    private Map<String, List<List<Map<String, String>>>> formDefns = null;
    private Map<String, List<String>> valuePairs = null;
    private DCInputSet lastInputSet = null;

    public DCInputsReader() throws DCInputsReaderException {
        this.buildInputs(this.defsFile);
    }

    public DCInputsReader(String fileName) throws DCInputsReaderException {
        this.buildInputs(fileName);
    }

    private void buildInputs(String fileName) throws DCInputsReaderException {
        this.whichForms = new HashMap<String, String>();
        this.formDefns = new HashMap<String, List<List<Map<String, String>>>>();
        this.valuePairs = new HashMap<String, List<String>>();
        String uri = "file:" + new File(fileName).getAbsolutePath();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(uri);
            this.doNodes(doc);
            this.checkValues();
        }
        catch (FactoryConfigurationError fe) {
            throw new DCInputsReaderException("Cannot create Submission form parser", fe);
        }
        catch (Exception e) {
            throw new DCInputsReaderException("Error creating submission forms: " + e);
        }
    }

    public Iterator<String> getPairsNameIterator() {
        return this.valuePairs.keySet().iterator();
    }

    public List<String> getPairs(String name) {
        return this.valuePairs.get(name);
    }

    public DCInputSet getInputs(String collectionHandle) throws DCInputsReaderException {
        String formName = this.whichForms.get(collectionHandle);
        if (formName == null) {
            formName = this.whichForms.get(DEFAULT_COLLECTION);
        }
        if (formName == null) {
            throw new DCInputsReaderException("No form designated as default");
        }
        if (this.lastInputSet != null && this.lastInputSet.getFormName().equals(formName)) {
            return this.lastInputSet;
        }
        List<List<Map<String, String>>> pages = this.formDefns.get(formName);
        if (pages == null) {
            throw new DCInputsReaderException("Missing the " + formName + " form");
        }
        this.lastInputSet = new DCInputSet(formName, pages, this.valuePairs);
        return this.lastInputSet;
    }

    public int getNumberInputPages(String collectionHandle) throws DCInputsReaderException {
        return this.getInputs(collectionHandle).getNumberPages();
    }

    private void doNodes(Node n) throws SAXException, DCInputsReaderException {
        if (n == null) {
            return;
        }
        Node e = this.getElement(n);
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        boolean foundMap = false;
        boolean foundDefs = false;
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (nd == null || this.isEmptyTextNode(nd)) continue;
            String tagName = nd.getNodeName();
            if (tagName.equals("form-map")) {
                this.processMap(nd);
                foundMap = true;
                continue;
            }
            if (tagName.equals("form-definitions")) {
                this.processDefinition(nd);
                foundDefs = true;
                continue;
            }
            if (!tagName.equals("form-value-pairs")) continue;
            this.processValuePairs(nd);
        }
        if (!foundMap) {
            throw new DCInputsReaderException("No collection to form map found");
        }
        if (!foundDefs) {
            throw new DCInputsReaderException("No form definition found");
        }
    }

    private void processMap(Node e) throws SAXException {
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals("name-map")) continue;
            String id = this.getAttribute(nd, "collection-handle");
            String value = this.getAttribute(nd, "form-name");
            String content = this.getValue(nd);
            if (id == null) {
                throw new SAXException("name-map element is missing collection-handle attribute");
            }
            if (value == null) {
                throw new SAXException("name-map element is missing form-name attribute");
            }
            if (content != null && content.length() > 0) {
                throw new SAXException("name-map element has content, it should be empty.");
            }
            this.whichForms.put(id, value);
        }
    }

    private void processDefinition(Node e) throws SAXException, DCInputsReaderException {
        int numForms = 0;
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals("form")) continue;
            ++numForms;
            String formName = this.getAttribute(nd, "name");
            if (formName == null) {
                throw new SAXException("form element has no name attribute");
            }
            ArrayList pages = new ArrayList();
            this.formDefns.put(formName, pages);
            NodeList pl = nd.getChildNodes();
            int lenpg = pl.getLength();
            for (int j = 0; j < lenpg; ++j) {
                Node npg = pl.item(j);
                if (!npg.getNodeName().equals("page")) continue;
                String pgNum = this.getAttribute(npg, "number");
                if (pgNum == null) {
                    throw new SAXException("Form " + formName + " has no identified pages");
                }
                ArrayList<HashMap<String, String>> page = new ArrayList<HashMap<String, String>>();
                pages.add(page);
                NodeList flds = npg.getChildNodes();
                int lenflds = flds.getLength();
                for (int k = 0; k < lenflds; ++k) {
                    Node nfld = flds.item(k);
                    if (!nfld.getNodeName().equals("field")) continue;
                    HashMap<String, String> field = new HashMap<String, String>();
                    page.add(field);
                    this.processPageParts(formName, pgNum, nfld, field);
                }
            }
            if (pages.size() >= 1) continue;
            throw new DCInputsReaderException("Form " + formName + " has no pages");
        }
        if (numForms == 0) {
            throw new DCInputsReaderException("No form definition found");
        }
    }

    private void processPageParts(String formName, String page, Node n, Map<String, String> field) throws SAXException {
        String rpt;
        NodeList nl = n.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (this.isEmptyTextNode(nd)) continue;
            String tagName = nd.getNodeName();
            String value = this.getValue(nd);
            field.put(tagName, value);
            if (tagName.equals("input-type")) {
                if (!value.equals("dropdown") && !value.equals("qualdrop_value") && !value.equals("list")) continue;
                String pairTypeName = this.getAttribute(nd, PAIR_TYPE_NAME);
                if (pairTypeName == null) {
                    throw new SAXException("Form " + formName + ", field " + field.get("dc-element") + "." + field.get("dc-qualifier") + " has no name attribute");
                }
                field.put(PAIR_TYPE_NAME, pairTypeName);
                continue;
            }
            if (!tagName.equals("vocabulary")) continue;
            String closedVocabularyString = this.getAttribute(nd, "closed");
            field.put("closedVocabulary", closedVocabularyString);
        }
        String missing = null;
        if (field.get("dc-element") == null) {
            missing = "dc-element";
        }
        if (field.get("label") == null) {
            missing = "label";
        }
        if (field.get("input-type") == null) {
            missing = "input-type";
        }
        if (missing != null) {
            String msg = "Required field " + missing + " missing on page " + page + " of form " + formName;
            throw new SAXException(msg);
        }
        String type = field.get("input-type");
        if ((type.equals("twobox") || type.equals("qualdrop_value")) && ((rpt = field.get("repeatable")) == null || !rpt.equalsIgnoreCase("yes") && !rpt.equalsIgnoreCase("true"))) {
            String msg = "The field '" + field.get("label") + "' must be repeatable";
            throw new SAXException(msg);
        }
    }

    private String checkForDups(String formName, Map<String, String> field, List<List<Map<String, String>>> pages) {
        int matches = 0;
        String err = null;
        String schema = field.get("dc-schema");
        String elem = field.get("dc-element");
        String qual = field.get("dc-qualifier");
        if (schema == null || schema.equals("")) {
            schema = "dc";
        }
        for (int i = 0; i < pages.size(); ++i) {
            List<Map<String, String>> pg = pages.get(i);
            for (int j = 0; j < pg.size(); ++j) {
                Map<String, String> fld = pg.get(j);
                String schemaTest = fld.get("dc-schema") == null || fld.get("dc-schema").equals("") ? "dc" : fld.get("dc-schema");
                if (!fld.get("dc-element").equals(elem) || !schemaTest.equals(schema)) continue;
                String ql = fld.get("dc-qualifier");
                if (qual != null) {
                    if (ql == null || !ql.equals(qual)) continue;
                    ++matches;
                    continue;
                }
                if (ql != null) continue;
                ++matches;
            }
        }
        if (matches > 1) {
            err = "Duplicate field " + schema + "." + elem + "." + qual + " detected in form " + formName;
        }
        return err;
    }

    private void processValuePairs(Node e) throws SAXException {
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            String tagName = nd.getNodeName();
            if (!tagName.equals("value-pairs")) continue;
            String pairsName = this.getAttribute(nd, PAIR_TYPE_NAME);
            String dcTerm = this.getAttribute(nd, "dc-term");
            if (pairsName == null) {
                String errString = "Missing name attribute for value-pairs for DC term " + dcTerm;
                throw new SAXException(errString);
            }
            ArrayList<String> pairs = new ArrayList<String>();
            this.valuePairs.put(pairsName, pairs);
            NodeList cl = nd.getChildNodes();
            int lench = cl.getLength();
            for (int j = 0; j < lench; ++j) {
                Node nch = cl.item(j);
                String display = null;
                String storage = null;
                if (!nch.getNodeName().equals("pair")) continue;
                NodeList pl = nch.getChildNodes();
                int plen = pl.getLength();
                for (int k = 0; k < plen; ++k) {
                    Node vn = pl.item(k);
                    String vName = vn.getNodeName();
                    if (vName.equals("displayed-value")) {
                        display = this.getValue(vn);
                        continue;
                    }
                    if (!vName.equals("stored-value") || (storage = this.getValue(vn)) != null) continue;
                    storage = "";
                }
                pairs.add(display);
                pairs.add(storage);
            }
        }
    }

    private void checkValues() throws DCInputsReaderException {
        for (String idName : this.formDefns.keySet()) {
            List<List<Map<String, String>>> pages = this.formDefns.get(idName);
            for (int i = 0; i < pages.size(); ++i) {
                List<Map<String, String>> page = pages.get(i);
                for (int j = 0; j < page.size(); ++j) {
                    String pairsName;
                    List<String> v;
                    Map<String, String> fld = page.get(j);
                    String type = fld.get("input-type");
                    if (!type.equals("dropdown") && !type.equals("qualdrop_value") && !type.equals("list") || (v = this.valuePairs.get(pairsName = fld.get(PAIR_TYPE_NAME))) != null) continue;
                    String errString = "Cannot find value pairs for " + pairsName;
                    throw new DCInputsReaderException(errString);
                }
            }
        }
    }

    private Node getElement(Node nd) {
        NodeList nl = nd.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            return n;
        }
        return null;
    }

    private boolean isEmptyTextNode(Node nd) {
        String text;
        boolean isEmpty = false;
        if (nd.getNodeType() == 3 && (text = nd.getNodeValue().trim()).length() == 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    private String getAttribute(Node e, String name) {
        NamedNodeMap attrs = e.getAttributes();
        int len = attrs.getLength();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Node attr = attrs.item(i);
                if (!name.equals(attr.getNodeName())) continue;
                return attr.getNodeValue().trim();
            }
        }
        return null;
    }

    private String getValue(Node nd) {
        NodeList nl = nd.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            short type = n.getNodeType();
            if (type != 3) continue;
            return n.getNodeValue().trim();
        }
        return null;
    }
}

