/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class MetadataSchema {
    private static Logger log = Logger.getLogger(MetadataSchema.class);
    public static final int DC_SCHEMA_ID = 1;
    public static final String DC_SCHEMA = "dc";
    private TableRow row;
    private int schemaID;
    private String namespace;
    private String name;
    private static Map<Integer, MetadataSchema> id2schema = null;
    private static Map<String, MetadataSchema> name2schema = null;

    public MetadataSchema() {
    }

    public MetadataSchema(int schemaID, String namespace, String name) {
        this.schemaID = schemaID;
        this.namespace = namespace;
        this.name = name;
    }

    public MetadataSchema(String namespace, String name) {
        this.namespace = namespace;
        this.name = name;
    }

    public MetadataSchema(TableRow row) {
        if (row != null) {
            this.schemaID = row.getIntColumn("metadata_schema_id");
            this.namespace = row.getStringColumn("namespace");
            this.name = row.getStringColumn("short_id");
            this.row = row;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetadataSchema other = (MetadataSchema)obj;
        if (this.schemaID != other.schemaID) {
            return false;
        }
        return !(this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace));
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + this.schemaID;
        hash = 67 * hash + (this.namespace != null ? this.namespace.hashCode() : 0);
        return hash;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSchemaID() {
        return this.schemaID;
    }

    public void create(Context context) throws SQLException, AuthorizeException, NonUniqueMetadataException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        if (!this.uniqueShortName(context, this.name)) {
            throw new NonUniqueMetadataException("Please make the name " + this.name + " unique");
        }
        if (!this.uniqueNamespace(context, this.namespace)) {
            throw new NonUniqueMetadataException("Please make the namespace " + this.namespace + " unique");
        }
        this.row = DatabaseManager.row("MetadataSchemaRegistry");
        this.row.setColumn("namespace", this.namespace);
        this.row.setColumn("short_id", this.name);
        DatabaseManager.insert(context, this.row);
        MetadataSchema.decache();
        this.schemaID = this.row.getIntColumn("metadata_schema_id");
        log.info((Object)LogManager.getHeader(context, "create_metadata_schema", "metadata_schema_id=" + this.row.getIntColumn("metadata_schema_id")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataSchema findByNamespace(Context context, String namespace) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataSchemaRegistry", "SELECT * FROM MetadataSchemaRegistry WHERE namespace= ? ", namespace);
        TableRow row = null;
        try {
            if (tri.hasNext()) {
                row = tri.next();
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        if (row == null) {
            return null;
        }
        return new MetadataSchema(row);
    }

    public void update(Context context) throws SQLException, AuthorizeException, NonUniqueMetadataException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        if (!this.uniqueShortName(context, this.name)) {
            throw new NonUniqueMetadataException("Please make the name " + this.name + " unique");
        }
        if (!this.uniqueNamespace(context, this.namespace)) {
            throw new NonUniqueMetadataException("Please make the namespace " + this.namespace + " unique");
        }
        this.row.setColumn("namespace", this.getNamespace());
        this.row.setColumn("short_id", this.getName());
        DatabaseManager.update(context, this.row);
        MetadataSchema.decache();
        log.info((Object)LogManager.getHeader(context, "update_metadata_schema", "metadata_schema_id=" + this.getSchemaID() + "namespace=" + this.getNamespace() + "name=" + this.getName()));
    }

    public void delete(Context context) throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only administrators may modify the metadata registry");
        }
        log.info((Object)LogManager.getHeader(context, "delete_metadata_schema", "metadata_schema_id=" + this.getSchemaID()));
        DatabaseManager.delete(context, this.row);
        MetadataSchema.decache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataSchema[] findAll(Context context) throws SQLException {
        ArrayList<MetadataSchema> schemas = new ArrayList<MetadataSchema>();
        TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataSchemaRegistry", "SELECT * FROM MetadataSchemaRegistry ORDER BY metadata_schema_id", new Object[0]);
        try {
            while (tri.hasNext()) {
                schemas.add(new MetadataSchema(tri.next()));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        MetadataSchema[] typeArray = new MetadataSchema[schemas.size()];
        return schemas.toArray(typeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uniqueNamespace(Context context, String namespace) throws SQLException {
        int count = 0;
        Connection con = context.getDBConnection();
        Statement statement = null;
        ResultSet rs = null;
        try {
            TableRow reg = DatabaseManager.row("MetadataSchemaRegistry");
            String query = "SELECT COUNT(*) FROM " + reg.getTable() + " " + "WHERE metadata_schema_id != ? " + "AND namespace= ? ";
            statement = con.prepareStatement(query);
            statement.setInt(1, this.schemaID);
            statement.setString(2, namespace);
            rs = statement.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
        return count == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uniqueShortName(Context context, String name) throws SQLException {
        int count = 0;
        Connection con = context.getDBConnection();
        Statement statement = null;
        ResultSet rs = null;
        try {
            TableRow reg = DatabaseManager.row("MetadataSchemaRegistry");
            String query = "SELECT COUNT(*) FROM " + reg.getTable() + " " + "WHERE metadata_schema_id != ? " + "AND short_id = ? ";
            statement = con.prepareStatement(query);
            statement.setInt(1, this.schemaID);
            statement.setString(2, name);
            rs = statement.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle) {}
            }
        }
        return count == 0;
    }

    public static MetadataSchema find(Context context, int id) throws SQLException {
        Integer iid;
        if (!MetadataSchema.isCacheInitialized()) {
            MetadataSchema.initCache(context);
        }
        if (!id2schema.containsKey(iid = Integer.valueOf(id))) {
            return null;
        }
        return id2schema.get(iid);
    }

    public static MetadataSchema find(Context context, String shortName) throws SQLException {
        if (shortName == null) {
            return null;
        }
        if (!MetadataSchema.isCacheInitialized()) {
            MetadataSchema.initCache(context);
        }
        if (!name2schema.containsKey(shortName)) {
            return null;
        }
        return name2schema.get(shortName);
    }

    private static void decache() {
        id2schema = null;
        name2schema = null;
    }

    private static boolean isCacheInitialized() {
        return id2schema != null && name2schema != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initCache(Context context) throws SQLException {
        if (!MetadataSchema.isCacheInitialized()) {
            log.info((Object)"Loading schema cache for fast finds");
            HashMap<Integer, MetadataSchema> new_id2schema = new HashMap<Integer, MetadataSchema>();
            HashMap<String, MetadataSchema> new_name2schema = new HashMap<String, MetadataSchema>();
            TableRowIterator tri = DatabaseManager.queryTable(context, "MetadataSchemaRegistry", "SELECT * from MetadataSchemaRegistry", new Object[0]);
            try {
                while (tri.hasNext()) {
                    TableRow row = tri.next();
                    MetadataSchema s = new MetadataSchema(row);
                    new_id2schema.put(s.schemaID, s);
                    new_name2schema.put(s.name, s);
                }
            }
            finally {
                if (tri != null) {
                    tri.close();
                }
            }
            id2schema = new_id2schema;
            name2schema = new_name2schema;
        }
    }
}

