/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.dspace.core.ConfigurationManager;
import org.dspace.statistics.util.DnsLookup;
import org.dspace.statistics.util.IPTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiderDetector {
    private static Logger log = LoggerFactory.getLogger(SpiderDetector.class);
    private static Boolean useProxies;
    private static IPTable table;
    private static List<Pattern> agents;
    private static List<Pattern> domains;

    public static Set<String> readPatterns(File patternFile) throws IOException {
        String line;
        HashSet<String> patterns = new HashSet<String>();
        if (!patternFile.exists() || !patternFile.isFile()) {
            return patterns;
        }
        BufferedReader in = new BufferedReader(new FileReader(patternFile));
        while ((line = in.readLine()) != null) {
            if (line.startsWith("#") || (line = line.trim()).equals("")) continue;
            patterns.add(line);
        }
        in.close();
        return patterns;
    }

    public static Set<String> getSpiderIpAddresses() {
        SpiderDetector.loadSpiderIpAddresses();
        return table.toSet();
    }

    private static void loadSpiderIpAddresses() {
        block9: {
            if (table == null) {
                table = new IPTable();
                String filePath = ConfigurationManager.getProperty("dspace.dir");
                try {
                    File spidersDir = new File(filePath, "config/spiders");
                    if (spidersDir.exists() && spidersDir.isDirectory()) {
                        for (File file : spidersDir.listFiles()) {
                            if (!file.isFile()) continue;
                            for (String ip : SpiderDetector.readPatterns(file)) {
                                log.debug("Loading {}", (Object)ip);
                                if (!Character.isDigit(ip.charAt(0))) {
                                    try {
                                        ip = DnsLookup.forward(ip);
                                        log.debug("Resolved to {}", (Object)ip);
                                    }
                                    catch (IOException e) {
                                        log.warn("Not loading {}:  {}", (Object)ip, (Object)e.getMessage());
                                        continue;
                                    }
                                }
                                table.add(ip);
                            }
                            log.info("Loaded Spider IP file: " + file);
                        }
                        break block9;
                    }
                    log.info("No spider file loaded");
                }
                catch (Exception e) {
                    log.error("Error Loading Spiders:" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static void loadPatterns(String directory, List<Pattern> patternList) {
        String dspaceHome = ConfigurationManager.getProperty("dspace.dir");
        File spidersDir = new File(dspaceHome, "config/spiders");
        File patternsDir = new File(spidersDir, directory);
        if (patternsDir.exists() && patternsDir.isDirectory()) {
            for (File file : patternsDir.listFiles()) {
                Set<String> patterns;
                try {
                    patterns = SpiderDetector.readPatterns(file);
                }
                catch (IOException ex) {
                    log.error("Patterns not read from {}:  {}", (Object)file.getPath(), (Object)ex.getMessage());
                    continue;
                }
                for (String pattern : patterns) {
                    patternList.add(Pattern.compile(pattern));
                }
                log.info("Loaded pattern file:  {}", (Object)file.getPath());
            }
        } else {
            log.info("No patterns loaded from {}", (Object)patternsDir.getPath());
        }
    }

    public static boolean isSpider(String clientIP, String proxyIPs, String hostname, String agent) {
        if (null != agent) {
            if (agents.isEmpty()) {
                SpiderDetector.loadPatterns("agents", agents);
            }
            for (Pattern candidate : agents) {
                if (!candidate.matcher(agent).find()) continue;
                return true;
            }
        }
        if (SpiderDetector.isUseProxies() && proxyIPs != null) {
            for (String xfip : proxyIPs.split(",")) {
                if (!SpiderDetector.isSpider(xfip)) continue;
                return true;
            }
        }
        if (SpiderDetector.isSpider(clientIP)) {
            return true;
        }
        if (null != hostname) {
            if (domains.isEmpty()) {
                SpiderDetector.loadPatterns("domains", domains);
            }
            for (Pattern candidate : domains) {
                if (!candidate.matcher(hostname).find()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSpider(HttpServletRequest request) {
        return SpiderDetector.isSpider(request.getRemoteAddr(), request.getHeader("X-Forwarded-For"), request.getRemoteHost(), request.getHeader("User-Agent"));
    }

    public static boolean isSpider(String ip) {
        if (table == null) {
            SpiderDetector.loadSpiderIpAddresses();
        }
        try {
            if (table.contains(ip)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static boolean isUseProxies() {
        if (useProxies == null) {
            useProxies = "true".equals(ConfigurationManager.getProperty("useProxies")) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return useProxies;
    }

    static {
        table = null;
        agents = new ArrayList<Pattern>();
        domains = new ArrayList<Pattern>();
    }
}

