/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dspace.storage.rdbms.ColumnInfo;
import org.dspace.storage.rdbms.DatabaseManager;

public class TableRow {
    private static final Object NULL_OBJECT = new Object();
    private String table;
    private Map<String, Object> data = new HashMap<String, Object>();
    private Map<String, Boolean> changed = new HashMap<String, Boolean>();

    public TableRow(String table, List<String> columns) {
        this.table = table;
        for (String column : columns) {
            String canonicalized = ColumnInfo.canonicalize(column);
            this.data.put(canonicalized, NULL_OBJECT);
            this.changed.put(canonicalized, Boolean.TRUE);
        }
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public boolean hasColumn(String column) {
        try {
            return this.canonicalizeAndCheck(column) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean hasColumnChanged(String column) {
        return this.hasColumnChangedCanonicalized(ColumnInfo.canonicalize(column));
    }

    boolean hasColumnChangedCanonicalized(String column) {
        return this.changed.get(column) == Boolean.TRUE;
    }

    public boolean isColumnNull(String column) {
        return this.isColumnNullCanonicalized(this.canonicalizeAndCheck(column));
    }

    boolean isColumnNullCanonicalized(String column) {
        return this.data.get(column) == NULL_OBJECT;
    }

    public int getIntColumn(String column) {
        String canonicalized = this.canonicalizeAndCheck(column);
        if (this.isColumnNullCanonicalized(canonicalized)) {
            return -1;
        }
        Object value = this.data.get(canonicalized);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException("Value for " + column + " is not an integer");
        }
        return (Integer)value;
    }

    public long getLongColumn(String column) {
        String canonicalized = this.canonicalizeAndCheck(column);
        if (this.isColumnNullCanonicalized(canonicalized)) {
            return -1L;
        }
        Object value = this.data.get(canonicalized);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        if (!(value instanceof Long)) {
            throw new IllegalArgumentException("Value for " + column + " is not a long");
        }
        return (Long)value;
    }

    public double getDoubleColumn(String column) {
        String canonicalized = this.canonicalizeAndCheck(column);
        if (this.isColumnNullCanonicalized(canonicalized)) {
            return -1.0;
        }
        Object value = this.data.get(canonicalized);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (!(value instanceof Double)) {
            throw new IllegalArgumentException("Value for " + column + " is not a double");
        }
        return (Double)value;
    }

    public String getStringColumn(String column) {
        String canonicalized = this.canonicalizeAndCheck(column);
        if (this.isColumnNullCanonicalized(canonicalized)) {
            return null;
        }
        Object value = this.data.get(canonicalized);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Value is not an string");
        }
        return (String)value;
    }

    public boolean getBooleanColumn(String column) {
        String canonicalized = this.canonicalizeAndCheck(column);
        if (this.isColumnNullCanonicalized(canonicalized)) {
            return false;
        }
        Object value = this.data.get(canonicalized);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            return i != 0;
        }
        throw new IllegalArgumentException("Value is not a boolean or an integer");
    }

    public Date getDateColumn(String column) {
        String canonicalized = this.canonicalizeAndCheck(column);
        if (this.isColumnNullCanonicalized(canonicalized)) {
            return null;
        }
        Object value = this.data.get(canonicalized);
        if (value == null) {
            throw new IllegalArgumentException("Column " + column + " not present");
        }
        if (!(value instanceof Date)) {
            throw new IllegalArgumentException("Value is not a Date");
        }
        return (Date)value;
    }

    public void setColumnNull(String column) {
        String canonicalized = this.canonicalizeAndCheck(column);
        if (this.data.get(canonicalized) != NULL_OBJECT) {
            this.data.put(canonicalized, NULL_OBJECT);
            this.changed.put(canonicalized, Boolean.TRUE);
        }
    }

    public void setColumn(String column, boolean b) {
        String canonicalized = this.canonicalizeAndCheck(column);
        if (DatabaseManager.isOracle()) {
            Integer value;
            Integer n = value = b ? Integer.valueOf(1) : Integer.valueOf(0);
            if (!value.equals(this.data.get(canonicalized))) {
                this.data.put(canonicalized, value);
                this.changed.put(canonicalized, Boolean.TRUE);
            }
        } else {
            Boolean value;
            Boolean bl = value = b ? Boolean.TRUE : Boolean.FALSE;
            if (!value.equals(this.data.get(canonicalized))) {
                this.data.put(canonicalized, value);
                this.changed.put(canonicalized, Boolean.TRUE);
            }
        }
    }

    public void setColumn(String column, String s) {
        Object value;
        String canonicalized = this.canonicalizeAndCheck(column);
        Object object = value = s == null ? NULL_OBJECT : s;
        if (!value.equals(this.data.get(canonicalized))) {
            this.data.put(canonicalized, value);
            this.changed.put(canonicalized, Boolean.TRUE);
        }
    }

    public void setColumn(String column, int i) {
        String canonicalized = this.canonicalizeAndCheck(column);
        Integer value = i;
        if (!value.equals(this.data.get(canonicalized))) {
            this.data.put(canonicalized, value);
            this.changed.put(canonicalized, Boolean.TRUE);
        }
    }

    public void setColumn(String column, long l) {
        String canonicalized = this.canonicalizeAndCheck(column);
        Long value = l;
        if (!value.equals(this.data.get(canonicalized))) {
            this.data.put(canonicalized, value);
            this.changed.put(canonicalized, Boolean.TRUE);
        }
    }

    public void setColumn(String column, double d) {
        Double value = new Double(d);
        String canonicalized = this.canonicalizeAndCheck(column);
        if (!value.equals(this.data.get(canonicalized))) {
            this.data.put(canonicalized, value);
            this.changed.put(canonicalized, Boolean.TRUE);
        }
    }

    public void setColumn(String column, Date d) {
        Object value;
        String canonicalized = this.canonicalizeAndCheck(column);
        Object object = value = d == null ? NULL_OBJECT : d;
        if (!value.equals(this.data.get(canonicalized))) {
            this.data.put(canonicalized, value);
            this.changed.put(canonicalized, Boolean.TRUE);
        }
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuffer result = this.table == null ? new StringBuffer("no_table") : new StringBuffer(this.table);
        result.append(NEWLINE);
        for (String column : this.data.keySet()) {
            result.append("\t").append(column).append(" = ").append(this.isColumnNull(column) ? "NULL" : this.data.get(column)).append(NEWLINE);
        }
        return result.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TableRow)) {
            return false;
        }
        return this.data.equals(((TableRow)obj).data);
    }

    private String canonicalizeAndCheck(String column) {
        if (this.data.containsKey(column)) {
            return column;
        }
        String canonicalized = ColumnInfo.canonicalize(column);
        if (this.data.containsKey(canonicalized)) {
            return canonicalized;
        }
        throw new IllegalArgumentException("No such column '" + canonicalized + "'");
    }

    void resetChanged() {
        for (String column : this.changed.keySet()) {
            this.changed.put(column, Boolean.FALSE);
        }
    }
}

