/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.AbstractModifier;
import gr.ekt.bte.core.MutableRecord;
import gr.ekt.bte.core.Record;
import gr.ekt.bte.core.StringValue;
import gr.ekt.bte.core.Value;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ValueConcatenationModifier
extends AbstractModifier {
    private String field;
    private String separator = ",";
    private boolean whitespaceAfter = true;

    public ValueConcatenationModifier() {
        super("ValueConcatenationModifier");
    }

    public Record modify(MutableRecord rec) {
        List values = rec.getValues(this.field);
        if (values != null) {
            ArrayList<String> converted_values = new ArrayList<String>();
            for (Value val : values) {
                converted_values.add(val.getAsString());
            }
            ArrayList<StringValue> final_value = new ArrayList<StringValue>();
            String v = StringUtils.join(converted_values.iterator(), (String)(this.separator + (this.whitespaceAfter ? " " : "")));
            final_value.add(new StringValue(v));
            rec.updateField(this.field, final_value);
        }
        return rec;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isWhitespaceAfter() {
        return this.whitespaceAfter;
    }

    public void setWhitespaceAfter(boolean whiteSpaceAfter) {
        this.whitespaceAfter = whiteSpaceAfter;
    }
}

