/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import java.util.Set;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.storage.bitstore.BitstreamStorageManager;

public abstract class AbstractVersionProvider {
    private Set<String> ignoredMetadataFields;

    protected void copyMetadata(Item itemNew, Item nativeItem) {
        DCValue[] md;
        for (DCValue aMd : md = nativeItem.getMetadata("*", "*", "*", "*")) {
            String unqualifiedMetadataField = aMd.schema + "." + aMd.element;
            String qualifiedMetadataField = unqualifiedMetadataField + (aMd.qualifier == null ? "" : "." + aMd.qualifier);
            if (this.getIgnoredMetadataFields().contains(qualifiedMetadataField) || this.getIgnoredMetadataFields().contains(unqualifiedMetadataField + "." + "*")) continue;
            itemNew.addMetadata(aMd.schema, aMd.element, aMd.qualifier, aMd.language, aMd.value);
        }
    }

    protected void createBundlesAndAddBitstreams(Context c, Item itemNew, Item nativeItem) throws SQLException, AuthorizeException {
        for (Bundle nativeBundle : nativeItem.getBundles()) {
            Bundle bundleNew = itemNew.createBundle(nativeBundle.getName());
            for (Bitstream nativeBitstream : nativeBundle.getBitstreams()) {
                Bitstream bitstreamNew = this.createBitstream(c, nativeBitstream);
                bundleNew.addBitstream(bitstreamNew);
                if (nativeBundle.getPrimaryBitstreamID() != nativeBitstream.getID()) continue;
                bundleNew.setPrimaryBitstreamID(bitstreamNew.getID());
            }
        }
    }

    protected Bitstream createBitstream(Context context, Bitstream nativeBitstream) throws AuthorizeException, SQLException {
        int idNew = BitstreamStorageManager.clone(context, nativeBitstream.getID());
        return Bitstream.find(context, idNew);
    }

    public void setIgnoredMetadataFields(Set<String> ignoredMetadataFields) {
        this.ignoredMetadataFields = ignoredMetadataFields;
    }

    public Set getIgnoredMetadataFields() {
        return this.ignoredMetadataFields;
    }
}

