/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.identifier.DOI;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.IdentifierNotFoundException;
import org.dspace.identifier.IdentifierNotResolvableException;
import org.dspace.identifier.IdentifierProvider;
import org.dspace.identifier.doi.DOIConnector;
import org.dspace.identifier.doi.DOIIdentifierException;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class DOIIdentifierProvider
extends IdentifierProvider {
    private static final Logger log = LoggerFactory.getLogger(DOIIdentifierProvider.class);
    private DOIConnector connector;
    static final String CFG_PREFIX = "identifier.doi.prefix";
    static final String CFG_NAMESPACE_SEPARATOR = "identifier.doi.namespaceseparator";
    public static final String MD_SCHEMA = "dc";
    public static final String DOI_ELEMENT = "identifier";
    public static final String DOI_QUALIFIER = "uri";
    public static final Integer TO_BE_REGISTERED = 1;
    public static final Integer TO_BE_RESERVERED = 2;
    public static final Integer IS_REGISTERED = 3;
    public static final Integer IS_RESERVED = 4;
    public static final Integer UPDATE_RESERVERED = 5;
    public static final Integer UPDATE_REGISTERED = 6;
    public static final Integer UPDATE_BEFORE_REGISTERATION = 7;
    public static final Integer TO_BE_DELETED = 8;
    public static final Integer DELETED = 9;
    private String PREFIX;
    private String NAMESPACE_SEPARATOR;

    protected String getPrefix() {
        if (null == this.PREFIX) {
            this.PREFIX = this.configurationService.getProperty(CFG_PREFIX);
            if (null == this.PREFIX) {
                log.warn("Cannot find DOI prefix in configuration!");
                throw new RuntimeException("Unable to load DOI prefix from configuration. Cannot find property identifier.doi.prefix.");
            }
        }
        return this.PREFIX;
    }

    protected String getNamespaceSeparator() {
        if (null == this.NAMESPACE_SEPARATOR) {
            this.NAMESPACE_SEPARATOR = this.configurationService.getProperty(CFG_NAMESPACE_SEPARATOR);
            if (null == this.NAMESPACE_SEPARATOR) {
                this.NAMESPACE_SEPARATOR = "";
            }
        }
        return this.NAMESPACE_SEPARATOR;
    }

    @Required
    public void setDOIConnector(DOIConnector connector) {
        this.connector = connector;
    }

    @Override
    public boolean supports(Class<? extends Identifier> identifier) {
        return DOI.class.isAssignableFrom(identifier);
    }

    @Override
    public boolean supports(String identifier) {
        try {
            DOI.formatIdentifier(identifier);
        }
        catch (IdentifierException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    public String register(Context context, DSpaceObject dso) throws IdentifierException {
        String doi = this.mint(context, dso);
        this.register(context, dso, doi);
        return doi;
    }

    @Override
    public void register(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        String doi = DOI.formatIdentifier(identifier);
        TableRow doiRow = null;
        try {
            doiRow = this.loadOrCreateDOI(context, dso, doi);
        }
        catch (SQLException ex) {
            log.error("Error in databse connection: " + ex.getMessage());
            throw new RuntimeException("Error in database conncetion.", ex);
        }
        if (DELETED.intValue() == doiRow.getIntColumn("status") || TO_BE_DELETED.intValue() == doiRow.getIntColumn("status")) {
            throw new DOIIdentifierException("You tried to register a DOI that is marked as DELETED.", 13);
        }
        if (IS_REGISTERED.intValue() == doiRow.getIntColumn("status")) {
            return;
        }
        doiRow.setColumn("status", TO_BE_REGISTERED);
        try {
            DatabaseManager.update(context, doiRow);
            context.commit();
        }
        catch (SQLException sqle) {
            log.warn("SQLException while changing status of DOI {} to be registered.", (Object)doi);
            throw new RuntimeException(sqle);
        }
    }

    @Override
    public void reserve(Context context, DSpaceObject dso, String identifier) throws IdentifierException, IllegalArgumentException {
        String doi = DOI.formatIdentifier(identifier);
        TableRow doiRow = null;
        try {
            doiRow = this.loadOrCreateDOI(context, dso, doi);
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        if (!doiRow.isColumnNull("status")) {
            return;
        }
        doiRow.setColumn("status", TO_BE_RESERVERED);
        try {
            DatabaseManager.update(context, doiRow);
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
    }

    public void reserveOnline(Context context, DSpaceObject dso, String identifier) throws IdentifierException, IllegalArgumentException, SQLException {
        String doi = DOI.formatIdentifier(identifier);
        TableRow doiRow = this.loadOrCreateDOI(context, dso, doi);
        if (DELETED.intValue() == doiRow.getIntColumn("status") || TO_BE_DELETED.intValue() == doiRow.getIntColumn("status")) {
            throw new DOIIdentifierException("You tried to reserve a DOI that is marked as DELETED.", 13);
        }
        this.connector.reserveDOI(context, dso, doi);
        doiRow.setColumn("status", IS_RESERVED);
        DatabaseManager.update(context, doiRow);
    }

    public void registerOnline(Context context, DSpaceObject dso, String identifier) throws IdentifierException, IllegalArgumentException, SQLException {
        String doi = DOI.formatIdentifier(identifier);
        TableRow doiRow = this.loadOrCreateDOI(context, dso, doi);
        if (DELETED.intValue() == doiRow.getIntColumn("status") || TO_BE_DELETED.intValue() == doiRow.getIntColumn("status")) {
            throw new DOIIdentifierException("You tried to register a DOI that is marked as DELETED.", 13);
        }
        try {
            this.connector.registerDOI(context, dso, doi);
        }
        catch (DOIIdentifierException die) {
            if (die.getCode() == 6) {
                this.reserveOnline(context, dso, identifier);
                this.connector.registerDOI(context, dso, doi);
            }
            throw die;
        }
        try {
            this.saveDOIToObject(context, dso, doi);
        }
        catch (AuthorizeException ae) {
            throw new IdentifierException("Not authorized to save a DOI as metadata of an dso!", ae);
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        doiRow.setColumn("status", IS_REGISTERED);
        DatabaseManager.update(context, doiRow);
    }

    public void updateMetadata(Context context, DSpaceObject dso, String identifier) throws IdentifierException, IllegalArgumentException, SQLException {
        String doi = DOI.formatIdentifier(identifier);
        TableRow doiRow = null;
        doiRow = this.loadOrCreateDOI(context, dso, doi);
        if (DELETED.intValue() == doiRow.getIntColumn("status") || TO_BE_DELETED.intValue() == doiRow.getIntColumn("status")) {
            throw new DOIIdentifierException("You tried to register a DOI that is marked as DELETED.", 13);
        }
        if (IS_REGISTERED.intValue() == doiRow.getIntColumn("status")) {
            doiRow.setColumn("status", UPDATE_REGISTERED);
        } else if (TO_BE_REGISTERED.intValue() == doiRow.getIntColumn("status")) {
            doiRow.setColumn("status", UPDATE_BEFORE_REGISTERATION);
        } else if (IS_RESERVED.intValue() == doiRow.getIntColumn("status")) {
            doiRow.setColumn("status", UPDATE_RESERVERED);
        } else {
            return;
        }
        DatabaseManager.update(context, doiRow);
    }

    public void updateMetadataOnline(Context context, DSpaceObject dso, String identifier) throws IdentifierException, SQLException {
        String doi = DOI.formatIdentifier(identifier);
        TableRow doiRow = null;
        try {
            doiRow = DatabaseManager.findByUnique(context, "Doi", "doi", doi.substring("doi:".length()));
        }
        catch (SQLException sqle) {
            log.warn("SQLException while searching a DOI in our db.", (Throwable)sqle);
            throw new RuntimeException("Unable to retrieve information about a DOI out of database.", sqle);
        }
        if (null == doiRow) {
            log.error("Cannot update metadata for DOI {}: unable to find it in our db.", (Object)doi);
            throw new DOIIdentifierException("Unable to find DOI.", 1);
        }
        if (doiRow.getIntColumn("resource_id") != dso.getID() || doiRow.getIntColumn("resource_type_id") != dso.getType()) {
            log.error("Refuse to update metadata of DOI {} with the metadata of  an object ({}/{}) the DOI is not dedicated to.", (Object[])new String[]{doi, dso.getTypeText(), Integer.toString(dso.getID())});
            throw new DOIIdentifierException("Cannot update DOI metadata: DOI and DSpaceObject does not match!", 10);
        }
        if (DELETED.intValue() == doiRow.getIntColumn("status") || TO_BE_DELETED.intValue() == doiRow.getIntColumn("status")) {
            throw new DOIIdentifierException("You tried to update the metadataof a DOI that is marked as DELETED.", 13);
        }
        this.connector.updateMetadata(context, dso, doi);
        if (UPDATE_REGISTERED.intValue() == doiRow.getIntColumn("status")) {
            doiRow.setColumn("status", IS_REGISTERED);
        } else if (UPDATE_BEFORE_REGISTERATION.intValue() == doiRow.getIntColumn("status")) {
            doiRow.setColumn("status", TO_BE_REGISTERED);
        } else if (UPDATE_RESERVERED.intValue() == doiRow.getIntColumn("status")) {
            doiRow.setColumn("status", IS_RESERVED);
        }
        DatabaseManager.update(context, doiRow);
    }

    @Override
    public String mint(Context context, DSpaceObject dso) throws IdentifierException {
        String doi = null;
        try {
            doi = DOIIdentifierProvider.getDOIByObject(context, dso);
        }
        catch (SQLException e) {
            log.error("Error while attemping to retrieve information about a DOI for " + dso.getTypeText() + " with ID " + dso.getID() + ".");
            throw new RuntimeException("Error while attempting to retrieve information about a DOI for " + dso.getTypeText() + " with ID " + dso.getID() + ".", e);
        }
        if (null == doi) {
            try {
                TableRow doiRow = this.loadOrCreateDOI(context, dso, null);
                doi = "doi:" + doiRow.getStringColumn("doi");
            }
            catch (SQLException e) {
                log.error("Error while creating new DOI for Object of ResourceType {} with id {}.", (Object)dso.getType(), (Object)dso.getID());
                throw new RuntimeException("Error while attempting to create a new DOI for " + dso.getTypeText() + " with ID " + dso.getID() + ".", e);
            }
        }
        return doi;
    }

    @Override
    public DSpaceObject resolve(Context context, String identifier, String ... attributes) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        String doi = null;
        try {
            doi = DOI.formatIdentifier(identifier);
        }
        catch (IdentifierException e) {
            throw new IdentifierNotResolvableException(e);
        }
        try {
            DSpaceObject dso = DOIIdentifierProvider.getObjectByDOI(context, doi);
            if (null == dso) {
                throw new IdentifierNotFoundException();
            }
            return dso;
        }
        catch (SQLException sqle) {
            log.error("SQLException while searching a DOI in our db.", (Throwable)sqle);
            throw new RuntimeException("Unable to retrieve information about a DOI out of database.", sqle);
        }
        catch (IdentifierException e) {
            throw new IdentifierNotResolvableException(e);
        }
    }

    @Override
    public String lookup(Context context, DSpaceObject dso) throws IdentifierNotFoundException, IdentifierNotResolvableException {
        String doi = null;
        try {
            doi = DOIIdentifierProvider.getDOIByObject(context, dso);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving DOI out of database.", e);
        }
        if (null == doi) {
            throw new IdentifierNotFoundException("No DOI for DSpaceObject of type " + dso.getTypeText() + " with ID " + dso.getID() + " found.");
        }
        return doi;
    }

    @Override
    public void delete(Context context, DSpaceObject dso) throws IdentifierException {
        String doi;
        try {
            doi = DOIIdentifierProvider.getDOIByObject(context, dso);
            while (null != doi) {
                this.delete(context, dso, doi);
                doi = DOIIdentifierProvider.getDOIByObject(context, dso);
            }
        }
        catch (SQLException ex) {
            log.error("Error while attemping to retrieve information about a DOI for " + dso.getTypeText() + " with ID " + dso.getID() + ".", (Throwable)ex);
            throw new RuntimeException("Error while attempting to retrieve information about a DOI for " + dso.getTypeText() + " with ID " + dso.getID() + ".", ex);
        }
        try {
            doi = DOIIdentifierProvider.getDOIOutOfObject(dso);
            while (null != doi) {
                this.removeDOIFromObject(context, dso, doi);
                doi = DOIIdentifierProvider.getDOIOutOfObject(dso);
            }
        }
        catch (AuthorizeException ex) {
            log.error("Error while removing a DOI out of the metadata of an " + dso.getTypeText() + " with ID " + dso.getID() + ".", (Throwable)ex);
            throw new RuntimeException("Error while removing a DOI out of the metadata of an " + dso.getTypeText() + " with ID " + dso.getID() + ".", ex);
        }
        catch (SQLException ex) {
            log.error("Error while removing a DOI out of the metadata of an " + dso.getTypeText() + " with ID " + dso.getID() + ".", (Throwable)ex);
            throw new RuntimeException("Error while removing a DOI out of the metadata of an " + dso.getTypeText() + " with ID " + dso.getID() + ".", ex);
        }
    }

    @Override
    public void delete(Context context, DSpaceObject dso, String identifier) throws IdentifierException {
        String doi = DOI.formatIdentifier(identifier);
        TableRow doiRow = null;
        try {
            doiRow = DatabaseManager.findByUnique(context, "Doi", "doi", doi.substring("doi:".length()));
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        if (null != doiRow && (doiRow.getIntColumn("resource_id") != dso.getID() || doiRow.getIntColumn("resource_type_id") != dso.getType())) {
            throw new DOIIdentifierException("Trying to delete a DOI out of an object that is not addressed by the DOI.", 10);
        }
        try {
            this.removeDOIFromObject(context, dso, doi);
        }
        catch (AuthorizeException ex) {
            log.error("Not authorized to delete a DOI out of an Item.", (Throwable)ex);
            throw new DOIIdentifierException("Not authorized to delete DOI.", ex, 12);
        }
        catch (SQLException ex) {
            log.error("SQLException occured while deleting a DOI out of an item: " + ex.getMessage());
            throw new RuntimeException("Error while deleting a DOI out of the metadata of an Item " + dso.getID(), ex);
        }
        if (null != doiRow) {
            if (doiRow.isColumnNull("status")) {
                doiRow.setColumn("status", DELETED);
            } else {
                doiRow.setColumn("status", TO_BE_DELETED);
            }
            try {
                DatabaseManager.update(context, doiRow);
                context.commit();
            }
            catch (SQLException sqle) {
                log.warn("SQLException while changing status of DOI {} to be deleted.", (Object)doi);
                throw new RuntimeException(sqle);
            }
        }
    }

    public void deleteOnline(Context context, String identifier) throws DOIIdentifierException {
        String doi = DOI.formatIdentifier(identifier);
        TableRow doiRow = null;
        try {
            doiRow = DatabaseManager.findByUnique(context, "Doi", "doi", doi.substring("doi:".length()));
        }
        catch (SQLException sqle) {
            throw new RuntimeException(sqle);
        }
        if (null == doiRow) {
            throw new DOIIdentifierException("This identifier: " + identifier + " isn't in our database", 1);
        }
        if (TO_BE_DELETED.intValue() != doiRow.getIntColumn("status")) {
            log.error("This identifier: {} couldn't be deleted. Delete it first from metadata.", (Object)("doi:" + doiRow.getStringColumn("doi")));
            throw new IllegalArgumentException("Couldn't delete this identifier:doi:" + doiRow.getStringColumn("doi") + ". Delete it first from metadata.");
        }
        this.connector.deleteDOI(context, doi);
        doiRow.setColumn("status", DELETED);
        try {
            DatabaseManager.update(context, doiRow);
            context.commit();
        }
        catch (SQLException sqle) {
            log.warn("SQLException while changing status of DOI {} deleted.", (Object)doi);
            throw new RuntimeException(sqle);
        }
    }

    public static DSpaceObject getObjectByDOI(Context context, String identifier) throws SQLException, DOIIdentifierException, IllegalArgumentException {
        String doi = DOI.formatIdentifier(identifier);
        TableRow doiRow = DatabaseManager.findByUnique(context, "Doi", "doi", doi.substring("doi:".length()));
        if (null == doiRow) {
            return null;
        }
        if (doiRow.isColumnNull("resource_type_id") || doiRow.isColumnNull("resource_id")) {
            log.error("Found DOI " + doi + " in database, but no assigned Object could be found.");
            throw new IllegalStateException("Found DOI " + doi + " in database, but no assigned Object could be found.");
        }
        return DSpaceObject.find(context, doiRow.getIntColumn("resource_type_id"), doiRow.getIntColumn("resource_id"));
    }

    public static String getDOIByObject(Context context, DSpaceObject dso) throws SQLException {
        String sql = "SELECT * FROM Doi WHERE resource_type_id = ? AND resource_id = ? AND ((status != ? AND status != ?) OR status IS NULL)";
        TableRow doiRow = DatabaseManager.querySingleTable(context, "Doi", sql, dso.getType(), dso.getID(), TO_BE_DELETED, DELETED);
        if (null == doiRow) {
            return null;
        }
        if (doiRow.isColumnNull("doi")) {
            log.error("A DOI with an empty doi column was found in the database. DSO-Type: " + dso.getTypeText() + ", ID: " + dso.getID() + ".");
            throw new IllegalStateException("A DOI with an empty doi column was found in the database. DSO-Type: " + dso.getTypeText() + ", ID: " + dso.getID() + ".");
        }
        return "doi:" + doiRow.getStringColumn("doi");
    }

    protected TableRow loadOrCreateDOI(Context context, DSpaceObject dso, String doi) throws SQLException, DOIIdentifierException {
        TableRow doiRow = null;
        if (null != doi) {
            doiRow = DatabaseManager.findByUnique(context, "Doi", "doi", doi = doi.substring("doi:".length()));
            if (null != doiRow) {
                if (doiRow.getIntColumn("resource_id") == dso.getID() && doiRow.getIntColumn("resource_type_id") == dso.getType()) {
                    return doiRow;
                }
                throw new DOIIdentifierException("Trying to create a DOI that is already reserved for another object.", 2);
            }
            if (!doi.startsWith(this.getPrefix() + "/")) {
                throw new DOIIdentifierException("Trying to create a DOI that's not part of our Namespace!", 3);
            }
            doiRow = DatabaseManager.create(context, "Doi");
        } else {
            doiRow = DatabaseManager.create(context, "Doi");
            doi = this.getPrefix() + "/" + this.getNamespaceSeparator() + doiRow.getIntColumn("doi_id");
        }
        doiRow.setColumn("doi", doi);
        doiRow.setColumn("resource_type_id", dso.getType());
        doiRow.setColumn("resource_id", dso.getID());
        doiRow.setColumnNull("status");
        if (0 == DatabaseManager.update(context, doiRow)) {
            throw new RuntimeException("Cannot save DOI to databse for unkown reason.");
        }
        return doiRow;
    }

    public static String getDOIOutOfObject(DSpaceObject dso) throws DOIIdentifierException {
        DCValue[] metadata;
        if (!(dso instanceof Item)) {
            throw new IllegalArgumentException("We currently support DOIs for Items only, not for " + dso.getTypeText() + ".");
        }
        Item item = (Item)dso;
        for (DCValue id : metadata = item.getMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null)) {
            if (!id.value.startsWith("http://dx.doi.org/10.")) continue;
            return DOI.DOIFromExternalFormat(id.value);
        }
        return null;
    }

    protected void saveDOIToObject(Context context, DSpaceObject dso, String doi) throws SQLException, AuthorizeException, IdentifierException {
        if (!(dso instanceof Item)) {
            throw new IllegalArgumentException("We currently support DOIs for Items only, not for " + dso.getTypeText() + ".");
        }
        Item item = (Item)dso;
        item.addMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null, DOI.DOIToExternalForm(doi));
        try {
            item.update();
            context.commit();
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (AuthorizeException ex) {
            throw ex;
        }
    }

    protected void removeDOIFromObject(Context context, DSpaceObject dso, String doi) throws AuthorizeException, SQLException, IdentifierException {
        if (!(dso instanceof Item)) {
            throw new IllegalArgumentException("We currently support DOIs for Items only, not for " + dso.getTypeText() + ".");
        }
        Item item = (Item)dso;
        DCValue[] metadata = item.getMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null);
        ArrayList<String> remainder = new ArrayList<String>();
        for (DCValue id : metadata) {
            if (id.value.equals(DOI.DOIToExternalForm(doi))) continue;
            remainder.add(id.value);
        }
        item.clearMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null);
        item.addMetadata(MD_SCHEMA, DOI_ELEMENT, DOI_QUALIFIER, null, remainder.toArray(new String[remainder.size()]));
        try {
            item.update();
            context.commit();
        }
        catch (SQLException e) {
            throw e;
        }
        catch (AuthorizeException e) {
            throw e;
        }
    }
}

