/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class InProgressUser {
    private Context myContext;
    private TableRow myRow;

    InProgressUser(Context context, TableRow row) {
        this.myContext = context;
        this.myRow = row;
    }

    public static InProgressUser find(Context context, int id) throws SQLException {
        TableRow row = DatabaseManager.find(context, "cwf_in_progress_user", id);
        if (row == null) {
            return null;
        }
        return new InProgressUser(context, row);
    }

    public static InProgressUser findByWorkflowItemAndEPerson(Context context, int wfiID, int epersonID) throws SQLException {
        TableRow row = DatabaseManager.querySingleTable(context, "cwf_in_progress_user", "SELECT * FROM cwf_in_progress_user WHERE workflowitem_id= ? AND user_id= ?", wfiID, epersonID);
        if (row == null) {
            return null;
        }
        return new InProgressUser(context, row);
    }

    public static List<InProgressUser> findByEperson(Context context, int epersonID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_in_progress_user", "SELECT * FROM cwf_in_progress_user WHERE user_id = " + epersonID, new Object[0]);
        ArrayList<InProgressUser> list = new ArrayList<InProgressUser>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            list.add(new InProgressUser(context, row));
        }
        return list;
    }

    public static List<InProgressUser> findByWorkflowItem(Context c, int wfiID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "cwf_in_progress_user", "SELECT * FROM cwf_in_progress_user WHERE workflowitem_id=" + wfiID, new Object[0]);
        ArrayList<InProgressUser> list = new ArrayList<InProgressUser>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            list.add(new InProgressUser(c, row));
        }
        return list;
    }

    public static int getNumberOfInProgressUsers(Context c, int wfiID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "cwf_in_progress_user", "SELECT * FROM cwf_in_progress_user WHERE workflowitem_id=" + wfiID + " AND finished= '0'", new Object[0]);
        return tri.toList().size();
    }

    public static int getNumberOfFinishedUsers(Context c, int wfiID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "cwf_in_progress_user", "SELECT * FROM cwf_in_progress_user WHERE workflowitem_id=" + wfiID + " AND finished= '1'", new Object[0]);
        return tri.toList().size();
    }

    public static InProgressUser create(Context context) throws SQLException {
        TableRow row = DatabaseManager.create(context, "cwf_in_progress_user");
        return new InProgressUser(context, row);
    }

    public void delete() throws SQLException {
        DatabaseManager.delete(this.myContext, this.myRow);
    }

    public void update() throws SQLException {
        DatabaseManager.update(this.myContext, this.myRow);
    }

    public void setUserID(int userID) {
        this.myRow.setColumn("user_id", userID);
    }

    public int getUserID() {
        return this.myRow.getIntColumn("user_id");
    }

    public void setWorkflowItemID(int workflowItemID) {
        this.myRow.setColumn("workflowitem_id", workflowItemID);
    }

    public int getWorkflowItemID() {
        return this.myRow.getIntColumn("workflowitem_id");
    }

    public String getActionID() {
        return this.myRow.getStringColumn("action_id");
    }

    public void setWorkflowID(String workflowID) {
        this.myRow.setColumn("workflow_id", workflowID);
    }

    public String getWorkflowID() {
        return this.myRow.getStringColumn("workflow_id");
    }

    public boolean isFinished() {
        return this.myRow.getBooleanColumn("finished");
    }

    public void setFinished(boolean finished) {
        this.myRow.setColumn("finished", finished);
    }
}

