/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.dao;

import java.sql.SQLException;
import org.dspace.content.Bitstream;
import org.dspace.content.dao.ItemDAO;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class ItemDAOOracle
extends ItemDAO {
    private static final String selectPrimaryBitstreamID = "SELECT bundle.primary_bitstream_id FROM item2bundle, bundle WHERE item2bundle.item_id=? AND item2bundle.bundle_id=bundle.bundle_id AND bundle.name=?";
    private static final String selectFirstBitstreamID = "SELECT bundle2bitstream.bitstream_id FROM item2bundle, bundle, bundle2bitstream WHERE item2bundle.item_id=? AND item2bundle.bundle_id=bundle.bundle_id AND bundle.name=? AND bundle.bundle_id=bundle2bitstream.bundle_id";
    private static final String selectNamedBitstreamID = "SELECT bitstream.bitstream_id FROM item2bundle, bundle, bundle2bitstream, bitstream WHERE item2bundle.item_id=? AND item2bundle.bundle_id=bundle.bundle_id AND bundle.name=? AND bundle.bundle_id=bundle2bitstream.bundle_id AND bundle2bitstream.bitstream_id=bitstream.bitstream_id AND bitstream.name=?";

    ItemDAOOracle(Context ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitstream getPrimaryBitstream(int itemId, String bundleName) throws SQLException {
        TableRowIterator tri = null;
        try {
            tri = DatabaseManager.query(this.context, selectPrimaryBitstreamID, itemId, bundleName);
            if (tri.hasNext()) {
                TableRow row = tri.next();
                int bid = row.getIntColumn("primary_bitstream_id");
                Bitstream bitstream = Bitstream.find(this.context, bid);
                return bitstream;
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitstream getFirstBitstream(int itemId, String bundleName) throws SQLException {
        TableRowIterator tri = null;
        try {
            tri = DatabaseManager.query(this.context, selectFirstBitstreamID, itemId, bundleName);
            if (tri.hasNext()) {
                TableRow row = tri.next();
                int bid = row.getIntColumn("bitstream_id");
                Bitstream bitstream = Bitstream.find(this.context, bid);
                return bitstream;
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitstream getNamedBitstream(int itemId, String bundleName, String fileName) throws SQLException {
        TableRowIterator tri = null;
        try {
            tri = DatabaseManager.query(this.context, selectNamedBitstreamID, itemId, bundleName, fileName);
            if (tri.hasNext()) {
                TableRow row = tri.next();
                int bid = row.getIntColumn("bitstream_id");
                Bitstream bitstream = Bitstream.find(this.context, bid);
                return bitstream;
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return null;
    }
}

