/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.content.filter;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.dspace.statistics.content.filter.StatisticsFilter;

public class StatisticsSolrDateFilter
implements StatisticsFilter {
    private Date startDate;
    private Date endDate;
    private String startStr;
    private String endStr;
    private String typeStr;

    public void setStartStr(String startStr) {
        this.startStr = startStr;
    }

    public void setEndStr(String endStr) {
        this.endStr = endStr;
    }

    public void setTypeStr(String typeStr) {
        this.typeStr = typeStr;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate == null ? null : new Date(startDate.getTime());
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate == null ? null : new Date(endDate.getTime());
    }

    @Override
    public String toQuery() {
        if (this.startDate == null || this.endDate == null) {
            Calendar startCal = Calendar.getInstance();
            startCal.clear(14);
            startCal.clear(13);
            startCal.clear(12);
            startCal.set(11, 0);
            int dateType = -1;
            if (this.typeStr.equalsIgnoreCase("day")) {
                dateType = 5;
            } else if (this.typeStr.equalsIgnoreCase("month")) {
                dateType = 2;
                startCal.set(5, 1);
            } else if (this.typeStr.equalsIgnoreCase("year")) {
                startCal.clear(2);
                startCal.set(5, 1);
                dateType = 1;
            } else {
                return "";
            }
            Calendar endCal = (Calendar)startCal.clone();
            if (this.startDate == null) {
                if (this.startStr.startsWith("+")) {
                    this.startStr = this.startStr.substring(this.startStr.indexOf(43) + 1);
                }
                startCal.add(dateType, Integer.parseInt(this.startStr));
                this.startDate = startCal.getTime();
            }
            if (this.endDate == null) {
                if (this.endStr.startsWith("+")) {
                    this.endStr = this.endStr.substring(this.endStr.indexOf(43) + 1);
                }
                endCal.add(dateType, Integer.parseInt(this.endStr));
                this.endDate = endCal.getTime();
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        String startDateParsed = formatter.format(this.startDate);
        String endDateParsed = formatter.format(this.endDate);
        return "time:[" + startDateParsed + " TO " + endDateParsed + "]";
    }
}

