/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.state.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCValue;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.WorkflowException;
import org.dspace.xmlworkflow.XmlWorkflowManager;
import org.dspace.xmlworkflow.state.Step;
import org.dspace.xmlworkflow.state.actions.ActionResult;
import org.dspace.xmlworkflow.state.actions.processingaction.ProcessingAction;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class ScoreEvaluationAction
extends ProcessingAction {
    private int minimumAcceptanceScore;

    @Override
    public void activate(Context c, XmlWorkflowItem wf) throws SQLException, IOException, AuthorizeException, WorkflowException {
    }

    @Override
    public ActionResult execute(Context c, XmlWorkflowItem wfi, Step step, HttpServletRequest request) throws SQLException, AuthorizeException, IOException, WorkflowException {
        boolean hasPassed = false;
        DCValue[] scores = wfi.getItem().getMetadata("workflow", "score", null, "*");
        if (0 < scores.length) {
            int totalScoreCount = 0;
            for (DCValue score : scores) {
                totalScoreCount += Integer.parseInt(score.value);
            }
            int scoreMean = totalScoreCount / scores.length;
            hasPassed = this.getMinimumAcceptanceScore() <= scoreMean;
            wfi.getItem().clearMetadata("workflow", "score", null, "*");
            String provDescription = this.getProvenanceStartId() + " Approved for entry into archive with a score of: " + scoreMean;
            wfi.getItem().addMetadata("dc", "description", "provenance", "en", provDescription);
            wfi.getItem().update();
        }
        if (hasPassed) {
            return new ActionResult(ActionResult.TYPE.TYPE_OUTCOME, 0);
        }
        XmlWorkflowManager.sendWorkflowItemBackSubmission(c, wfi, c.getCurrentUser(), this.getProvenanceStartId(), "The item was reject due to a bad review score.");
        return new ActionResult(ActionResult.TYPE.TYPE_SUBMISSION_PAGE);
    }

    public int getMinimumAcceptanceScore() {
        return this.minimumAcceptanceScore;
    }

    public void setMinimumAcceptanceScore(int minimumAcceptanceScore) {
        this.minimumAcceptanceScore = minimumAcceptanceScore;
    }
}

