/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.util.Date;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class PolicySet {
    public static void main(String[] argv) throws Exception {
        if (argv.length < 6) {
            System.out.println("Args: containerType containerID contentType actionID groupID command [filter]");
            System.out.println("container=COLLECTION command = ADD|REPLACE");
            return;
        }
        int containertype = Integer.parseInt(argv[0]);
        int containerID = Integer.parseInt(argv[1]);
        int contenttype = Integer.parseInt(argv[2]);
        int actionID = Integer.parseInt(argv[3]);
        int groupID = Integer.parseInt(argv[4]);
        boolean isReplace = false;
        String command = argv[5];
        String filter = null;
        if (argv.length == 7) {
            filter = argv[6];
        }
        if (command.equals("REPLACE")) {
            isReplace = true;
        }
        Context c = new Context();
        c.setIgnoreAuthorization(true);
        PolicySet.setPoliciesFilter(c, containertype, containerID, contenttype, actionID, groupID, isReplace, false, filter);
        c.complete();
        System.exit(0);
    }

    public static void setPolicies(Context c, int containerType, int containerID, int contentType, int actionID, int groupID, boolean isReplace, boolean clearOnly) throws SQLException, AuthorizeException {
        PolicySet.setPoliciesFilter(c, containerType, containerID, contentType, actionID, groupID, isReplace, clearOnly, null, null, null, null, null);
    }

    public static void setPolicies(Context c, int containerType, int containerID, int contentType, int actionID, int groupID, boolean isReplace, boolean clearOnly, String name, String description, Date startDate, Date endDate) throws SQLException, AuthorizeException {
        PolicySet.setPoliciesFilter(c, containerType, containerID, contentType, actionID, groupID, isReplace, clearOnly, null, name, description, startDate, endDate);
    }

    public static void setPoliciesFilter(Context c, int containerType, int containerID, int contentType, int actionID, int groupID, boolean isReplace, boolean clearOnly, String filter) throws SQLException, AuthorizeException {
        PolicySet.setPoliciesFilter(c, containerType, containerID, contentType, actionID, groupID, isReplace, clearOnly, filter, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPoliciesFilter(Context c, int containerType, int containerID, int contentType, int actionID, int groupID, boolean isReplace, boolean clearOnly, String filter, String name, String description, Date startDate, Date endDate) throws SQLException, AuthorizeException {
        if (containerType == 3) {
            Collection collection = Collection.find(c, containerID);
            Group group = Group.find(c, groupID);
            ItemIterator i = collection.getItems();
            try {
                if (contentType == 2) {
                    while (i.hasNext()) {
                        Item myitem = i.next();
                        if (isReplace || clearOnly) {
                            AuthorizeManager.removeAllPolicies(c, myitem);
                        }
                        if (clearOnly || AuthorizeManager.isAnIdenticalPolicyAlreadyInPlace(c, myitem, groupID, actionID, -1)) continue;
                        ResourcePolicy rp = ResourcePolicy.create(c);
                        rp.setResource(myitem);
                        rp.setAction(actionID);
                        rp.setGroup(group);
                        rp.setRpName(name);
                        rp.setRpDescription(description);
                        rp.setStartDate(startDate);
                        rp.setEndDate(endDate);
                        rp.update();
                    }
                } else if (contentType == 1) {
                    while (i.hasNext()) {
                        Item myitem = i.next();
                        Bundle[] bundles = myitem.getBundles();
                        for (int j = 0; j < bundles.length; ++j) {
                            Bundle bundle = bundles[j];
                            if (isReplace || clearOnly) {
                                AuthorizeManager.removeAllPolicies(c, bundle);
                            }
                            if (clearOnly || AuthorizeManager.isAnIdenticalPolicyAlreadyInPlace(c, bundle, groupID, actionID, -1)) continue;
                            ResourcePolicy rp = ResourcePolicy.create(c);
                            rp.setResource(bundle);
                            rp.setAction(actionID);
                            rp.setGroup(group);
                            rp.setRpName(name);
                            rp.setRpDescription(description);
                            rp.setStartDate(startDate);
                            rp.setEndDate(endDate);
                            rp.update();
                        }
                    }
                } else if (contentType == 0) {
                    while (i.hasNext()) {
                        Item myitem = i.next();
                        System.out.println("Item " + myitem.getID());
                        Bundle[] bundles = myitem.getBundles();
                        for (int j = 0; j < bundles.length; ++j) {
                            System.out.println("Bundle " + bundles[j].getID());
                            Bitstream[] bitstreams = bundles[j].getBitstreams();
                            for (int k = 0; k < bitstreams.length; ++k) {
                                Bitstream bitstream = bitstreams[k];
                                if (filter != null && bitstream.getName().indexOf(filter) == -1) continue;
                                if (isReplace || clearOnly) {
                                    AuthorizeManager.removeAllPolicies(c, bitstream);
                                }
                                if (clearOnly || AuthorizeManager.isAnIdenticalPolicyAlreadyInPlace(c, bitstream, groupID, actionID, -1)) continue;
                                ResourcePolicy rp = ResourcePolicy.create(c);
                                rp.setResource(bitstream);
                                rp.setAction(actionID);
                                rp.setGroup(group);
                                rp.setRpName(name);
                                rp.setRpDescription(description);
                                rp.setStartDate(startDate);
                                rp.setEndDate(endDate);
                                rp.update();
                            }
                        }
                    }
                }
            }
            finally {
                if (i != null) {
                    i.close();
                }
            }
        }
    }
}

