/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.log4j.Logger;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SHERPARoMEOProtocol
implements ChoiceAuthority {
    private static Logger log = Logger.getLogger(SHERPARoMEOProtocol.class);
    private static String url = null;

    public SHERPARoMEOProtocol() {
        if (url == null && (url = ConfigurationManager.getProperty("sherpa.romeo.url")) == null) {
            throw new IllegalStateException("Missing DSpace configuration keys for SHERPA/RoMEO Query");
        }
    }

    public abstract Choices getMatches(String var1, int var2, int var3, int var4, String var5);

    @Override
    public Choices getBestMatch(String field, String text, int collection, String locale) {
        return this.getMatches(field, text, collection, 0, 2, locale);
    }

    @Override
    public String getLabel(String field, String key, String locale) {
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Choices query(String result, String label, String authority, NameValuePair[] args, int start, int limit) {
        HttpClient hc = new HttpClient();
        String srUrl = url + "?" + EncodingUtil.formUrlEncode((NameValuePair[])args, (String)"UTF8");
        GetMethod get = new GetMethod(srUrl);
        log.debug((Object)("Trying SHERPA/RoMEO Query, URL=" + srUrl));
        try {
            int status = hc.executeMethod((HttpMethod)get);
            if (status == 200) {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                SAXParser sp = spf.newSAXParser();
                XMLReader xr = sp.getXMLReader();
                SRHandler handler = new SRHandler(result, label, authority);
                xr.setFeature("http://xml.org/sax/features/namespaces", true);
                xr.setContentHandler(handler);
                xr.setErrorHandler(handler);
                xr.parse(new InputSource(get.getResponseBodyAsStream()));
                int confidence = handler.total == 0 ? 300 : (handler.total == 1 ? 500 : 400);
                Choices choices = new Choices(handler.result, start, handler.total, confidence, false);
                return choices;
            }
        }
        catch (HttpException e) {
            log.error((Object)"SHERPA/RoMEO query failed: ", (Throwable)e);
            Choices choices = null;
            return choices;
        }
        catch (IOException e) {
            log.error((Object)"SHERPA/RoMEO query failed: ", (Throwable)e);
            Choices choices = null;
            return choices;
        }
        catch (ParserConfigurationException e) {
            log.warn((Object)"Failed parsing SHERPA/RoMEO result: ", (Throwable)e);
            Choices choices = null;
            return choices;
        }
        catch (SAXException e) {
            log.warn((Object)"Failed parsing SHERPA/RoMEO result: ", (Throwable)e);
            Choices choices = null;
            return choices;
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    private static class SRHandler
    extends DefaultHandler {
        private Choice[] result = null;
        int rindex = 0;
        int total = 0;
        private String resultElement = null;
        private String labelElement = null;
        private String authorityElement = null;
        protected String textValue = null;

        public SRHandler(String result, String label, String authority) {
            this.resultElement = result;
            this.labelElement = label;
            this.authorityElement = authority;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String newValue = new String(ch, start, length);
            if (newValue.length() > 0) {
                this.textValue = this.textValue == null ? newValue : this.textValue + newValue;
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("numhits")) {
                String stotal = this.textValue.trim();
                if (stotal.length() > 0) {
                    this.total = Integer.parseInt(stotal);
                    this.result = new Choice[this.total];
                    if (this.total > 0) {
                        this.result[0] = new Choice();
                        log.debug((Object)("Got " + this.total + " records in results."));
                    }
                }
            } else if (localName.equals(this.resultElement)) {
                if (++this.rindex < this.result.length) {
                    this.result[this.rindex] = new Choice();
                }
            } else if (localName.equals(this.labelElement) && this.textValue != null) {
                this.result[this.rindex].label = this.result[this.rindex].value = this.textValue.trim();
            } else if (this.authorityElement != null && localName.equals(this.authorityElement) && this.textValue != null) {
                this.result[this.rindex].authority = this.textValue.trim();
            } else if (localName.equals("message") && this.textValue != null) {
                log.warn((Object)("SHERPA/RoMEO response error message: " + this.textValue.trim()));
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.textValue = null;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }
    }
}

