/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.curate.AbstractCurationTask;

public class BasicLinkChecker
extends AbstractCurationTask {
    private int status = -2;
    private List<String> results = null;
    private static Logger log = Logger.getLogger(BasicLinkChecker.class);

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        StringBuilder results = new StringBuilder();
        this.status = 2;
        if (dso instanceof Item) {
            Item item = (Item)dso;
            List<String> urls = this.getURLs(item);
            this.status = 2;
            results.append("Item: ").append(BasicLinkChecker.getItemHandle(item)).append("\n");
            for (String url : urls) {
                boolean ok = this.checkURL(url, results);
                if (ok) {
                    this.status = 0;
                    continue;
                }
                this.status = 1;
            }
        }
        this.setResult(results.toString());
        this.report(results.toString());
        return this.status;
    }

    protected List<String> getURLs(Item item) {
        DCValue[] urls = item.getMetadata("*", "*", "uri", "*");
        ArrayList<String> theURLs = new ArrayList<String>();
        for (DCValue url : urls) {
            theURLs.add(url.value);
        }
        return theURLs;
    }

    protected boolean checkURL(String url, StringBuilder results) {
        int httpStatus = this.getResponseStatus(url);
        if (httpStatus >= 200 && httpStatus < 300) {
            results.append(" - " + url + " = " + httpStatus + " - OK\n");
            return true;
        }
        results.append(" - " + url + " = " + httpStatus + " - FAILED\n");
        return false;
    }

    protected int getResponseStatus(String url) {
        try {
            URL theURL = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)theURL.openConnection();
            int code = connection.getResponseCode();
            connection.disconnect();
            return code;
        }
        catch (IOException ioe) {
            log.debug((Object)("Bad link: " + ioe.getMessage()));
            return 0;
        }
    }

    private static String getItemHandle(Item item) {
        String handle = item.getHandle();
        return handle != null ? handle : " in workflow";
    }
}

