/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCPersonName;
import org.dspace.content.DCSeriesNumber;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.MetadataAuthorityManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.submit.AbstractProcessingStep;

public class DescribeStep
extends AbstractProcessingStep {
    private static Logger log = Logger.getLogger(DescribeStep.class);
    private static DCInputsReader inputsReader = null;
    public static final int STATUS_MORE_INPUT_REQUESTED = 1;
    public static final int STATUS_MISSING_REQUIRED_FIELDS = 2;
    public static final String LANGUAGE_QUALIFIER = DescribeStep.getDefaultLanguageQualifier();

    public DescribeStep() throws ServletException {
        DescribeStep.getInputsReader();
    }

    @Override
    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String qualifier;
        if (!request.getParameterNames().hasMoreElements()) {
            return 1;
        }
        String buttonPressed = Util.getSubmitButton(request, "submit_next");
        Item item = subInfo.getSubmissionItem().getItem();
        int currentPage = DescribeStep.getCurrentPage(request);
        Collection c = subInfo.getSubmissionItem().getCollection();
        DCInput[] inputs = null;
        try {
            inputs = inputsReader.getInputs(c.getHandle()).getPageRows(currentPage - 1, subInfo.getSubmissionItem().hasMultipleTitles(), subInfo.getSubmissionItem().isPublishedBefore());
        }
        catch (DCInputsReaderException e) {
            throw new ServletException((Throwable)e);
        }
        String documentType = "";
        if (item.getMetadata("dc.type") != null && item.getMetadata("dc.type").length > 0) {
            documentType = item.getMetadata((String)"dc.type")[0].value;
        }
        for (int i = 0; i < inputs.length; ++i) {
            if (!inputs[i].isVisible(subInfo.isInWorkflow() ? "workflow" : "submit")) continue;
            String qualifier2 = inputs[i].getQualifier();
            if (qualifier2 == null && inputs[i].getInputType().equals("qualdrop_value")) {
                qualifier2 = "*";
            }
            item.clearMetadata(inputs[i].getSchema(), inputs[i].getElement(), qualifier2, "*");
        }
        DescribeStep.clearErrorFields(request);
        boolean moreInput = false;
        for (int j = 0; j < inputs.length; ++j) {
            if (!inputs[j].isAllowedFor(documentType) || !inputs[j].isVisible(subInfo.isInWorkflow() ? "workflow" : "submit")) continue;
            String element = inputs[j].getElement();
            qualifier = inputs[j].getQualifier();
            String schema = inputs[j].getSchema();
            String fieldName = qualifier != null && !qualifier.equals("*") ? schema + "_" + element + '_' + qualifier : schema + "_" + element;
            String fieldKey = MetadataAuthorityManager.makeFieldKey(schema, element, qualifier);
            ChoiceAuthorityManager cmgr = ChoiceAuthorityManager.getManager();
            String inputType = inputs[j].getInputType();
            if (inputType.equals("name")) {
                this.readNames(request, item, schema, element, qualifier, inputs[j].getRepeatable());
            } else if (inputType.equals("date")) {
                this.readDate(request, item, schema, element, qualifier);
            } else if (inputType.equals("dropdown") || inputType.equals("list") || cmgr.isChoicesConfigured(fieldKey) && "select".equals(cmgr.getPresentation(fieldKey))) {
                String[] vals = request.getParameterValues(fieldName);
                if (vals != null) {
                    for (int z = 0; z < vals.length; ++z) {
                        if (vals[z].equals("")) continue;
                        item.addMetadata(schema, element, qualifier, LANGUAGE_QUALIFIER, vals[z]);
                    }
                }
            } else if (inputType.equals("series")) {
                this.readSeriesNumbers(request, item, schema, element, qualifier, inputs[j].getRepeatable());
            } else if (inputType.equals("qualdrop_value")) {
                List<String> quals = this.getRepeatedParameter(request, schema + "_" + element, schema + "_" + element + "_qualifier");
                List<String> vals = this.getRepeatedParameter(request, schema + "_" + element, schema + "_" + element + "_value");
                for (int z = 0; z < vals.size(); ++z) {
                    String thisQual = quals.get(z);
                    if ("".equals(thisQual)) {
                        thisQual = null;
                    }
                    String thisVal = vals.get(z);
                    if (buttonPressed.equals("submit_" + schema + "_" + element + "_remove_" + z) || thisVal.equals("")) continue;
                    item.addMetadata(schema, element, thisQual, null, thisVal);
                }
            } else if (inputType.equals("onebox") || inputType.equals("twobox") || inputType.equals("textarea")) {
                this.readText(request, item, schema, element, qualifier, inputs[j].getRepeatable(), LANGUAGE_QUALIFIER);
            } else {
                throw new ServletException("Field " + fieldName + " has an unknown input type: " + inputType);
            }
            if (!moreInput && buttonPressed.equals("submit_" + fieldName + "_add")) {
                subInfo.setMoreBoxesFor(fieldName);
                subInfo.setJumpToField(fieldName);
                moreInput = true;
                continue;
            }
            if (!buttonPressed.equals("submit_" + fieldName + "_delete")) continue;
            subInfo.setJumpToField(fieldName);
        }
        if (buttonPressed.equals("submit_next") || buttonPressed.startsWith("submit_jump_") || buttonPressed.equals("submit_prev") || buttonPressed.equals("submit_cancel")) {
            for (int i = 0; i < inputs.length; ++i) {
                String scope;
                String string = scope = subInfo.isInWorkflow() ? "workflow" : "submit";
                if (!inputs[i].isVisible(scope) || !inputs[i].isAllowedFor(documentType)) continue;
                qualifier = inputs[i].getQualifier();
                if (qualifier == null && inputs[i].getInputType().equals("qualdrop_value")) {
                    qualifier = "*";
                }
                DCValue[] values = item.getMetadata(inputs[i].getSchema(), inputs[i].getElement(), qualifier, "*");
                if (!inputs[i].isRequired() || values.length != 0 || !inputs[i].isVisible(subInfo.isInWorkflow() ? "workflow" : "submit")) continue;
                DescribeStep.addErrorField(request, DescribeStep.getFieldName(inputs[i]));
            }
        }
        subInfo.getSubmissionItem().update();
        context.commit();
        if (moreInput) {
            return 1;
        }
        if (DescribeStep.getErrorFields(request) != null && DescribeStep.getErrorFields(request).size() > 0) {
            return 2;
        }
        return 0;
    }

    @Override
    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        String collectionHandle = "default";
        if (subInfo.getSubmissionItem() != null) {
            collectionHandle = subInfo.getSubmissionItem().getCollection().getHandle();
        }
        try {
            return DescribeStep.getInputsReader().getNumberInputPages(collectionHandle);
        }
        catch (DCInputsReaderException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static DCInputsReader getInputsReader() throws ServletException {
        if (inputsReader == null) {
            try {
                inputsReader = new DCInputsReader();
            }
            catch (DCInputsReaderException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return inputsReader;
    }

    public static DCInputsReader getInputsReader(String filename) throws ServletException {
        try {
            inputsReader = new DCInputsReader(filename);
        }
        catch (DCInputsReaderException e) {
            throw new ServletException((Throwable)e);
        }
        return inputsReader;
    }

    public static String getDefaultLanguageQualifier() {
        String language = "";
        language = ConfigurationManager.getProperty("default.language");
        if (StringUtils.isEmpty((String)language)) {
            language = "en";
        }
        return language;
    }

    protected void readNames(HttpServletRequest request, Item item, String schema, String element, String qualifier, boolean repeated) {
        String metadataField = MetadataField.formKey(schema, element, qualifier);
        String fieldKey = MetadataAuthorityManager.makeFieldKey(schema, element, qualifier);
        boolean isAuthorityControlled = MetadataAuthorityManager.getManager().isAuthorityControlled(fieldKey);
        List<Object> firsts = new LinkedList();
        List<Object> lasts = new LinkedList();
        List<Object> auths = new LinkedList();
        List<Object> confs = new LinkedList();
        if (repeated) {
            String removeButton;
            String buttonPressed;
            firsts = this.getRepeatedParameter(request, metadataField, metadataField + "_first");
            lasts = this.getRepeatedParameter(request, metadataField, metadataField + "_last");
            if (isAuthorityControlled) {
                auths = this.getRepeatedParameter(request, metadataField, metadataField + "_authority");
                confs = this.getRepeatedParameter(request, metadataField, metadataField + "_confidence");
            }
            if ((buttonPressed = Util.getSubmitButton(request, "")).startsWith(removeButton = "submit_" + metadataField + "_remove_")) {
                int valToRemove = Integer.parseInt(buttonPressed.substring(removeButton.length()));
                firsts.remove(valToRemove);
                lasts.remove(valToRemove);
                if (isAuthorityControlled) {
                    auths.remove(valToRemove);
                    confs.remove(valToRemove);
                }
            }
        } else {
            String lastName = request.getParameter(metadataField + "_last");
            String firstNames = request.getParameter(metadataField + "_first");
            String authority = request.getParameter(metadataField + "_authority");
            String confidence = request.getParameter(metadataField + "_confidence");
            if (lastName != null) {
                lasts.add(lastName);
            }
            if (firstNames != null) {
                firsts.add(firstNames);
            }
            auths.add(authority == null ? "" : authority);
            confs.add(confidence == null ? "" : confidence);
        }
        for (int i = 0; i < lasts.size(); ++i) {
            int comma;
            String f = (String)firsts.get(i);
            String l = (String)lasts.get(i);
            if (l == null || l.trim().equals("")) continue;
            if (f == null) {
                f = "";
            }
            if ((comma = l.indexOf(44)) >= 0) {
                f = f + l.substring(comma + 1);
                l = l.substring(0, comma);
                while (f.startsWith(" ")) {
                    f = f.substring(1);
                }
            }
            if (isAuthorityControlled) {
                String sconf;
                String authKey = auths.size() > i ? (String)auths.get(i) : null;
                String string = sconf = authKey != null && confs.size() > i ? (String)confs.get(i) : null;
                if (MetadataAuthorityManager.getManager().isAuthorityRequired(fieldKey) && (authKey == null || authKey.length() == 0)) {
                    log.warn((Object)("Skipping value of " + metadataField + " because the required Authority key is missing or empty."));
                    DescribeStep.addErrorField(request, metadataField);
                    continue;
                }
                item.addMetadata(schema, element, qualifier, null, new DCPersonName(l, f).toString(), authKey, sconf != null && sconf.length() > 0 ? Choices.getConfidenceValue(sconf) : 600);
                continue;
            }
            item.addMetadata(schema, element, qualifier, null, new DCPersonName(l, f).toString());
        }
    }

    protected void readText(HttpServletRequest request, Item item, String schema, String element, String qualifier, boolean repeated, String lang) {
        String metadataField = MetadataField.formKey(schema, element, qualifier);
        String fieldKey = MetadataAuthorityManager.makeFieldKey(schema, element, qualifier);
        boolean isAuthorityControlled = MetadataAuthorityManager.getManager().isAuthorityControlled(fieldKey);
        List<Object> vals = null;
        List<Object> auths = null;
        List<Object> confs = null;
        if (repeated) {
            String removeButton;
            String buttonPressed;
            vals = this.getRepeatedParameter(request, metadataField, metadataField);
            if (isAuthorityControlled) {
                auths = this.getRepeatedParameter(request, metadataField, metadataField + "_authority");
                confs = this.getRepeatedParameter(request, metadataField, metadataField + "_confidence");
            }
            if ((buttonPressed = Util.getSubmitButton(request, "")).startsWith(removeButton = "submit_" + metadataField + "_remove_")) {
                int valToRemove = Integer.parseInt(buttonPressed.substring(removeButton.length()));
                vals.remove(valToRemove);
                if (isAuthorityControlled) {
                    auths.remove(valToRemove);
                    confs.remove(valToRemove);
                }
            }
        } else {
            vals = new LinkedList();
            String value = request.getParameter(metadataField);
            if (value != null) {
                vals.add(value.trim());
            }
            if (isAuthorityControlled) {
                auths = new LinkedList();
                confs = new LinkedList();
                String av = request.getParameter(metadataField + "_authority");
                String cv = request.getParameter(metadataField + "_confidence");
                auths.add(av == null ? "" : av.trim());
                confs.add(cv == null ? "" : cv.trim());
            }
        }
        for (int i = 0; i < vals.size(); ++i) {
            String s = (String)vals.get(i);
            if (s == null || s.equals("")) continue;
            if (isAuthorityControlled) {
                String sconf;
                String authKey = auths.size() > i ? (String)auths.get(i) : null;
                String string = sconf = authKey != null && confs.size() > i ? (String)confs.get(i) : null;
                if (MetadataAuthorityManager.getManager().isAuthorityRequired(fieldKey) && (authKey == null || authKey.length() == 0)) {
                    log.warn((Object)("Skipping value of " + metadataField + " because the required Authority key is missing or empty."));
                    DescribeStep.addErrorField(request, metadataField);
                    continue;
                }
                item.addMetadata(schema, element, qualifier, lang, s, authKey, sconf != null && sconf.length() > 0 ? Choices.getConfidenceValue(sconf) : 600);
                continue;
            }
            item.addMetadata(schema, element, qualifier, lang, s);
        }
    }

    protected void readDate(HttpServletRequest request, Item item, String schema, String element, String qualifier) throws SQLException {
        String metadataField = MetadataField.formKey(schema, element, qualifier);
        int year = Util.getIntParameter(request, metadataField + "_year");
        int month = Util.getIntParameter(request, metadataField + "_month");
        int day = Util.getIntParameter(request, metadataField + "_day");
        DCDate d = new DCDate(year, month, day, -1, -1, -1);
        if (year > 0) {
            item.addMetadata(schema, element, qualifier, null, d.toString());
        }
    }

    protected void readSeriesNumbers(HttpServletRequest request, Item item, String schema, String element, String qualifier, boolean repeated) {
        String metadataField = MetadataField.formKey(schema, element, qualifier);
        List<Object> series = new LinkedList();
        List<Object> numbers = new LinkedList();
        if (repeated) {
            String removeButton;
            series = this.getRepeatedParameter(request, metadataField, metadataField + "_series");
            numbers = this.getRepeatedParameter(request, metadataField, metadataField + "_number");
            String buttonPressed = Util.getSubmitButton(request, "");
            if (buttonPressed.startsWith(removeButton = "submit_" + metadataField + "_remove_")) {
                int valToRemove = Integer.parseInt(buttonPressed.substring(removeButton.length()));
                series.remove(valToRemove);
                numbers.remove(valToRemove);
            }
        } else {
            String s = request.getParameter(metadataField + "_series");
            String n = request.getParameter(metadataField + "_number");
            if (s != null && !s.equals("")) {
                if (n == null) {
                    n = "";
                }
                series.add(s);
                numbers.add(n);
            }
        }
        for (int i = 0; i < series.size(); ++i) {
            String s = ((String)series.get(i)).trim();
            String n = ((String)numbers.get(i)).trim();
            if (s.equals("") && n.equals("")) continue;
            item.addMetadata(schema, element, qualifier, null, new DCSeriesNumber(s, n).toString());
        }
    }

    protected List<String> getRepeatedParameter(HttpServletRequest request, String metadataField, String param) {
        LinkedList<String> vals = new LinkedList<String>();
        int i = 1;
        boolean foundLast = false;
        while (!foundLast) {
            String s = null;
            s = request.getParameter(param + "_" + i);
            if (s == null) {
                s = request.getParameter(param);
                foundLast = true;
            }
            if (s != null) {
                boolean addValue = true;
                String[] selected = request.getParameterValues(metadataField + "_selected");
                if (selected != null) {
                    for (int j = 0; j < selected.length; ++j) {
                        if (!selected[j].equals(metadataField + "_" + i)) continue;
                        addValue = false;
                    }
                }
                if (addValue) {
                    vals.add(s.trim());
                }
            }
            ++i;
        }
        log.debug((Object)("getRepeatedParameter: metadataField=" + metadataField + " param=" + metadataField + ", return count = " + vals.size()));
        return vals;
    }

    public static String getFieldName(DCInput input) {
        String dcSchema = input.getSchema();
        String dcElement = input.getElement();
        String dcQualifier = input.getQualifier();
        if (dcQualifier != null && !dcQualifier.equals("*")) {
            return dcSchema + "_" + dcElement + '_' + dcQualifier;
        }
        return dcSchema + "_" + dcElement;
    }
}

