/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.sql.SQLException;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.core.Context;

public class AuthorizeUtil {
    public static void authorizeManageBitstreamPolicy(Context context, Bitstream bitstream) throws AuthorizeException, SQLException {
        Bundle bundle = bitstream.getBundles()[0];
        AuthorizeUtil.authorizeManageBundlePolicy(context, bundle);
    }

    public static void authorizeManageBundlePolicy(Context context, Bundle bundle) throws AuthorizeException, SQLException {
        Item item = bundle.getItems()[0];
        AuthorizeUtil.authorizeManageItemPolicy(context, item);
    }

    public static void authorizeManageItemPolicy(Context context, Item item) throws AuthorizeException, SQLException {
        if (AuthorizeConfiguration.canItemAdminManagePolicies()) {
            AuthorizeManager.authorizeAction(context, item, 11);
        } else if (AuthorizeConfiguration.canCollectionAdminManageItemPolicies()) {
            AuthorizeManager.authorizeAction(context, item.getOwningCollection(), 11);
        } else if (AuthorizeConfiguration.canCommunityAdminManageItemPolicies()) {
            AuthorizeManager.authorizeAction(context, item.getOwningCollection().getCommunities()[0], 11);
        } else if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage item policies");
        }
    }

    public static void authorizeManageCollectionPolicy(Context context, Collection collection) throws AuthorizeException, SQLException {
        if (AuthorizeConfiguration.canCollectionAdminManagePolicies()) {
            AuthorizeManager.authorizeAction(context, collection, 11);
        } else if (AuthorizeConfiguration.canCommunityAdminManageCollectionPolicies()) {
            AuthorizeManager.authorizeAction(context, collection.getCommunities()[0], 11);
        } else if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage collection policies");
        }
    }

    public static void authorizeManageCommunityPolicy(Context context, Community community) throws AuthorizeException, SQLException {
        if (AuthorizeConfiguration.canCommunityAdminManagePolicies()) {
            AuthorizeManager.authorizeAction(context, community, 11);
        } else if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage community policies");
        }
    }

    public static void requireAdminRole(Context context) throws AuthorizeException, SQLException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to perform this action");
        }
    }

    public static void authorizeManageCCLicense(Context context, Item item) throws AuthorizeException, SQLException {
        try {
            AuthorizeManager.authorizeAction(context, item, 3);
            AuthorizeManager.authorizeAction(context, item, 4);
        }
        catch (AuthorizeException authex) {
            if (AuthorizeConfiguration.canItemAdminManageCCLicense()) {
                AuthorizeManager.authorizeAction(context, item, 11);
            }
            if (AuthorizeConfiguration.canCollectionAdminManageCCLicense()) {
                AuthorizeManager.authorizeAction(context, item.getParentObject(), 11);
            }
            if (AuthorizeConfiguration.canCommunityAdminManageCCLicense()) {
                AuthorizeManager.authorizeAction(context, item.getParentObject().getParentObject(), 11);
            }
            AuthorizeUtil.requireAdminRole(context);
        }
    }

    public static void authorizeManageTemplateItem(Context context, Collection collection) throws AuthorizeException, SQLException {
        boolean isAuthorized = collection.canEditBoolean(false);
        if (!isAuthorized && AuthorizeConfiguration.canCollectionAdminManageTemplateItem()) {
            AuthorizeManager.authorizeAction(context, collection, 11);
        } else if (!isAuthorized && AuthorizeConfiguration.canCommunityAdminManageCollectionTemplateItem()) {
            Community[] communities = collection.getCommunities();
            Community parent = communities != null && communities.length > 0 ? communities[0] : null;
            AuthorizeManager.authorizeAction(context, parent, 11);
        } else if (!isAuthorized && !AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("You are not authorized to create a template item for the collection");
        }
    }

    public static void authorizeManageSubmittersGroup(Context context, Collection collection) throws AuthorizeException, SQLException {
        if (AuthorizeConfiguration.canCollectionAdminManageSubmitters()) {
            AuthorizeManager.authorizeAction(context, collection, 11);
        } else if (AuthorizeConfiguration.canCommunityAdminManageCollectionSubmitters()) {
            AuthorizeManager.authorizeAction(context, collection.getCommunities()[0], 11);
        } else if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage collection submitters");
        }
    }

    public static void authorizeManageWorkflowsGroup(Context context, Collection collection) throws AuthorizeException, SQLException {
        if (AuthorizeConfiguration.canCollectionAdminManageWorkflows()) {
            AuthorizeManager.authorizeAction(context, collection, 11);
        } else if (AuthorizeConfiguration.canCommunityAdminManageCollectionWorkflows()) {
            AuthorizeManager.authorizeAction(context, collection.getCommunities()[0], 11);
        } else if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage collection workflow");
        }
    }

    public static void authorizeManageAdminGroup(Context context, Collection collection) throws AuthorizeException, SQLException {
        if (AuthorizeConfiguration.canCollectionAdminManageAdminGroup()) {
            AuthorizeManager.authorizeAction(context, collection, 11);
        } else if (AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup()) {
            AuthorizeManager.authorizeAction(context, collection.getCommunities()[0], 11);
        } else if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage collection admin");
        }
    }

    public static void authorizeRemoveAdminGroup(Context context, Collection collection) throws AuthorizeException, SQLException {
        Community[] parentCommunities = collection.getCommunities();
        if (AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup() && parentCommunities != null && parentCommunities.length > 0) {
            AuthorizeManager.authorizeAction(context, collection.getCommunities()[0], 11);
        } else if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only system admin can remove the admin group of a collection");
        }
    }

    public static void authorizeManageAdminGroup(Context context, Community community) throws AuthorizeException, SQLException {
        if (AuthorizeConfiguration.canCommunityAdminManageAdminGroup()) {
            AuthorizeManager.authorizeAction(context, community, 11);
        } else if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only system admin are allowed to manage community admin");
        }
    }

    public static void authorizeRemoveAdminGroup(Context context, Community community) throws SQLException, AuthorizeException {
        Community parentCommunity = community.getParentCommunity();
        if (AuthorizeConfiguration.canCommunityAdminManageAdminGroup() && parentCommunity != null) {
            AuthorizeManager.authorizeAction(context, parentCommunity, 11);
        } else if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only system admin can remove the admin group of the community");
        }
    }

    public static void authorizeManagePolicy(Context c, ResourcePolicy rp) throws SQLException, AuthorizeException {
        switch (rp.getResourceType()) {
            case 0: {
                AuthorizeUtil.authorizeManageBitstreamPolicy(c, Bitstream.find(c, rp.getResourceID()));
                break;
            }
            case 1: {
                AuthorizeUtil.authorizeManageBundlePolicy(c, Bundle.find(c, rp.getResourceID()));
                break;
            }
            case 2: {
                AuthorizeUtil.authorizeManageItemPolicy(c, Item.find(c, rp.getResourceID()));
                break;
            }
            case 3: {
                AuthorizeUtil.authorizeManageCollectionPolicy(c, Collection.find(c, rp.getResourceID()));
                break;
            }
            case 4: {
                AuthorizeUtil.authorizeManageCommunityPolicy(c, Community.find(c, rp.getResourceID()));
                break;
            }
            default: {
                AuthorizeUtil.requireAdminRole(c);
            }
        }
    }

    public static void authorizeWithdrawItem(Context context, Item item) throws SQLException, AuthorizeException {
        boolean authorized = false;
        if (AuthorizeConfiguration.canCollectionAdminPerformItemWithdrawn()) {
            authorized = AuthorizeManager.authorizeActionBoolean(context, item.getOwningCollection(), 11);
        } else if (AuthorizeConfiguration.canCommunityAdminPerformItemWithdrawn()) {
            authorized = AuthorizeManager.authorizeActionBoolean(context, item.getOwningCollection().getCommunities()[0], 11);
        }
        if (!authorized) {
            authorized = AuthorizeManager.authorizeActionBoolean(context, item.getOwningCollection(), 4, false);
        }
        if (!authorized) {
            throw new AuthorizeException("To withdraw item must be COLLECTION_ADMIN or have REMOVE authorization on owning Collection");
        }
    }

    public static void authorizeReinstateItem(Context context, Item item) throws SQLException, AuthorizeException {
        Collection[] colls = item.getCollections();
        for (int i = 0; i < colls.length; ++i) {
            if (!AuthorizeConfiguration.canCollectionAdminPerformItemReinstatiate()) {
                if (AuthorizeConfiguration.canCommunityAdminPerformItemReinstatiate() && AuthorizeManager.authorizeActionBoolean(context, colls[i].getCommunities()[0], 11)) continue;
                AuthorizeManager.authorizeAction(context, colls[i], 3, false);
                continue;
            }
            AuthorizeManager.authorizeAction(context, colls[i], 3);
        }
    }
}

