/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLUtils {
    public static List<Element> getElementList(Element dataRoot, String name) {
        NodeList list = dataRoot.getElementsByTagName(name);
        ArrayList<Element> listElements = new ArrayList<Element>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element item = (Element)list.item(i);
            if (!item.getParentNode().equals(dataRoot)) continue;
            listElements.add(item);
        }
        return listElements;
    }

    public static String getElementAttribute(Element dataRoot, String name, String attr) {
        Element element = XMLUtils.getSingleElement(dataRoot, name);
        String attrValue = null;
        if (element != null) {
            attrValue = element.getAttribute(attr);
            attrValue = StringUtils.isNotBlank((String)attrValue) ? attrValue.trim() : null;
        }
        return attrValue;
    }

    public static String getElementValue(Element dataRoot, String name) {
        Element element = XMLUtils.getSingleElement(dataRoot, name);
        String elementValue = null;
        if (element != null) {
            elementValue = element.getTextContent();
            elementValue = StringUtils.isNotBlank((String)elementValue) ? elementValue.trim() : null;
        }
        return elementValue;
    }

    public static Element getSingleElement(Element dataRoot, String name) {
        List<Element> nodeList = XMLUtils.getElementList(dataRoot, name);
        Element element = null;
        if (nodeList != null && nodeList.size() > 0) {
            element = nodeList.get(0);
        }
        return element;
    }

    public static List<String> getElementValueList(Element rootElement, String subElementName) {
        if (rootElement == null) {
            return null;
        }
        List<Element> subElements = XMLUtils.getElementList(rootElement, subElementName);
        if (subElements == null) {
            return null;
        }
        LinkedList<String> result = new LinkedList<String>();
        for (Element el : subElements) {
            if (!StringUtils.isNotBlank((String)el.getTextContent())) continue;
            result.add(el.getTextContent().trim());
        }
        return result;
    }

    public static List<String[]> getElementValueArrayList(Element rootElement, String subElementName, String ... fieldsName) {
        if (rootElement == null) {
            return null;
        }
        List<Element> subElements = XMLUtils.getElementList(rootElement, subElementName);
        if (subElements == null) {
            return null;
        }
        LinkedList<String[]> result = new LinkedList<String[]>();
        for (Element el : subElements) {
            String[] tmp = new String[fieldsName.length];
            for (int idx = 0; idx < fieldsName.length; ++idx) {
                tmp[idx] = XMLUtils.getElementValue(el, fieldsName[idx]);
            }
            result.add(tmp);
        }
        return result;
    }
}

