/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.log4j.Logger;
import org.dspace.content.DCPersonName;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LCNameAuthority
implements ChoiceAuthority {
    private static Logger log = Logger.getLogger(LCNameAuthority.class);
    private static String url = null;
    private static final String NS_SRU = "http://www.loc.gov/zing/srw/";
    private static final String NS_MX = "http://www.loc.gov/MARC21/slim";

    public LCNameAuthority() {
        if (url == null && (url = ConfigurationManager.getProperty("lcname.url")) == null) {
            throw new IllegalStateException("Missing DSpace configuration keys for LCName Query");
        }
    }

    @Override
    public Choices getBestMatch(String field, String text, int collection, String locale) {
        return this.getMatches(field, text, collection, 0, 2, locale);
    }

    @Override
    public Choices getMatches(String field, String text, int collection, int start, int limit, String locale) {
        Choices result = this.queryPerson(text, start, limit);
        if (result == null) {
            result = new Choices(true);
        }
        return result;
    }

    @Override
    public String getLabel(String field, String key, String locale) {
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Choices queryPerson(String text, int start, int limit) {
        if (text == null || text.trim().length() == 0) {
            return new Choices(true);
        }
        DCPersonName pn = new DCPersonName(text);
        StringBuilder query = new StringBuilder();
        query.append("local.FirstName = \"").append(pn.getFirstNames()).append("\" and local.FamilyName = \"").append(pn.getLastName()).append("\"");
        if (limit == 0) {
            limit = 50;
        }
        NameValuePair[] args = new NameValuePair[]{new NameValuePair("operation", "searchRetrieve"), new NameValuePair("version", "1.1"), new NameValuePair("recordSchema", "info:srw/schema/1/marcxml-v1.1"), new NameValuePair("query", query.toString()), new NameValuePair("maximumRecords", String.valueOf(limit)), new NameValuePair("startRecord", String.valueOf(start + 1))};
        HttpClient hc = new HttpClient();
        String srUrl = url + "?" + EncodingUtil.formUrlEncode((NameValuePair[])args, (String)"UTF8");
        GetMethod get = new GetMethod(srUrl);
        log.debug((Object)("Trying SRU query, URL=" + srUrl));
        try {
            int status = hc.executeMethod((HttpMethod)get);
            if (status == 200) {
                boolean more;
                SAXParserFactory spf = SAXParserFactory.newInstance();
                SAXParser sp = spf.newSAXParser();
                XMLReader xr = sp.getXMLReader();
                SRUHandler handler = new SRUHandler();
                xr.setFeature("http://xml.org/sax/features/namespaces", true);
                xr.setContentHandler(handler);
                xr.setErrorHandler(handler);
                xr.parse(new InputSource(get.getResponseBodyAsStream()));
                if (handler.hits != handler.result.size()) {
                    log.warn((Object)("Discrepency in results, result.length=" + handler.result.size() + ", yet expected results=" + handler.hits));
                }
                boolean bl = more = handler.hits > start + handler.result.size();
                int confidence = handler.hits == 0 ? 300 : (handler.hits == 1 ? 500 : 400);
                Choices choices = new Choices(handler.result.toArray(new Choice[handler.result.size()]), start, handler.hits, confidence, more);
                return choices;
            }
        }
        catch (HttpException e) {
            log.error((Object)"SRU query failed: ", (Throwable)e);
            Choices choices = new Choices(true);
            return choices;
        }
        catch (IOException e) {
            log.error((Object)"SRU query failed: ", (Throwable)e);
            Choices choices = new Choices(true);
            return choices;
        }
        catch (ParserConfigurationException e) {
            log.warn((Object)"Failed parsing SRU result: ", (Throwable)e);
            Choices choices = new Choices(true);
            return choices;
        }
        catch (SAXException e) {
            log.warn((Object)"Failed parsing SRU result: ", (Throwable)e);
            Choices choices = new Choices(true);
            return choices;
        }
        finally {
            get.releaseConnection();
        }
        return new Choices(true);
    }

    private static class SRUHandler
    extends DefaultHandler {
        private List<Choice> result = new ArrayList<Choice>();
        private int hits = -1;
        private String textValue = null;
        private String name = null;
        private String lccn = null;
        private String lastTag = null;
        private String lastCode = null;

        private SRUHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String newValue = new String(ch, start, length);
            if (newValue.length() > 0) {
                this.textValue = this.textValue == null ? newValue : this.textValue + newValue;
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("numberOfRecords") && namespaceURI.equals(LCNameAuthority.NS_SRU)) {
                this.hits = Integer.parseInt(this.textValue.trim());
                if (this.hits > 0) {
                    this.name = null;
                    this.lccn = null;
                    log.debug((Object)("Expecting " + this.hits + " records in results."));
                }
            } else if (localName.equals("record") && namespaceURI.equals(LCNameAuthority.NS_SRU)) {
                if (this.name != null && this.lccn != null) {
                    if (this.name.endsWith(",")) {
                        this.name = this.name.substring(0, this.name.length() - 1);
                    }
                    this.result.add(new Choice(this.lccn, this.name, this.name));
                } else {
                    log.warn((Object)("Got anomalous result, at least one of these null: lccn=" + this.lccn + ", name=" + this.name));
                }
                this.name = null;
                this.lccn = null;
            } else if (localName.equals("subfield") && namespaceURI.equals(LCNameAuthority.NS_MX) && this.lastTag != null && this.lastCode != null) {
                if (this.lastTag.equals("010") && this.lastCode.equals("a")) {
                    this.lccn = this.textValue;
                } else if (this.lastTag.equals("100") && this.lastCode.equals("a")) {
                    this.name = this.textValue;
                }
                if (this.lastTag.equals("100") && this.lastCode.equals("d") && this.name != null) {
                    this.name = this.name + "  " + this.textValue;
                }
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this.textValue = null;
            if (localName.equals("datafield") && namespaceURI.equals(LCNameAuthority.NS_MX)) {
                this.lastTag = atts.getValue("tag");
                if (this.lastTag == null) {
                    log.warn((Object)"MARC datafield without tag attribute!");
                }
            } else if (localName.equals("subfield") && namespaceURI.equals(LCNameAuthority.NS_MX)) {
                this.lastCode = atts.getValue("code");
                if (this.lastCode == null) {
                    log.warn((Object)"MARC subfield without code attribute!");
                }
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }
    }
}

