/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;
import org.apache.solr.common.util.ContentStreamBase;
import org.dspace.content.Bitstream;

public class BitstreamContentStream
extends ContentStreamBase {
    private static final Logger log = Logger.getLogger(BitstreamContentStream.class);
    private final Bitstream file;

    public BitstreamContentStream(Bitstream f) {
        this.file = f;
        this.contentType = f.getFormat().getMIMEType();
        this.name = this.file.getName();
        this.size = this.file.getSize();
        this.sourceInfo = this.file.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentType() {
        if (this.contentType == null) {
            InputStream stream = null;
            try {
                stream = this.file.retrieve();
                char first = (char)stream.read();
                if (first == '<') {
                    String string = "application/xml";
                    return string;
                }
                if (first == '{') {
                    String string = "application/json";
                    return string;
                }
            }
            catch (Exception ex) {
                log.error((Object)("Error determining content type for bitstream:" + this.file.getID()), (Throwable)ex);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ioe) {
                        log.error((Object)("Error closing stream:" + this.file.getID()), (Throwable)ioe);
                    }
                }
            }
        }
        return this.contentType;
    }

    public InputStream getStream() throws IOException {
        try {
            return this.file.retrieve();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new ByteArrayInputStream(e.getMessage().getBytes(StandardCharsets.UTF_8));
        }
    }
}

