/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.handle;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.discovery.IndexClient;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class UpdateHandlePrefix {
    private static final Logger log = Logger.getLogger(UpdateHandlePrefix.class);

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("\nUsage: update-handle-prefix <old handle> <new handle>\n");
            System.exit(1);
        } else {
            String oldH = args[0];
            String newH = args[1];
            System.out.println("\nGetting information about handles from database...");
            Context context = new Context();
            String sql = "SELECT count(*) as count FROM handle WHERE handle LIKE '" + oldH + "%'";
            TableRow row = DatabaseManager.querySingle(context, sql, new Object[0]);
            long count = row.getLongColumn("count");
            if (count > 0L) {
                System.out.println("In your repository will be updated " + count + " handle" + (count > 1L ? "s" : "") + " to new prefix " + newH + " from original " + oldH + "!\n");
                System.out.print("Servlet container (e.g. Apache Tomcat, Jetty, Caucho Resin) must be running.\nIf it is necessary, please make a backup of the database.\nAre you ready to continue? [y/n]: ");
                BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                String choiceString = input.readLine();
                if (choiceString.equalsIgnoreCase("y")) {
                    try {
                        log.info((Object)("Updating handle prefix from " + oldH + " to " + newH));
                        System.out.print("\nUpdating handle table... ");
                        sql = "UPDATE handle SET handle = '" + newH + "' || '/' || handle_id " + "WHERE handle like '" + oldH + "/%'";
                        int updHdl = DatabaseManager.updateQuery(context, sql, new Object[0]);
                        System.out.println(updHdl + " item" + (updHdl > 1 ? "s" : "") + " updated");
                        System.out.print("Updating metadatavalues table... ");
                        sql = "UPDATE metadatavalue SET text_value = (SELECT 'http://hdl.handle.net/' || handle FROM handle WHERE handle.resource_id = metadatavalue.item_id AND handle.resource_type_id = 2) WHERE text_value LIKE 'http://hdl.handle.net/" + oldH + "/%'" + "AND EXISTS " + "(" + "SELECT 1 " + "FROM handle " + "WHERE handle.resource_id = metadatavalue.item_id " + "AND handle.resource_type_id = 2" + ")";
                        int updMeta = DatabaseManager.updateQuery(context, sql, new Object[0]);
                        System.out.println(updMeta + " metadata value" + (updMeta > 1 ? "s" : "") + " updated");
                        context.complete();
                        log.info((Object)("Done with updating handle prefix. It was changed " + updHdl + " handle" + (updHdl > 1 ? "s" : "") + " and " + updMeta + " metadata record" + (updMeta > 1 ? "s" : "")));
                    }
                    catch (SQLException sqle) {
                        if (context != null && context.isValid()) {
                            context.abort();
                            context = null;
                        }
                        System.out.println("\nError during SQL operations.");
                        throw sqle;
                    }
                    System.out.println("Handles successfully updated in database.\n");
                    System.out.println("Re-creating browse and search indexes...");
                    try {
                        IndexClient.main(new String[]{"-b"});
                        System.out.println("Browse and search indexes are ready now.");
                        System.out.println("\nAll done successfully. Please check the DSpace logs!\n");
                    }
                    catch (Exception e) {
                        System.out.println("Error during re-indexing.");
                        System.out.println("\n\nAutomatic re-indexing failed. Please perform it manually.\nYou should run one of the following commands:\n\n  [dspace]/bin/dspace index-discovery -b\n\nIf you are using Solr for browse (this is the default setting).\nWhen launching this command, your servlet container must be running.\n\n  [dspace]/bin/dspace index-lucene-init\n\nIf you enabled Lucene for search.\nWhen launching this command, your servlet container must be shutdown.\n");
                        throw e;
                    }
                }
                System.out.println("No changes have been made to your data.\n");
            } else {
                System.out.println("Nothing to do! All handles are up-to-date.\n");
            }
        }
    }
}

