/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.usage;

import javax.servlet.http.HttpServletRequest;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.services.model.Event;

public class UsageEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private transient HttpServletRequest request;
    private transient String ip;
    private transient String userAgent;
    private transient String xforwarderfor;
    private transient Context context;
    private transient DSpaceObject object;
    private Action action;

    private static String checkParams(Action action, HttpServletRequest request, Context context, DSpaceObject object) {
        StringBuilder eventName = new StringBuilder();
        if (action == null) {
            throw new IllegalStateException("action cannot be null");
        }
        if (action != Action.WORKFLOW && request == null) {
            throw new IllegalStateException("request cannot be null");
        }
        if (context == null) {
            throw new IllegalStateException("context cannot be null");
        }
        if (action != Action.WORKFLOW && action != Action.SEARCH && object == null) {
            throw new IllegalStateException("object cannot be null");
        }
        if (object != null) {
            String objText = Constants.typeText[object.getType()].toLowerCase();
            eventName.append(objText).append(":");
        }
        eventName.append(action.text());
        return eventName.toString();
    }

    private static String checkParams(Action action, Context context, DSpaceObject object) {
        StringBuilder eventName = new StringBuilder();
        if (action == null) {
            throw new IllegalStateException("action cannot be null");
        }
        if (context == null) {
            throw new IllegalStateException("context cannot be null");
        }
        if (action != Action.WORKFLOW && action != Action.SEARCH && object == null) {
            throw new IllegalStateException("object cannot be null");
        }
        if (object != null) {
            String objText = Constants.typeText[object.getType()].toLowerCase();
            eventName.append(objText).append(":");
        }
        eventName.append(action.text());
        return eventName.toString();
    }

    public UsageEvent(Action action, HttpServletRequest request, Context context, DSpaceObject object) {
        super(UsageEvent.checkParams(action, request, context, object));
        this.action = action;
        this.setResourceReference(object != null ? Constants.typeText[object.getType()].toLowerCase() + ":" + object.getID() : null);
        switch (action) {
            case CREATE: 
            case UPDATE: 
            case DELETE: 
            case WITHDRAW: 
            case REINSTATE: 
            case ADD: 
            case REMOVE: {
                this.setModify(true);
                break;
            }
            default: {
                this.setModify(false);
            }
        }
        if (context != null && context.getCurrentUser() != null) {
            this.setUserId(String.valueOf(context.getCurrentUser().getID()));
        }
        this.request = request;
        this.context = context;
        this.object = object;
    }

    public UsageEvent(Action action, String ip, String userAgent, String xforwarderfor, Context context, DSpaceObject object) {
        super(UsageEvent.checkParams(action, context, object));
        this.action = action;
        this.setResourceReference(object != null ? Constants.typeText[object.getType()].toLowerCase() + ":" + object.getID() : null);
        switch (action) {
            case CREATE: 
            case UPDATE: 
            case DELETE: 
            case WITHDRAW: 
            case REINSTATE: 
            case ADD: 
            case REMOVE: {
                this.setModify(true);
                break;
            }
            default: {
                this.setModify(false);
            }
        }
        if (context != null && context.getCurrentUser() != null) {
            this.setUserId(String.valueOf(context.getCurrentUser().getID()));
        }
        this.request = null;
        this.ip = ip;
        this.userAgent = userAgent;
        this.xforwarderfor = xforwarderfor;
        this.context = context;
        this.object = object;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getXforwarderfor() {
        return this.xforwarderfor;
    }

    public void setXforwarderfor(String xforwarderfor) {
        this.xforwarderfor = xforwarderfor;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public DSpaceObject getObject() {
        return this.object;
    }

    public void setObject(DSpaceObject object) {
        this.object = object;
    }

    public Action getAction() {
        return this.action;
    }

    public static enum Action {
        VIEW("view"),
        CREATE("create"),
        UPDATE("update"),
        DELETE("delete"),
        ADD("add"),
        REMOVE("remove"),
        BROWSE("browse"),
        SEARCH("search"),
        WORKFLOW("workflow"),
        LOGIN("login"),
        SUBSCRIBE("subscribe"),
        UNSUBSCRIBE("unsubscribe"),
        WITHDRAW("withdraw"),
        REINSTATE("reinstate");

        private final String text;

        private Action(String text) {
            this.text = text;
        }

        String text() {
            return this.text;
        }
    }
}

