/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.xmlworkflow.storedcomponents;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.xmlworkflow.storedcomponents.XmlWorkflowItem;

public class ClaimedTask {
    private Context myContext;
    private TableRow myRow;

    ClaimedTask(Context context, TableRow row) {
        this.myContext = context;
        this.myRow = row;
    }

    public static ClaimedTask find(Context context, int id) throws SQLException {
        TableRow row = DatabaseManager.find(context, "cwf_claimtask", id);
        if (row == null) {
            return null;
        }
        return new ClaimedTask(context, row);
    }

    public static List<ClaimedTask> findByWorkflowId(Context context, int workflowID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_claimtask", "SELECT * FROM cwf_claimtask WHERE workflowitem_id= " + workflowID, new Object[0]);
        ArrayList<ClaimedTask> list = new ArrayList<ClaimedTask>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            list.add(new ClaimedTask(context, row));
        }
        return list;
    }

    public static ClaimedTask findByWorkflowIdAndEPerson(Context context, int workflowID, int epersonID) throws SQLException {
        TableRow row = DatabaseManager.querySingleTable(context, "cwf_claimtask", "SELECT * FROM cwf_claimtask WHERE workflowitem_id= ? AND owner_id= ?", workflowID, epersonID);
        if (row == null) {
            return null;
        }
        return new ClaimedTask(context, row);
    }

    public static List<ClaimedTask> findByEperson(Context context, int epersonID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(context, "cwf_claimtask", "SELECT * FROM cwf_claimtask WHERE owner_id= " + epersonID, new Object[0]);
        ArrayList<ClaimedTask> list = new ArrayList<ClaimedTask>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            list.add(new ClaimedTask(context, row));
        }
        return list;
    }

    public static List<ClaimedTask> find(Context c, int wfiID, String stepID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "cwf_claimtask", "SELECT * FROM cwf_claimtask WHERE workflowitem_id=" + wfiID + " AND step_id= ?", stepID);
        ArrayList<ClaimedTask> list = new ArrayList<ClaimedTask>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            list.add(new ClaimedTask(c, row));
        }
        return list;
    }

    public static ClaimedTask find(Context c, int epersonID, int wfiID, String stepID, String actionID) throws SQLException {
        TableRow row = DatabaseManager.querySingleTable(c, "cwf_claimtask", "SELECT * FROM cwf_claimtask WHERE workflowitem_id=" + wfiID + " AND owner_id= " + epersonID + " AND action_id= ? AND step_id= ?", actionID, stepID);
        return new ClaimedTask(c, row);
    }

    public static List<ClaimedTask> find(Context c, int wfiID, String stepID, String actionID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "cwf_claimtask", "SELECT * FROM cwf_claimtask WHERE workflowitem_id=" + wfiID + " AND step_id= ? AND action_id=?", stepID, actionID);
        ArrayList<ClaimedTask> list = new ArrayList<ClaimedTask>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            list.add(new ClaimedTask(c, row));
        }
        return list;
    }

    public static List<ClaimedTask> find(Context c, XmlWorkflowItem workflowItem) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "cwf_claimtask", "SELECT * FROM cwf_claimtask WHERE workflowitem_id=" + workflowItem.getID(), new Object[0]);
        ArrayList<ClaimedTask> list = new ArrayList<ClaimedTask>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            list.add(new ClaimedTask(c, row));
        }
        return list;
    }

    public static List<ClaimedTask> findAllInStep(Context c, String stepID) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "cwf_claimtask", "SELECT * FROM cwf_claimtask WHERE step_id= ?", stepID);
        ArrayList<ClaimedTask> list = new ArrayList<ClaimedTask>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            list.add(new ClaimedTask(c, row));
        }
        return list;
    }

    public static ClaimedTask create(Context context) throws SQLException {
        TableRow row = DatabaseManager.create(context, "cwf_claimtask");
        return new ClaimedTask(context, row);
    }

    public void delete() throws SQLException {
        DatabaseManager.delete(this.myContext, this.myRow);
    }

    public void update() throws SQLException {
        DatabaseManager.update(this.myContext, this.myRow);
    }

    public void setOwnerID(int ownerID) {
        this.myRow.setColumn("owner_id", ownerID);
    }

    public int getOwnerID() {
        return this.myRow.getIntColumn("owner_id");
    }

    public void setWorkflowItemID(int workflowItemID) {
        this.myRow.setColumn("workflowitem_id", workflowItemID);
    }

    public int getWorkflowItemID() {
        return this.myRow.getIntColumn("workflowitem_id");
    }

    public void setActionID(String actionID) {
        this.myRow.setColumn("action_id", actionID);
    }

    public String getActionID() {
        return this.myRow.getStringColumn("action_id");
    }

    public void setStepID(String stepID) {
        this.myRow.setColumn("step_id", stepID);
    }

    public String getStepID() {
        return this.myRow.getStringColumn("step_id");
    }

    public void setWorkflowID(String workflowID) {
        this.myRow.setColumn("workflow_id", workflowID);
    }

    public String getWorkflowID() {
        return this.myRow.getStringColumn("workflow_id");
    }
}

