/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.checker.BitstreamDAO;
import org.dspace.checker.BitstreamDispatcher;
import org.dspace.checker.BitstreamInfo;
import org.dspace.checker.BitstreamInfoDAO;
import org.dspace.checker.ChecksumHistoryDAO;
import org.dspace.checker.ChecksumResultsCollector;
import org.dspace.checker.ResultsLogger;
import org.dspace.core.Utils;

public final class CheckerCommand {
    private static final Logger LOG = Logger.getLogger(CheckerCommand.class);
    private static final String DEFAULT_DIGEST_ALGORITHM = "MD5";
    private int BYTE_ARRAY_SIZE = 4096;
    private BitstreamInfoDAO bitstreamInfoDAO = new BitstreamInfoDAO();
    private BitstreamDAO bitstreamDAO = new BitstreamDAO();
    private ChecksumHistoryDAO checksumHistoryDAO = new ChecksumHistoryDAO();
    private Date processStartDate = null;
    private BitstreamDispatcher dispatcher = null;
    private ChecksumResultsCollector collector = null;
    private boolean reportVerbose = false;

    public void process() {
        LOG.debug((Object)"Begin Checker Processing");
        if (this.dispatcher == null) {
            throw new IllegalStateException("No BitstreamDispatcher provided");
        }
        if (this.collector == null) {
            this.collector = new ResultsLogger(this.processStartDate);
        }
        this.bitstreamInfoDAO.updateMissingBitstreams();
        int id = this.dispatcher.next();
        while (id != -1) {
            LOG.debug((Object)("Processing bitstream id = " + id));
            BitstreamInfo info = this.checkBitstream(id);
            if (this.reportVerbose || !"CHECKSUM_MATCH".equals(info.getChecksumCheckResult())) {
                this.collector.collect(info);
            }
            id = this.dispatcher.next();
        }
    }

    private BitstreamInfo checkBitstream(int id) {
        BitstreamInfo info = this.bitstreamInfoDAO.findByBitstreamId(id);
        if (info == null) {
            info = new BitstreamInfo(id);
            this.processNullInfoBitstream(info);
        } else if (!info.getToBeProcessed()) {
            info.setChecksumCheckResult("BITSTREAM_NOT_PROCESSED");
        } else if (info.getDeleted()) {
            this.processDeletedBitstream(info);
        } else {
            this.processBitstream(info);
        }
        return info;
    }

    private String digestStream(InputStream stream, String algorithm) throws NoSuchAlgorithmException, IOException {
        DigestInputStream dStream = new DigestInputStream(stream, MessageDigest.getInstance(algorithm));
        byte[] bytes = new byte[this.BYTE_ARRAY_SIZE];
        int bytesRead = -1;
        while ((bytesRead = dStream.read(bytes, 0, this.BYTE_ARRAY_SIZE)) != -1) {
        }
        return Utils.toHex(dStream.getMessageDigest().digest());
    }

    private String compareChecksums(String checksumA, String checksumB) {
        String result = "CHECKSUM_NO_MATCH";
        if (checksumA == null || checksumB == null) {
            result = "CHECKSUM_PREV_NOT_FOUND";
        } else if (checksumA.equals(checksumB)) {
            result = "CHECKSUM_MATCH";
        }
        return result;
    }

    private void processDeletedBitstream(BitstreamInfo info) {
        info.setProcessStartDate(new Date());
        info.setChecksumCheckResult("BITSTREAM_MARKED_DELETED");
        info.setProcessStartDate(new Date());
        info.setProcessEndDate(new Date());
        info.setToBeProcessed(false);
        this.bitstreamInfoDAO.update(info);
        this.checksumHistoryDAO.insertHistory(info);
    }

    private void processNullInfoBitstream(BitstreamInfo info) {
        info.setInfoFound(false);
        info.setProcessStartDate(new Date());
        info.setProcessEndDate(new Date());
        info.setChecksumCheckResult("BITSTREAM_INFO_NOT_FOUND");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBitstream(BitstreamInfo info) {
        info.setProcessStartDate(new Date());
        if (info.getChecksumAlgorithm() == null) {
            info.setChecksumAlgorithm(DEFAULT_DIGEST_ALGORITHM);
        }
        try {
            InputStream bitstream = this.bitstreamDAO.getBitstream(info.getBitstreamId());
            info.setBitstreamFound(true);
            String checksum = this.digestStream(bitstream, info.getChecksumAlgorithm());
            info.setCalculatedChecksum(checksum);
            info.setChecksumCheckResult(this.compareChecksums(info.getStoredChecksum(), info.getCalculatedChecksum()));
        }
        catch (IOException e) {
            info.setChecksumCheckResult("BITSTREAM_NOT_FOUND");
            info.setToBeProcessed(false);
            LOG.error((Object)("Error retrieving bitstream ID " + info.getBitstreamId() + " from " + "asset store."), (Throwable)e);
        }
        catch (SQLException e) {
            info.setChecksumCheckResult("BITSTREAM_INFO_NOT_FOUND");
            LOG.error((Object)("Error retrieving metadata for bitstream ID " + info.getBitstreamId()), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            info.setChecksumCheckResult("CHECKSUM_ALGORITHM_INVALID");
            info.setToBeProcessed(false);
            LOG.error((Object)("Invalid digest algorithm type for bitstream ID" + info.getBitstreamId()), (Throwable)e);
        }
        finally {
            info.setProcessEndDate(new Date());
            this.bitstreamInfoDAO.update(info);
            this.checksumHistoryDAO.insertHistory(info);
        }
    }

    public BitstreamDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(BitstreamDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ChecksumResultsCollector getCollector() {
        return this.collector;
    }

    public void setCollector(ChecksumResultsCollector collector) {
        this.collector = collector;
    }

    public Date getProcessStartDate() {
        return this.processStartDate == null ? null : new Date(this.processStartDate.getTime());
    }

    public void setProcessStartDate(Date startDate) {
        this.processStartDate = startDate == null ? null : new Date(startDate.getTime());
    }

    public boolean isReportVerbose() {
        return this.reportVerbose;
    }

    public void setReportVerbose(boolean reportVerbose) {
        this.reportVerbose = reportVerbose;
    }
}

