/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.DecoderException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.Utils;
import org.dspace.eperson.EPersonDeletionException;
import org.dspace.eperson.PasswordHash;
import org.dspace.event.Event;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class EPerson
extends DSpaceObject {
    public static final int EMAIL = 1;
    public static final int LASTNAME = 2;
    public static final int ID = 3;
    public static final int NETID = 4;
    public static final int LANGUAGE = 5;
    private static Logger log = Logger.getLogger(EPerson.class);
    private Context myContext;
    private TableRow myRow;
    private boolean modified;
    private boolean modifiedMetadata;
    private static final Option VERB_ADD = new Option("a", "add", false, "create a new EPerson");
    private static final Option VERB_DELETE = new Option("d", "delete", false, "delete an existing EPerson");
    private static final Option VERB_LIST = new Option("L", "list", false, "list EPersons");
    private static final Option VERB_MODIFY = new Option("M", "modify", false, "modify an EPerson");
    private static final Option OPT_GIVENNAME = new Option("g", "givenname", true, "the person's actual first or personal name");
    private static final Option OPT_SURNAME = new Option("s", "surname", true, "the person's actual last or family name");
    private static final Option OPT_PHONE = new Option("t", "telephone", true, "telephone number, empty for none");
    private static final Option OPT_LANGUAGE = new Option("l", "language", true, "the person's preferred language");
    private static final Option OPT_REQUIRE_CERTIFICATE = new Option("c", "requireCertificate", true, "if 'true', an X.509 certificate will be required for login");
    private static final Option OPT_CAN_LOGIN = new Option("C", "canLogIn", true, "'true' if the user can log in");
    private static final Option OPT_EMAIL = new Option("m", "email", true, "the user's email address, empty for none");
    private static final Option OPT_NETID = new Option("n", "netid", true, "network ID associated with the person, empty for none");
    private static final Option OPT_NEW_EMAIL = new Option("i", "newEmail", true, "new email address");
    private static final Option OPT_NEW_NETID = new Option("I", "newNetid", true, "new network ID");

    EPerson(Context context, TableRow row) {
        this.myContext = context;
        this.myRow = row;
        context.cache(this, row.getIntColumn("eperson_id"));
        this.modified = false;
        this.modifiedMetadata = false;
        this.clearDetails();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EPerson other = (EPerson)obj;
        if (this.getID() != other.getID()) {
            return false;
        }
        if (!this.getEmail().equals(other.getEmail())) {
            return false;
        }
        return this.getFullName().equals(other.getFullName());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + this.getID();
        hash = 89 * hash + (this.getEmail() != null ? this.getEmail().hashCode() : 0);
        hash = 89 * hash + (this.getFullName() != null ? this.getFullName().hashCode() : 0);
        return hash;
    }

    public static EPerson find(Context context, int id) throws SQLException {
        EPerson fromCache = (EPerson)context.fromCache(EPerson.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "eperson", id);
        if (row == null) {
            return null;
        }
        return new EPerson(context, row);
    }

    public static EPerson findByEmail(Context context, String email) throws SQLException, AuthorizeException {
        if (email == null) {
            return null;
        }
        TableRow row = DatabaseManager.findByUnique(context, "eperson", "email", email.toLowerCase());
        if (row == null) {
            return null;
        }
        EPerson fromCache = (EPerson)context.fromCache(EPerson.class, row.getIntColumn("eperson_id"));
        if (fromCache != null) {
            return fromCache;
        }
        return new EPerson(context, row);
    }

    public static EPerson findByNetid(Context context, String netid) throws SQLException {
        if (netid == null) {
            return null;
        }
        TableRow row = DatabaseManager.findByUnique(context, "eperson", "netid", netid);
        if (row == null) {
            return null;
        }
        EPerson fromCache = (EPerson)context.fromCache(EPerson.class, row.getIntColumn("eperson_id"));
        if (fromCache != null) {
            return fromCache;
        }
        return new EPerson(context, row);
    }

    public static EPerson[] search(Context context, String query) throws SQLException {
        return EPerson.search(context, query, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EPerson[] search(Context context, String query, int offset, int limit) throws SQLException {
        Integer int_param;
        String params = "%" + query.toLowerCase() + "%";
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("SELECT * FROM eperson WHERE eperson_id = ? OR ");
        queryBuf.append("LOWER(firstname) LIKE LOWER(?) OR LOWER(lastname) LIKE LOWER(?) OR LOWER(email) LIKE LOWER(?) ORDER BY lastname, firstname ASC ");
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            if (limit > 0 || offset > 0) {
                queryBuf.insert(0, "SELECT /*+ FIRST_ROWS(n) */ rec.*, ROWNUM rnum  FROM (");
                queryBuf.append(") ");
            }
            if (limit > 0) {
                queryBuf.append("rec WHERE rownum<=? ");
                if (offset > 0) {
                    limit += offset;
                }
            }
            if (offset > 0) {
                queryBuf.insert(0, "SELECT * FROM (");
                queryBuf.append(") WHERE rnum>?");
            }
        } else {
            if (limit > 0) {
                queryBuf.append(" LIMIT ? ");
            }
            if (offset > 0) {
                queryBuf.append(" OFFSET ? ");
            }
        }
        String dbquery = queryBuf.toString();
        try {
            int_param = Integer.valueOf(query);
        }
        catch (NumberFormatException e) {
            int_param = -1;
        }
        Object[] paramArr = new Object[]{int_param, params, params, params};
        if (limit > 0 && offset > 0) {
            paramArr = new Object[]{int_param, params, params, params, limit, offset};
        } else if (limit > 0) {
            paramArr = new Object[]{int_param, params, params, params, limit};
        } else if (offset > 0) {
            paramArr = new Object[]{int_param, params, params, params, offset};
        }
        TableRowIterator rows = DatabaseManager.query(context, dbquery, paramArr);
        try {
            List<TableRow> epeopleRows = rows.toList();
            EPerson[] epeople = new EPerson[epeopleRows.size()];
            for (int i = 0; i < epeopleRows.size(); ++i) {
                TableRow row = epeopleRows.get(i);
                EPerson fromCache = (EPerson)context.fromCache(EPerson.class, row.getIntColumn("eperson_id"));
                epeople[i] = fromCache != null ? fromCache : new EPerson(context, row);
            }
            EPerson[] ePersonArray = epeople;
            return ePersonArray;
        }
        finally {
            if (rows != null) {
                rows.close();
            }
        }
    }

    public static int searchResultCount(Context context, String query) throws SQLException {
        Integer int_param;
        String dbquery = "%" + query.toLowerCase() + "%";
        try {
            int_param = Integer.valueOf(query);
        }
        catch (NumberFormatException e) {
            int_param = -1;
        }
        TableRow row = DatabaseManager.querySingle(context, "SELECT count(*) as epcount FROM eperson WHERE eperson_id = ? OR LOWER(firstname) LIKE LOWER(?) OR LOWER(lastname) LIKE LOWER(?) OR LOWER(email) LIKE LOWER(?)", int_param, dbquery, dbquery, dbquery);
        Long count = "oracle".equals(ConfigurationManager.getProperty("db.name")) ? Long.valueOf(row.getIntColumn("epcount")) : Long.valueOf(row.getLongColumn("epcount"));
        return count.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EPerson[] findAll(Context context, int sortField) throws SQLException {
        String s;
        switch (sortField) {
            case 3: {
                s = "eperson_id";
                break;
            }
            case 1: {
                s = "email";
                break;
            }
            case 5: {
                s = "language";
                break;
            }
            case 4: {
                s = "netid";
                break;
            }
            default: {
                s = "lastname";
            }
        }
        TableRowIterator rows = DatabaseManager.query(context, "SELECT * FROM eperson ORDER BY " + s, new Object[0]);
        try {
            List<TableRow> epeopleRows = rows.toList();
            EPerson[] epeople = new EPerson[epeopleRows.size()];
            for (int i = 0; i < epeopleRows.size(); ++i) {
                TableRow row = epeopleRows.get(i);
                EPerson fromCache = (EPerson)context.fromCache(EPerson.class, row.getIntColumn("eperson_id"));
                epeople[i] = fromCache != null ? fromCache : new EPerson(context, row);
            }
            EPerson[] ePersonArray = epeople;
            return ePersonArray;
        }
        finally {
            if (rows != null) {
                rows.close();
            }
        }
    }

    public static EPerson create(Context context) throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to create an EPerson");
        }
        TableRow row = DatabaseManager.create(context, "eperson");
        EPerson e = new EPerson(context, row);
        log.info((Object)LogManager.getHeader(context, "create_eperson", "eperson_id=" + e.getID()));
        context.addEvent(new Event(1, 7, e.getID(), null));
        return e;
    }

    public void delete() throws SQLException, AuthorizeException, EPersonDeletionException {
        if (!AuthorizeManager.isAdmin(this.myContext)) {
            throw new AuthorizeException("You must be an admin to delete an EPerson");
        }
        List<String> constraintList = this.getDeleteConstraints();
        if (constraintList.size() > 0) {
            throw new EPersonDeletionException(constraintList);
        }
        this.myContext.addEvent(new Event(32, 7, this.getID(), this.getEmail()));
        this.myContext.removeCached(this, this.getID());
        DatabaseManager.updateQuery(this.myContext, "DELETE FROM EPersonGroup2EPerson WHERE eperson_id= ? ", this.getID());
        DatabaseManager.updateQuery(this.myContext, "DELETE FROM subscription WHERE eperson_id= ? ", this.getID());
        DatabaseManager.delete(this.myContext, this.myRow);
        log.info((Object)LogManager.getHeader(this.myContext, "delete_eperson", "eperson_id=" + this.getID()));
    }

    @Override
    public int getID() {
        return this.myRow.getIntColumn("eperson_id");
    }

    public String getLanguage() {
        return this.myRow.getStringColumn("language");
    }

    public void setLanguage(String language) {
        this.myRow.setColumn("language", language);
    }

    @Override
    public String getHandle() {
        return null;
    }

    public String getEmail() {
        return this.myRow.getStringColumn("email");
    }

    public void setEmail(String s) {
        if (s != null) {
            s = s.toLowerCase();
        }
        this.myRow.setColumn("email", s);
        this.modified = true;
    }

    public String getNetid() {
        return this.myRow.getStringColumn("netid");
    }

    public void setNetid(String s) {
        this.myRow.setColumn("netid", s);
        this.modified = true;
    }

    public String getFullName() {
        String f = this.myRow.getStringColumn("firstname");
        String l = this.myRow.getStringColumn("lastname");
        if (l == null && f == null) {
            return this.getEmail();
        }
        if (f == null) {
            return l;
        }
        return f + " " + l;
    }

    public String getFirstName() {
        return this.myRow.getStringColumn("firstname");
    }

    public void setFirstName(String firstname) {
        this.myRow.setColumn("firstname", firstname);
        this.modified = true;
    }

    public String getLastName() {
        return this.myRow.getStringColumn("lastname");
    }

    public void setLastName(String lastname) {
        this.myRow.setColumn("lastname", lastname);
        this.modified = true;
    }

    public void setCanLogIn(boolean login) {
        this.myRow.setColumn("can_log_in", login);
        this.modified = true;
    }

    public boolean canLogIn() {
        return this.myRow.getBooleanColumn("can_log_in");
    }

    public void setRequireCertificate(boolean isrequired) {
        this.myRow.setColumn("require_certificate", isrequired);
        this.modified = true;
    }

    public boolean getRequireCertificate() {
        return this.myRow.getBooleanColumn("require_certificate");
    }

    public void setSelfRegistered(boolean sr) {
        this.myRow.setColumn("self_registered", sr);
        this.modified = true;
    }

    public boolean getSelfRegistered() {
        return this.myRow.getBooleanColumn("self_registered");
    }

    public String getMetadata(String field) {
        return this.myRow.getStringColumn(field);
    }

    public void setMetadata(String field, String value) {
        this.myRow.setColumn(field, value);
        this.modifiedMetadata = true;
        this.addDetails(field);
    }

    public void setPassword(String s) {
        PasswordHash hash = new PasswordHash(s);
        this.myRow.setColumn("password", Utils.toHex(hash.getHash()));
        this.myRow.setColumn("salt", Utils.toHex(hash.getSalt()));
        this.myRow.setColumn("digest_algorithm", hash.getAlgorithm());
        this.modified = true;
    }

    public void setPasswordHash(PasswordHash password) {
        if (null == password) {
            this.myRow.setColumnNull("digest_algorithm");
            this.myRow.setColumnNull("salt");
            this.myRow.setColumnNull("password");
        } else {
            this.myRow.setColumn("digest_algorithm", password.getAlgorithm());
            this.myRow.setColumn("salt", password.getSaltString());
            this.myRow.setColumn("password", password.getHashString());
        }
        this.modified = true;
    }

    public PasswordHash getPasswordHash() {
        PasswordHash hash = null;
        try {
            hash = new PasswordHash(this.myRow.getStringColumn("digest_algorithm"), this.myRow.getStringColumn("salt"), this.myRow.getStringColumn("password"));
        }
        catch (DecoderException ex) {
            log.error((Object)("Problem decoding stored salt or hash:  " + ex.getMessage()));
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPassword(String attempt) {
        PasswordHash myHash;
        try {
            myHash = new PasswordHash(this.myRow.getStringColumn("digest_algorithm"), this.myRow.getStringColumn("salt"), this.myRow.getStringColumn("password"));
        }
        catch (DecoderException ex) {
            log.error((Object)ex.getMessage());
            return false;
        }
        boolean answer = myHash.matches(attempt);
        if (answer && null == this.myRow.getStringColumn("digest_algorithm")) {
            log.info((Object)("Upgrading password hash for EPerson " + this.getID()));
            this.setPassword(attempt);
            try {
                this.myContext.turnOffAuthorisationSystem();
                this.update();
            }
            catch (SQLException ex) {
                log.error((Object)"Could not update password hash", (Throwable)ex);
            }
            catch (AuthorizeException ex) {
                log.error((Object)"Could not update password hash", (Throwable)ex);
            }
            finally {
                this.myContext.restoreAuthSystemState();
            }
        }
        return answer;
    }

    public void setLastActive(Date when) {
        this.myRow.setColumn("last_active", when);
    }

    public Date getLastActive() {
        return this.myRow.getDateColumn("last_active");
    }

    @Override
    public void update() throws SQLException, AuthorizeException {
        if (!(this.myContext.ignoreAuthorization() || this.myContext.getCurrentUser() != null && this.getID() == this.myContext.getCurrentUser().getID())) {
            AuthorizeManager.authorizeAction(this.myContext, this, 1);
        }
        DatabaseManager.update(this.myContext, this.myRow);
        log.info((Object)LogManager.getHeader(this.myContext, "update_eperson", "eperson_id=" + this.getID()));
        if (this.modified) {
            this.myContext.addEvent(new Event(2, 7, this.getID(), null));
            this.modified = false;
        }
        if (this.modifiedMetadata) {
            this.myContext.addEvent(new Event(4, 7, this.getID(), this.getDetails()));
            this.modifiedMetadata = false;
            this.clearDetails();
        }
    }

    @Override
    public int getType() {
        return 7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDeleteConstraints() throws SQLException {
        ArrayList<String> tableList = new ArrayList<String>();
        TableRowIterator tri = DatabaseManager.query(this.myContext, "SELECT * from item where submitter_id= ? ", this.getID());
        try {
            if (tri.hasNext()) {
                tableList.add("item");
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        if (ConfigurationManager.getProperty("workflow", "workflow.framework").equals("xmlworkflow")) {
            this.getXMLWorkflowConstraints(tableList);
        } else {
            this.getOriginalWorkflowConstraints(tableList);
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getXMLWorkflowConstraints(List<String> tableList) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(this.myContext, "cwf_claimtask", "SELECT * from cwf_claimtask where owner_id= ? ", this.getID());
        try {
            if (tri.hasNext()) {
                tableList.add("cwf_claimtask");
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        tri = DatabaseManager.queryTable(this.myContext, "cwf_pooltask", "SELECT * from cwf_pooltask where eperson_id= ? ", this.getID());
        try {
            if (tri.hasNext()) {
                tableList.add("cwf_pooltask");
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        tri = DatabaseManager.queryTable(this.myContext, "cwf_workflowitemrole", "SELECT * from cwf_workflowitemrole where eperson_id= ? ", this.getID());
        try {
            if (tri.hasNext()) {
                tableList.add("cwf_workflowitemrole");
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getOriginalWorkflowConstraints(List<String> tableList) throws SQLException {
        TableRowIterator tri = DatabaseManager.query(this.myContext, "SELECT * from workflowitem where owner= ? ", this.getID());
        try {
            if (tri.hasNext()) {
                tableList.add("workflowitem");
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        tri = DatabaseManager.query(this.myContext, "SELECT * from tasklistitem where eperson_id= ? ", this.getID());
        try {
            if (tri.hasNext()) {
                tableList.add("tasklistitem");
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    @Override
    public String getName() {
        return this.getEmail();
    }

    @Override
    public void updateLastModified() {
    }

    public static void main(String[] argv) throws ParseException, SQLException {
        OptionGroup VERBS = new OptionGroup();
        VERBS.addOption(VERB_ADD);
        VERBS.addOption(VERB_DELETE);
        VERBS.addOption(VERB_LIST);
        VERBS.addOption(VERB_MODIFY);
        Options globalOptions = new Options();
        globalOptions.addOptionGroup(VERBS);
        globalOptions.addOption("h", "help", false, "explain options");
        GnuParser parser = new GnuParser();
        CommandLine command = parser.parse(globalOptions, argv, true);
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        int status = 0;
        if (command.hasOption(VERB_ADD.getOpt())) {
            status = EPerson.cmdAdd(context, argv);
        } else if (command.hasOption(VERB_DELETE.getOpt())) {
            status = EPerson.cmdDelete(context, argv);
        } else if (command.hasOption(VERB_MODIFY.getOpt())) {
            status = EPerson.cmdModify(context, argv);
        } else if (command.hasOption(VERB_LIST.getOpt())) {
            status = EPerson.cmdList(context, argv);
        } else if (command.hasOption('h')) {
            new HelpFormatter().printHelp("user [options]", globalOptions);
        } else {
            System.err.println("Unknown operation.");
            new HelpFormatter().printHelp("user [options]", globalOptions);
            context.abort();
            status = 1;
            throw new IllegalArgumentException();
        }
        if (context.isValid()) {
            try {
                context.complete();
            }
            catch (SQLException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }

    private static int cmdAdd(Context context, String[] argv) {
        CommandLine command;
        Options options = new Options();
        options.addOption(VERB_ADD);
        OptionGroup identityOptions = new OptionGroup();
        identityOptions.addOption(OPT_EMAIL);
        identityOptions.addOption(OPT_NETID);
        options.addOptionGroup(identityOptions);
        options.addOption(OPT_GIVENNAME);
        options.addOption(OPT_SURNAME);
        options.addOption(OPT_PHONE);
        options.addOption(OPT_LANGUAGE);
        options.addOption(OPT_REQUIRE_CERTIFICATE);
        Option option = new Option("p", "password", true, "password to match the EPerson name");
        options.addOption(option);
        options.addOption("h", "help", false, "explain --add options");
        GnuParser parser = new GnuParser();
        try {
            command = parser.parse(options, argv);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        if (command.hasOption('h')) {
            new HelpFormatter().printHelp("user --add [options]", options);
            return 0;
        }
        if (!command.hasOption(OPT_EMAIL.getOpt()) && !command.hasOption(OPT_NETID.getOpt())) {
            System.err.println("You must provide an email address or a netid to identify the new user.");
            return 1;
        }
        if (!command.hasOption('p')) {
            System.err.println("You must provide a password for the new user.");
            return 1;
        }
        EPerson eperson = null;
        try {
            eperson = EPerson.create(context);
        }
        catch (SQLException ex) {
            context.abort();
            System.err.println(ex.getMessage());
            return 1;
        }
        catch (AuthorizeException ex) {
            // empty catch block
        }
        eperson.setCanLogIn(true);
        eperson.setSelfRegistered(false);
        eperson.setEmail(command.getOptionValue(OPT_EMAIL.getOpt()));
        eperson.setFirstName(command.getOptionValue(OPT_GIVENNAME.getOpt()));
        eperson.setLastName(command.getOptionValue(OPT_SURNAME.getOpt()));
        eperson.setLanguage(command.getOptionValue(OPT_LANGUAGE.getOpt(), Locale.getDefault().getLanguage()));
        eperson.setMetadata("phone", command.getOptionValue(OPT_PHONE.getOpt()));
        eperson.setNetid(command.getOptionValue(OPT_NETID.getOpt()));
        eperson.setPassword(command.getOptionValue('p'));
        if (command.hasOption(OPT_REQUIRE_CERTIFICATE.getOpt())) {
            eperson.setRequireCertificate(Boolean.valueOf(command.getOptionValue(OPT_REQUIRE_CERTIFICATE.getOpt())));
        } else {
            eperson.setRequireCertificate(false);
        }
        try {
            eperson.update();
            context.commit();
            System.out.printf("Created EPerson %d\n", eperson.getID());
        }
        catch (SQLException ex) {
            context.abort();
            System.err.println(ex.getMessage());
            return 1;
        }
        catch (AuthorizeException authorizeException) {
            // empty catch block
        }
        return 0;
    }

    private static int cmdDelete(Context context, String[] argv) {
        EPerson eperson;
        block13: {
            CommandLine command;
            Options options = new Options();
            options.addOption(VERB_DELETE);
            OptionGroup identityOptions = new OptionGroup();
            identityOptions.addOption(OPT_EMAIL);
            identityOptions.addOption(OPT_NETID);
            options.addOptionGroup(identityOptions);
            options.addOption("h", "help", false, "explain --delete options");
            GnuParser parser = new GnuParser();
            try {
                command = parser.parse(options, argv);
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            if (command.hasOption('h')) {
                new HelpFormatter().printHelp("user --delete [options]", options);
                return 0;
            }
            eperson = null;
            try {
                if (command.hasOption(OPT_NETID.getOpt())) {
                    eperson = EPerson.findByNetid(context, command.getOptionValue(OPT_NETID.getOpt()));
                    break block13;
                }
                if (command.hasOption(OPT_EMAIL.getOpt())) {
                    eperson = EPerson.findByEmail(context, command.getOptionValue(OPT_EMAIL.getOpt()));
                    break block13;
                }
                System.err.println("You must specify the user's email address or netid.");
                return 1;
            }
            catch (SQLException e) {
                System.err.append(e.getMessage());
                return 1;
            }
            catch (AuthorizeException e) {
                // empty catch block
            }
        }
        if (null == eperson) {
            System.err.println("No such EPerson");
            return 1;
        }
        try {
            eperson.delete();
            context.commit();
            System.out.printf("Deleted EPerson %d\n", eperson.getID());
        }
        catch (SQLException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        catch (AuthorizeException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        catch (EPersonDeletionException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        return 0;
    }

    private static int cmdModify(Context context, String[] argv) {
        EPerson eperson;
        CommandLine command;
        block22: {
            Options options = new Options();
            options.addOption(VERB_MODIFY);
            OptionGroup identityOptions = new OptionGroup();
            identityOptions.addOption(OPT_EMAIL);
            identityOptions.addOption(OPT_NETID);
            options.addOptionGroup(identityOptions);
            options.addOption(OPT_GIVENNAME);
            options.addOption(OPT_SURNAME);
            options.addOption(OPT_PHONE);
            options.addOption(OPT_LANGUAGE);
            options.addOption(OPT_REQUIRE_CERTIFICATE);
            options.addOption(OPT_CAN_LOGIN);
            options.addOption(OPT_NEW_EMAIL);
            options.addOption(OPT_NEW_NETID);
            options.addOption("h", "help", false, "explain --modify options");
            GnuParser parser = new GnuParser();
            try {
                command = parser.parse(options, argv);
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
                return 1;
            }
            if (command.hasOption('h')) {
                new HelpFormatter().printHelp("user --modify [options]", options);
                return 0;
            }
            eperson = null;
            try {
                if (command.hasOption(OPT_NETID.getOpt())) {
                    eperson = EPerson.findByNetid(context, command.getOptionValue(OPT_NETID.getOpt()));
                    break block22;
                }
                if (command.hasOption(OPT_EMAIL.getOpt())) {
                    eperson = EPerson.findByEmail(context, command.getOptionValue(OPT_EMAIL.getOpt()));
                    break block22;
                }
                System.err.println("No EPerson selected");
                return 1;
            }
            catch (SQLException e) {
                System.err.append(e.getMessage());
                return 1;
            }
            catch (AuthorizeException e) {
                // empty catch block
            }
        }
        boolean modified = false;
        if (null == eperson) {
            System.err.println("No such EPerson");
            return 1;
        }
        if (command.hasOption(OPT_NEW_EMAIL.getOpt())) {
            eperson.setEmail(command.getOptionValue(OPT_NEW_EMAIL.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_NEW_NETID.getOpt())) {
            eperson.setNetid(command.getOptionValue(OPT_NEW_NETID.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_GIVENNAME.getOpt())) {
            eperson.setFirstName(command.getOptionValue(OPT_GIVENNAME.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_SURNAME.getOpt())) {
            eperson.setLastName(command.getOptionValue(OPT_SURNAME.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_PHONE.getOpt())) {
            eperson.setMetadata("phone", command.getOptionValue(OPT_PHONE.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_LANGUAGE.getOpt())) {
            eperson.setLanguage(command.getOptionValue(OPT_LANGUAGE.getOpt()));
            modified = true;
        }
        if (command.hasOption(OPT_REQUIRE_CERTIFICATE.getOpt())) {
            eperson.setRequireCertificate(Boolean.valueOf(command.getOptionValue(OPT_REQUIRE_CERTIFICATE.getOpt())));
            modified = true;
        }
        if (command.hasOption(OPT_CAN_LOGIN.getOpt())) {
            eperson.setCanLogIn(Boolean.valueOf(command.getOptionValue(OPT_CAN_LOGIN.getOpt())));
            modified = true;
        }
        if (modified) {
            try {
                eperson.update();
                context.commit();
                System.out.printf("Modified EPerson %d\n", eperson.getID());
            }
            catch (SQLException ex) {
                context.abort();
                System.err.println(ex.getMessage());
                return 1;
            }
            catch (AuthorizeException authorizeException) {}
        } else {
            System.out.println("No changes.");
        }
        return 0;
    }

    private static int cmdList(Context context, String[] argv) {
        try {
            for (EPerson person : EPerson.findAll(context, 1)) {
                System.out.printf("%d\t%s/%s\t%s, %s\n", person.getID(), person.getEmail(), person.getNetid(), person.getLastName(), person.getFirstName());
            }
        }
        catch (SQLException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        return 0;
    }
}

