/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.lookup;

import gr.ekt.bte.core.Record;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.dspace.app.util.XMLUtils;
import org.dspace.submit.lookup.CiNiiUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CiNiiService {
    private static Logger log = Logger.getLogger(CiNiiService.class);
    private int timeout = 1000;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Record getByCiNiiID(String id, String appId) throws HttpException, IOException {
        return this.search(id, appId);
    }

    public List<Record> searchByTerm(String title, String author, int year, int maxResults, String appId) throws HttpException, IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        List<String> ids = this.getCiNiiIDs(title, author, year, maxResults, appId);
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                Record record = this.search(id, appId);
                if (record == null) continue;
                records.add(record);
            }
        }
        return records;
    }

    private Record search(String id, String appId) throws IOException, HttpException {
        GetMethod method = null;
        try {
            HttpClient client = new HttpClient();
            client.setTimeout(this.timeout);
            method = new GetMethod("http://ci.nii.ac.jp/naid/" + id + ".rdf?appid=" + appId);
            int statusCode = client.executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                if (statusCode == 400) {
                    throw new RuntimeException("CiNii RDF is not valid");
                }
                throw new RuntimeException("CiNii RDF Http call failed: " + method.getStatusLine());
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                factory.setIgnoringElementContentWhitespace(true);
                DocumentBuilder db = factory.newDocumentBuilder();
                Document inDoc = db.parse(method.getResponseBodyAsStream());
                Element xmlRoot = inDoc.getDocumentElement();
                Record record = CiNiiUtils.convertCiNiiDomToRecord(xmlRoot);
                return record;
            }
            catch (Exception e) {
                throw new RuntimeException("CiNii RDF identifier is not valid or not exist");
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private List<String> getCiNiiIDs(String title, String author, int year, int maxResults, String appId) throws IOException, HttpException {
        if (title == null && author == null && year == -1) {
            return null;
        }
        GetMethod method = null;
        ArrayList<String> ids = new ArrayList<String>();
        try {
            int statusCode;
            HttpClient client = new HttpClient();
            client.setTimeout(this.timeout);
            StringBuilder query = new StringBuilder();
            query.append("format=rss&appid=").append(appId).append("&count=").append(maxResults);
            if (title != null) {
                query.append("&title=").append(URLEncoder.encode(title, "UTF-8"));
            }
            if (author != null) {
                query.append("&author=").append(URLEncoder.encode(author, "UTF-8"));
            }
            if (year != -1) {
                query.append("&year_from=").append(String.valueOf(year));
                query.append("&year_to=").append(String.valueOf(year));
            }
            if ((statusCode = client.executeMethod((HttpMethod)(method = new GetMethod("http://ci.nii.ac.jp/opensearch/search?" + query.toString())))) != 200) {
                if (statusCode == 400) {
                    throw new RuntimeException("CiNii OpenSearch query is not valid");
                }
                throw new RuntimeException("CiNii OpenSearch call failed: " + method.getStatusLine());
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                factory.setIgnoringElementContentWhitespace(true);
                DocumentBuilder db = factory.newDocumentBuilder();
                Document inDoc = db.parse(method.getResponseBodyAsStream());
                Element xmlRoot = inDoc.getDocumentElement();
                List<Element> items = XMLUtils.getElementList(xmlRoot, "item");
                int url_len = "http://ci.nii.ac.jp/naid/".length();
                for (Element item : items) {
                    String about = item.getAttribute("rdf:about");
                    if (about.length() <= url_len) continue;
                    ids.add(about.substring(url_len));
                }
                ArrayList<String> arrayList = ids;
                return arrayList;
            }
            catch (Exception e) {
                throw new RuntimeException("CiNii OpenSearch results is not valid or not exist");
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }
}

