/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.workflow;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InstallItem;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.curate.WorkflowCurator;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.handle.HandleManager;
import org.dspace.services.ConfigurationService;
import org.dspace.services.model.Event;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;
import org.dspace.usage.UsageWorkflowEvent;
import org.dspace.utils.DSpace;
import org.dspace.workflow.WorkflowItem;

public class WorkflowManager {
    public static final int WFSTATE_SUBMIT = 0;
    public static final int WFSTATE_STEP1POOL = 1;
    public static final int WFSTATE_STEP1 = 2;
    public static final int WFSTATE_STEP2POOL = 3;
    public static final int WFSTATE_STEP2 = 4;
    public static final int WFSTATE_STEP3POOL = 5;
    public static final int WFSTATE_STEP3 = 6;
    public static final int WFSTATE_ARCHIVE = 7;
    private static final String[] workflowText = new String[]{"SUBMIT", "STEP1POOL", "STEP1", "STEP2POOL", "STEP2", "STEP3POOL", "STEP3", "ARCHIVE"};
    private static final Map<Integer, Boolean> noEMail = new HashMap<Integer, Boolean>();
    private static Logger log = Logger.getLogger(WorkflowManager.class);

    public static int getWorkflowID(String state) {
        for (int i = 0; i < workflowText.length; ++i) {
            if (!state.equalsIgnoreCase(workflowText[i])) continue;
            return i;
        }
        return -1;
    }

    public static WorkflowItem start(Context c, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException {
        Item myitem = wsi.getItem();
        Collection collection = wsi.getCollection();
        log.info((Object)LogManager.getHeader(c, "start_workflow", "workspace_item_id=" + wsi.getID() + "item_id=" + myitem.getID() + "collection_id=" + collection.getID()));
        WorkflowManager.recordStart(c, myitem);
        TableRow row = DatabaseManager.row("workflowitem");
        row.setColumn("item_id", myitem.getID());
        row.setColumn("collection_id", wsi.getCollection().getID());
        DatabaseManager.insert(c, row);
        WorkflowItem wfi = new WorkflowItem(c, row);
        wfi.setMultipleFiles(wsi.hasMultipleFiles());
        wfi.setMultipleTitles(wsi.hasMultipleTitles());
        wfi.setPublishedBefore(wsi.isPublishedBefore());
        wsi.deleteWrapper();
        wfi.setState(0);
        WorkflowManager.advance(c, wfi, null);
        return wfi;
    }

    public static WorkflowItem startWithoutNotify(Context c, WorkspaceItem wsi) throws SQLException, AuthorizeException, IOException {
        noEMail.put(wsi.getItem().getID(), Boolean.TRUE);
        return WorkflowManager.start(c, wsi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WorkflowItem> getOwnedTasks(Context c, EPerson e) throws SQLException {
        ArrayList<WorkflowItem> mylist = new ArrayList<WorkflowItem>();
        String myquery = "SELECT * FROM WorkflowItem WHERE owner= ? ";
        TableRowIterator tri = DatabaseManager.queryTable(c, "workflowitem", myquery, e.getID());
        try {
            while (tri.hasNext()) {
                mylist.add(new WorkflowItem(c, tri.next()));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return mylist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WorkflowItem> getPooledTasks(Context c, EPerson e) throws SQLException {
        ArrayList<WorkflowItem> mylist = new ArrayList<WorkflowItem>();
        String myquery = "SELECT workflowitem.* FROM workflowitem, TaskListItem WHERE tasklistitem.eperson_id= ?  AND tasklistitem.workflow_id=workflowitem.workflow_id";
        TableRowIterator tri = DatabaseManager.queryTable(c, "workflowitem", myquery, e.getID());
        try {
            while (tri.hasNext()) {
                mylist.add(new WorkflowItem(c, tri.next()));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return mylist;
    }

    public static void claim(Context c, WorkflowItem wi, EPerson e) throws SQLException, IOException, AuthorizeException {
        int taskstate = wi.getState();
        switch (taskstate) {
            case 1: {
                AuthorizeManager.authorizeAction(c, wi.getCollection(), 5, true);
                WorkflowManager.doState(c, wi, 2, e);
                break;
            }
            case 3: {
                AuthorizeManager.authorizeAction(c, wi.getCollection(), 6, true);
                WorkflowManager.doState(c, wi, 4, e);
                break;
            }
            case 5: {
                AuthorizeManager.authorizeAction(c, wi.getCollection(), 7, true);
                WorkflowManager.doState(c, wi, 6, e);
                break;
            }
            default: {
                throw new IllegalArgumentException("Workflow Step " + taskstate + " is out of range.");
            }
        }
        log.info((Object)LogManager.getHeader(c, "claim_task", "workflow_item_id=" + wi.getID() + "item_id=" + wi.getItem().getID() + "collection_id=" + wi.getCollection().getID() + "newowner_id=" + wi.getOwner().getID() + "old_state=" + taskstate + "new_state=" + wi.getState()));
    }

    public static void advance(Context c, WorkflowItem wi, EPerson e) throws SQLException, IOException, AuthorizeException {
        WorkflowManager.advance(c, wi, e, true, true);
    }

    public static boolean advance(Context c, WorkflowItem wi, EPerson e, boolean curate, boolean record) throws SQLException, IOException, AuthorizeException {
        int taskstate = wi.getState();
        boolean archived = false;
        if (curate && WorkflowCurator.needsCuration(wi) && !WorkflowCurator.doCuration(c, wi)) {
            log.info((Object)LogManager.getHeader(c, "advance_workflow", "workflow_item_id=" + wi.getID() + ",item_id=" + wi.getItem().getID() + ",collection_id=" + wi.getCollection().getID() + ",old_state=" + taskstate + ",doCuration=false"));
            return archived;
        }
        switch (taskstate) {
            case 0: {
                archived = WorkflowManager.doState(c, wi, 1, e);
                break;
            }
            case 2: {
                if (wi.getCollection().getWorkflowGroup(1) != null) {
                    AuthorizeManager.authorizeAction(c, wi.getCollection(), 5, true);
                }
                if (record) {
                    WorkflowManager.recordApproval(c, wi, e);
                }
                archived = WorkflowManager.doState(c, wi, 3, e);
                break;
            }
            case 4: {
                if (wi.getCollection().getWorkflowGroup(2) != null) {
                    AuthorizeManager.authorizeAction(c, wi.getCollection(), 6, true);
                }
                if (record) {
                    WorkflowManager.recordApproval(c, wi, e);
                }
                archived = WorkflowManager.doState(c, wi, 5, e);
                break;
            }
            case 6: {
                if (wi.getCollection().getWorkflowGroup(3) != null) {
                    AuthorizeManager.authorizeAction(c, wi.getCollection(), 7, true);
                }
                archived = WorkflowManager.doState(c, wi, 7, e);
            }
        }
        log.info((Object)LogManager.getHeader(c, "advance_workflow", "workflow_item_id=" + wi.getID() + ",item_id=" + wi.getItem().getID() + ",collection_id=" + wi.getCollection().getID() + ",old_state=" + taskstate + ",new_state=" + wi.getState()));
        return archived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unclaim(Context c, WorkflowItem wi, EPerson e) throws SQLException, IOException, AuthorizeException {
        int taskstate = wi.getState();
        switch (taskstate) {
            case 2: {
                WorkflowManager.doState(c, wi, 1, e);
                break;
            }
            case 4: {
                WorkflowManager.doState(c, wi, 3, e);
                break;
            }
            case 6: {
                WorkflowManager.doState(c, wi, 5, e);
                break;
            }
            default: {
                throw new IllegalStateException("WorkflowItem reached an unknown state.");
            }
        }
        try {
            c.turnOffAuthorisationSystem();
            wi.update();
        }
        finally {
            c.restoreAuthSystemState();
        }
        log.info((Object)LogManager.getHeader(c, "unclaim_workflow", "workflow_item_id=" + wi.getID() + ",item_id=" + wi.getItem().getID() + ",collection_id=" + wi.getCollection().getID() + ",old_state=" + taskstate + ",new_state=" + wi.getState()));
    }

    public static void abort(Context c, WorkflowItem wi, EPerson e) throws SQLException, AuthorizeException, IOException {
        if (!AuthorizeManager.isAdmin(c)) {
            throw new AuthorizeException("You must be an admin to abort a workflow");
        }
        WorkflowManager.deleteTasks(c, wi);
        log.info((Object)LogManager.getHeader(c, "abort_workflow", "workflow_item_id=" + wi.getID() + "item_id=" + wi.getItem().getID() + "collection_id=" + wi.getCollection().getID() + "eperson_id=" + e.getID()));
        WorkflowManager.returnToWorkspace(c, wi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doState(Context c, WorkflowItem wi, int newstate, EPerson newowner) throws SQLException, IOException, AuthorizeException {
        boolean archived;
        Collection mycollection = wi.getCollection();
        int oldState = wi.getState();
        wi.setState(newstate);
        switch (newstate) {
            case 1: {
                archived = WorkflowManager.pool(c, wi, 1);
                break;
            }
            case 2: {
                WorkflowManager.assignToReviewer(c, wi, 1, newowner);
                archived = false;
                break;
            }
            case 3: {
                archived = WorkflowManager.pool(c, wi, 2);
                break;
            }
            case 4: {
                WorkflowManager.assignToReviewer(c, wi, 2, newowner);
                archived = false;
                break;
            }
            case 5: {
                archived = WorkflowManager.pool(c, wi, 3);
                break;
            }
            case 6: {
                WorkflowManager.assignToReviewer(c, wi, 3, newowner);
                archived = false;
                break;
            }
            case 7: {
                WorkflowManager.deleteTasks(c, wi);
                mycollection = wi.getCollection();
                Item myItem = WorkflowManager.archive(c, wi);
                WorkflowManager.notifyOfArchive(c, myItem, mycollection);
                try {
                    c.turnOffAuthorisationSystem();
                    WorkflowManager.revokeReviewerPolicies(c, myItem);
                }
                finally {
                    c.restoreAuthSystemState();
                }
                WorkflowManager.logWorkflowEvent(c, wi.getItem(), wi, c.getCurrentUser(), newstate, newowner, mycollection, oldState, null);
                return true;
            }
            default: {
                throw new IllegalArgumentException("WorkflowManager cannot handle workflowItemState " + newstate);
            }
        }
        try {
            c.turnOffAuthorisationSystem();
            wi.update();
        }
        finally {
            c.restoreAuthSystemState();
        }
        return archived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void assignToReviewer(Context context, WorkflowItem workflowItem, int step, EPerson newowner) throws AuthorizeException, SQLException {
        int correspondingAction;
        int newState;
        Collection collection = workflowItem.getCollection();
        switch (step) {
            case 1: {
                newState = 2;
                correspondingAction = 5;
                break;
            }
            case 2: {
                newState = 4;
                correspondingAction = 6;
                break;
            }
            case 3: {
                newState = 6;
                correspondingAction = 7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown workflow step " + step);
            }
        }
        int oldState = workflowItem.getState();
        Group stateGroup = collection.getWorkflowGroup(step);
        if (stateGroup != null && !stateGroup.isEmpty()) {
            AuthorizeManager.authorizeAction(context, collection, correspondingAction, true);
        }
        try {
            context.turnOffAuthorisationSystem();
            WorkflowManager.revokeReviewerPolicies(context, workflowItem.getItem());
            WorkflowManager.grantReviewerPolicies(context, workflowItem, newowner);
        }
        finally {
            context.restoreAuthSystemState();
        }
        WorkflowManager.deleteTasks(context, workflowItem);
        workflowItem.setState(newState);
        workflowItem.setOwner(newowner);
        WorkflowManager.logWorkflowEvent(context, workflowItem.getItem(), workflowItem, context.getCurrentUser(), newState, newowner, collection, oldState, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean pool(Context context, WorkflowItem workflowItem, int step) throws SQLException, AuthorizeException, IOException {
        int correspondingState;
        int newState;
        Collection collection = workflowItem.getCollection();
        switch (step) {
            case 1: {
                newState = 1;
                correspondingState = 2;
                break;
            }
            case 2: {
                newState = 3;
                correspondingState = 4;
                break;
            }
            case 3: {
                newState = 5;
                correspondingState = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown workflow step " + step);
            }
        }
        int oldState = workflowItem.getState();
        EPerson oldOwner = workflowItem.getOwner();
        workflowItem.setOwner(null);
        Group workflowStepGroup = collection.getWorkflowGroup(step);
        if (workflowStepGroup != null && !workflowStepGroup.isEmpty()) {
            workflowItem.setState(newState);
            try {
                Bundle originalBundle;
                context.turnOffAuthorisationSystem();
                WorkflowManager.revokeReviewerPolicies(context, workflowItem.getItem());
                AuthorizeManager.addPolicy(context, (DSpaceObject)workflowItem.getItem(), 0, workflowStepGroup, ResourcePolicy.TYPE_WORKFLOW);
                try {
                    originalBundle = workflowItem.getItem().getBundles("ORIGINAL")[0];
                }
                catch (IndexOutOfBoundsException ex) {
                    originalBundle = null;
                }
                if (originalBundle != null) {
                    AuthorizeManager.addPolicy(context, (DSpaceObject)originalBundle, 0, workflowStepGroup, ResourcePolicy.TYPE_WORKFLOW);
                    for (Bitstream bitstream : originalBundle.getBitstreams()) {
                        AuthorizeManager.addPolicy(context, (DSpaceObject)bitstream, 0, workflowStepGroup, ResourcePolicy.TYPE_WORKFLOW);
                    }
                }
            }
            finally {
                context.restoreAuthSystemState();
            }
            EPerson[] epa = Group.allMembers(context, workflowStepGroup);
            WorkflowManager.createTasks(context, workflowItem, epa);
            ConfigurationService configurationService = new DSpace().getConfigurationService();
            if (((Boolean)configurationService.getPropertyAsType("workflow.notify.returned.tasks", (Object)true)).booleanValue() || oldState != correspondingState || oldOwner == null) {
                WorkflowManager.notifyGroupOfTask(context, workflowItem, workflowStepGroup, epa);
            }
            WorkflowManager.logWorkflowEvent(context, workflowItem.getItem(), workflowItem, context.getCurrentUser(), newState, null, collection, oldState, workflowStepGroup);
            return false;
        }
        workflowItem.setState(correspondingState);
        boolean archived = WorkflowManager.advance(context, workflowItem, null, true, false);
        if (archived) {
            try {
                context.turnOffAuthorisationSystem();
                WorkflowManager.revokeReviewerPolicies(context, workflowItem.getItem());
            }
            finally {
                context.restoreAuthSystemState();
            }
        }
        return archived;
    }

    private static void logWorkflowEvent(Context c, Item item, WorkflowItem workflowItem, EPerson actor, int newstate, EPerson newOwner, Collection mycollection, int oldState, Group newOwnerGroup) {
        if (newstate == 7 || newstate == 1 || newstate == 3 || newstate == 5) {
            newOwner = null;
        }
        UsageWorkflowEvent usageWorkflowEvent = new UsageWorkflowEvent(c, item, workflowItem, workflowText[newstate], workflowText[oldState], mycollection, actor);
        if (newOwner != null) {
            usageWorkflowEvent.setEpersonOwners(newOwner);
        }
        if (newOwnerGroup != null) {
            usageWorkflowEvent.setGroupOwners(newOwnerGroup);
        }
        new DSpace().getEventService().fireEvent((Event)usageWorkflowEvent);
    }

    public static String getWorkflowText(int state) {
        if (state > -1 && state < workflowText.length) {
            return workflowText[state];
        }
        throw new IllegalArgumentException("Invalid workflow state passed");
    }

    private static Item archive(Context c, WorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        Item item = wfi.getItem();
        Collection collection = wfi.getCollection();
        log.info((Object)LogManager.getHeader(c, "archive_item", "workflow_item_id=" + wfi.getID() + "item_id=" + item.getID() + "collection_id=" + collection.getID()));
        InstallItem.installItem(c, wfi);
        log.info((Object)LogManager.getHeader(c, "install_item", "workflow_id=" + wfi.getID() + ", item_id=" + item.getID() + "handle=FIXME"));
        return item;
    }

    private static void notifyOfArchive(Context c, Item i, Collection coll) throws SQLException, IOException {
        try {
            EPerson ep = i.getSubmitter();
            Locale supportedLocale = I18nUtil.getEPersonLocale(ep);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_archive"));
            String handle = HandleManager.findHandle(c, i);
            DCValue[] titles = i.getDC("title", null, "*");
            String title = "";
            try {
                title = I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled");
            }
            catch (MissingResourceException e) {
                title = "Untitled";
            }
            if (titles.length > 0) {
                title = titles[0].value;
            }
            email.addRecipient(ep.getEmail());
            email.addArgument(title);
            email.addArgument(coll.getMetadata("name"));
            email.addArgument(HandleManager.getCanonicalForm(handle));
            email.send();
        }
        catch (MessagingException e) {
            log.warn((Object)LogManager.getHeader(c, "notifyOfArchive", "cannot email user item_id=" + i.getID()));
        }
    }

    private static WorkspaceItem returnToWorkspace(Context c, WorkflowItem wfi) throws SQLException, IOException, AuthorizeException {
        Item myitem = wfi.getItem();
        Collection mycollection = wfi.getCollection();
        TableRow row = DatabaseManager.row("workspaceitem");
        row.setColumn("item_id", myitem.getID());
        row.setColumn("collection_id", mycollection.getID());
        DatabaseManager.insert(c, row);
        int wsi_id = row.getIntColumn("workspace_item_id");
        WorkspaceItem wi = WorkspaceItem.find(c, wsi_id);
        wi.setMultipleFiles(wfi.hasMultipleFiles());
        wi.setMultipleTitles(wfi.hasMultipleTitles());
        wi.setPublishedBefore(wfi.isPublishedBefore());
        wi.update();
        log.info((Object)LogManager.getHeader(c, "return_to_workspace", "workflow_item_id=" + wfi.getID() + "workspace_item_id=" + wi.getID()));
        DatabaseManager.updateQuery(c, "DELETE FROM WorkflowItem WHERE workflow_id=" + wfi.getID(), new Object[0]);
        return wi;
    }

    public static WorkspaceItem reject(Context c, WorkflowItem wi, EPerson e, String rejection_message) throws SQLException, AuthorizeException, IOException {
        int oldState = wi.getState();
        WorkflowManager.deleteTasks(c, wi);
        Item myitem = wi.getItem();
        String now = DCDate.getCurrent().toString();
        String usersName = WorkflowManager.getEPersonName(e);
        String provDescription = "Rejected by " + usersName + ", reason: " + rejection_message + " on " + now + " (GMT) ";
        myitem.addDC("description", "provenance", "en", provDescription);
        myitem.update();
        WorkspaceItem wsi = WorkflowManager.returnToWorkspace(c, wi);
        WorkflowManager.notifyOfReject(c, wi, e, rejection_message);
        log.info((Object)LogManager.getHeader(c, "reject_workflow", "workflow_item_id=" + wi.getID() + "item_id=" + wi.getItem().getID() + "collection_id=" + wi.getCollection().getID() + "eperson_id=" + e.getID()));
        WorkflowManager.logWorkflowEvent(c, wsi.getItem(), wi, e, 0, null, wsi.getCollection(), oldState, null);
        return wsi;
    }

    private static void createTasks(Context c, WorkflowItem wi, EPerson[] epa) throws SQLException {
        for (int i = 0; i < epa.length; ++i) {
            TableRow tr = DatabaseManager.row("tasklistitem");
            tr.setColumn("eperson_id", epa[i].getID());
            tr.setColumn("workflow_id", wi.getID());
            DatabaseManager.insert(c, tr);
        }
    }

    static void deleteTasks(Context c, WorkflowItem wi) throws SQLException {
        String myrequest = "DELETE FROM TaskListItem WHERE workflow_id= ? ";
        DatabaseManager.updateQuery(c, myrequest, wi.getID());
    }

    public static void notifyOfCuration(Context c, WorkflowItem wi, EPerson[] epa, String taskName, String action, String message) throws SQLException, IOException {
        try {
            String title = WorkflowManager.getItemTitle(wi);
            String submitter = WorkflowManager.getSubmitterName(wi);
            Collection coll = wi.getCollection();
            for (int i = 0; i < epa.length; ++i) {
                Locale supportedLocale = I18nUtil.getEPersonLocale(epa[i]);
                Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "flowtask_notify"));
                email.addArgument(title);
                email.addArgument(coll.getMetadata("name"));
                email.addArgument(submitter);
                email.addArgument(taskName);
                email.addArgument(message);
                email.addArgument(action);
                email.addRecipient(epa[i].getEmail());
                email.send();
            }
        }
        catch (MessagingException e) {
            log.warn((Object)LogManager.getHeader(c, "notifyOfCuration", "cannot email users of workflow_item_id" + wi.getID()));
        }
    }

    private static void notifyGroupOfTask(Context c, WorkflowItem wi, Group mygroup, EPerson[] epa) throws SQLException, IOException {
        Integer myID = wi.getItem().getID();
        if (noEMail.containsKey(myID)) {
            noEMail.remove(myID);
        } else {
            try {
                String title = WorkflowManager.getItemTitle(wi);
                String submitter = WorkflowManager.getSubmitterName(wi);
                Collection coll = wi.getCollection();
                String message = "";
                for (int i = 0; i < epa.length; ++i) {
                    Locale supportedLocale = I18nUtil.getEPersonLocale(epa[i]);
                    Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_task"));
                    email.addArgument(title);
                    email.addArgument(coll.getMetadata("name"));
                    email.addArgument(submitter);
                    ResourceBundle messages = ResourceBundle.getBundle("Messages", supportedLocale);
                    switch (wi.getState()) {
                        case 1: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step1");
                            break;
                        }
                        case 3: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step2");
                            break;
                        }
                        case 5: {
                            message = messages.getString("org.dspace.workflow.WorkflowManager.step3");
                        }
                    }
                    email.addArgument(message);
                    email.addArgument(WorkflowManager.getMyDSpaceLink());
                    email.addRecipient(epa[i].getEmail());
                    email.send();
                }
            }
            catch (MessagingException e) {
                String gid = mygroup != null ? String.valueOf(mygroup.getID()) : "none";
                log.warn((Object)LogManager.getHeader(c, "notifyGroupofTask", "cannot email user group_id" + gid + " workflow_item_id" + wi.getID()));
            }
        }
    }

    private static String getMyDSpaceLink() {
        return ConfigurationManager.getProperty("dspace.url") + "/mydspace";
    }

    private static void notifyOfReject(Context c, WorkflowItem wi, EPerson e, String reason) {
        try {
            String title = WorkflowManager.getItemTitle(wi);
            Collection coll = wi.getCollection();
            String rejector = WorkflowManager.getEPersonName(e);
            Locale supportedLocale = I18nUtil.getEPersonLocale(e);
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, "submit_reject"));
            email.addRecipient(WorkflowManager.getSubmitterEPerson(wi).getEmail());
            email.addArgument(title);
            email.addArgument(coll.getMetadata("name"));
            email.addArgument(rejector);
            email.addArgument(reason);
            email.addArgument(WorkflowManager.getMyDSpaceLink());
            email.send();
        }
        catch (RuntimeException re) {
            log.warn((Object)LogManager.getHeader(c, "notify_of_reject", "cannot email user eperson_id" + e.getID() + " eperson_email" + e.getEmail() + " workflow_item_id" + wi.getID()));
            throw re;
        }
        catch (Exception ex) {
            log.warn((Object)LogManager.getHeader(c, "notify_of_reject", "cannot email user eperson_id" + e.getID() + " eperson_email" + e.getEmail() + " workflow_item_id" + wi.getID()));
        }
    }

    private static EPerson getSubmitterEPerson(WorkflowItem wi) throws SQLException {
        EPerson e = wi.getSubmitter();
        return e;
    }

    public static String getItemTitle(WorkflowItem wi) throws SQLException {
        Item myitem = wi.getItem();
        DCValue[] titles = myitem.getDC("title", null, "*");
        if (titles.length > 0) {
            return titles[0].value;
        }
        return I18nUtil.getMessage("org.dspace.workflow.WorkflowManager.untitled ");
    }

    public static String getSubmitterName(WorkflowItem wi) throws SQLException {
        EPerson e = wi.getSubmitter();
        return WorkflowManager.getEPersonName(e);
    }

    private static String getEPersonName(EPerson e) throws SQLException {
        if (e == null) {
            return "Unknown";
        }
        String submitter = e.getFullName();
        submitter = submitter + " (" + e.getEmail() + ")";
        return submitter;
    }

    private static void recordApproval(Context c, WorkflowItem wi, EPerson e) throws SQLException, IOException, AuthorizeException {
        Item item = wi.getItem();
        String usersName = WorkflowManager.getEPersonName(e);
        String now = DCDate.getCurrent().toString();
        String provDescription = "Approved for entry into archive by " + usersName + " on " + now + " (GMT) ";
        provDescription = provDescription + InstallItem.getBitstreamProvenanceMessage(item);
        item.addDC("description", "provenance", "en", provDescription);
        item.update();
    }

    private static void recordStart(Context c, Item myitem) throws SQLException, IOException, AuthorizeException {
        DCDate now = DCDate.getCurrent();
        String provmessage = "";
        provmessage = myitem.getSubmitter() != null ? "Submitted by " + myitem.getSubmitter().getFullName() + " (" + myitem.getSubmitter().getEmail() + ") on " + now.toString() + "\n" : "Submitted by unknown (probably automated) on" + now.toString() + "\n";
        provmessage = provmessage + InstallItem.getBitstreamProvenanceMessage(myitem);
        myitem.addDC("description", "provenance", "en", provmessage);
        myitem.update();
    }

    protected static void grantReviewerPolicies(Context context, WorkflowItem wfi, EPerson reviewer) throws SQLException, AuthorizeException {
        Bundle originalBundle;
        Item item = wfi.getItem();
        try {
            originalBundle = item.getBundles("ORIGINAL")[0];
        }
        catch (IndexOutOfBoundsException ex) {
            originalBundle = null;
        }
        for (int action : new int[]{0, 1, 3, 4, 2}) {
            AuthorizeManager.addPolicy(context, (DSpaceObject)item, action, reviewer, ResourcePolicy.TYPE_WORKFLOW);
        }
        if (originalBundle != null) {
            AuthorizeManager.addPolicy(context, (DSpaceObject)originalBundle, 0, reviewer, ResourcePolicy.TYPE_WORKFLOW);
            ConfigurationService configurationService = new DSpace().getConfigurationService();
            boolean editFiles = Boolean.parseBoolean(configurationService.getProperty("workflow.reviewer.file-edit"));
            if (editFiles) {
                AuthorizeManager.addPolicy(context, (DSpaceObject)originalBundle, 3, reviewer, ResourcePolicy.TYPE_WORKFLOW);
                AuthorizeManager.addPolicy(context, (DSpaceObject)originalBundle, 4, reviewer, ResourcePolicy.TYPE_WORKFLOW);
                AuthorizeManager.addPolicy(context, (DSpaceObject)originalBundle, 1, reviewer, ResourcePolicy.TYPE_WORKFLOW);
                AuthorizeManager.addPolicy(context, (DSpaceObject)originalBundle, 2, reviewer, ResourcePolicy.TYPE_WORKFLOW);
            }
            for (Bitstream bitstream : originalBundle.getBitstreams()) {
                AuthorizeManager.addPolicy(context, (DSpaceObject)bitstream, 0, reviewer, ResourcePolicy.TYPE_WORKFLOW);
                if (!editFiles) continue;
                AuthorizeManager.addPolicy(context, (DSpaceObject)bitstream, 1, reviewer, ResourcePolicy.TYPE_WORKFLOW);
                AuthorizeManager.addPolicy(context, (DSpaceObject)bitstream, 2, reviewer, ResourcePolicy.TYPE_WORKFLOW);
            }
        }
    }

    protected static void revokeReviewerPolicies(Context context, Item item) throws SQLException, AuthorizeException {
        Bundle originalBundle;
        try {
            originalBundle = item.getBundles("ORIGINAL")[0];
        }
        catch (IndexOutOfBoundsException ex) {
            originalBundle = null;
        }
        if (originalBundle != null) {
            for (Bitstream bitstream : originalBundle.getBitstreams()) {
                AuthorizeManager.removeAllPoliciesByDSOAndType(context, bitstream, ResourcePolicy.TYPE_WORKFLOW);
            }
            AuthorizeManager.removeAllPoliciesByDSOAndType(context, originalBundle, ResourcePolicy.TYPE_WORKFLOW);
        }
        AuthorizeManager.removeAllPoliciesByDSOAndType(context, item, ResourcePolicy.TYPE_WORKFLOW);
    }
}

