/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.eperson;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeConfiguration;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.event.Event;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class Group
extends DSpaceObject {
    public static final int ID = 0;
    public static final int NAME = 1;
    private static final Logger log = Logger.getLogger(Group.class);
    public static final int ANONYMOUS_ID = 0;
    public static final int ADMIN_ID = 1;
    private final TableRow myRow;
    private List<EPerson> epeople = new ArrayList<EPerson>();
    private List<Group> groups = new ArrayList<Group>();
    private boolean epeopleChanged = false;
    private boolean groupsChanged = false;
    private boolean isDataLoaded = false;

    Group(Context context, TableRow row) throws SQLException {
        super(context);
        this.myRow = row;
        context.cache(this, row.getIntColumn("eperson_group_id"));
        this.clearDetails();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        if (!this.isDataLoaded) {
            try {
                DSpaceObject fromCache;
                TableRow r;
                try (TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "eperson", "SELECT eperson.* FROM eperson, epersongroup2eperson WHERE epersongroup2eperson.eperson_id=eperson.eperson_id AND epersongroup2eperson.eperson_group_id= ?", this.myRow.getIntColumn("eperson_group_id"));){
                    while (tri.hasNext()) {
                        r = tri.next();
                        fromCache = (EPerson)this.ourContext.fromCache(EPerson.class, r.getIntColumn("eperson_id"));
                        if (fromCache != null) {
                            this.epeople.add((EPerson)fromCache);
                            continue;
                        }
                        this.epeople.add(new EPerson(this.ourContext, r));
                    }
                }
                tri = DatabaseManager.queryTable(this.ourContext, "epersongroup", "SELECT epersongroup.* FROM epersongroup, group2group WHERE group2group.child_id=epersongroup.eperson_group_id AND group2group.parent_id= ? ", this.myRow.getIntColumn("eperson_group_id"));
                try {
                    while (tri.hasNext()) {
                        r = tri.next();
                        fromCache = (Group)this.ourContext.fromCache(Group.class, r.getIntColumn("eperson_group_id"));
                        if (fromCache != null) {
                            this.groups.add((Group)fromCache);
                            continue;
                        }
                        this.groups.add(new Group(this.ourContext, r));
                    }
                }
                finally {
                    if (tri != null) {
                        tri.close();
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.isDataLoaded = true;
        }
    }

    public static Group create(Context context) throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("You must be an admin to create an EPerson Group");
        }
        TableRow row = DatabaseManager.create(context, "epersongroup");
        Group g = new Group(context, row);
        log.info((Object)LogManager.getHeader(context, "create_group", "group_id=" + g.getID()));
        context.addEvent(new Event(1, 6, g.getID(), null, g.getIdentifiers(context)));
        return g;
    }

    @Override
    public int getID() {
        return this.myRow.getIntColumn("eperson_group_id");
    }

    @Override
    public String getName() {
        return this.getMetadataFirstValue("dc", "title", null, "*");
    }

    public void setName(String name) {
        this.setMetadataSingleValue("dc", "title", null, null, name);
    }

    public void addMember(EPerson e) {
        this.loadData();
        if (this.isMember(e)) {
            return;
        }
        this.epeople.add(e);
        this.epeopleChanged = true;
        this.ourContext.addEvent(new Event(8, 6, this.getID(), 7, e.getID(), e.getEmail(), this.getIdentifiers(this.ourContext)));
    }

    public void addMember(Group g) {
        this.loadData();
        if (this.isMember(g) || this.getID() == g.getID()) {
            return;
        }
        this.groups.add(g);
        this.groupsChanged = true;
        this.ourContext.addEvent(new Event(8, 6, this.getID(), 6, g.getID(), g.getName(), this.getIdentifiers(this.ourContext)));
    }

    public void removeMember(EPerson e) {
        this.loadData();
        if (this.epeople.remove(e)) {
            this.epeopleChanged = true;
            this.ourContext.addEvent(new Event(16, 6, this.getID(), 7, e.getID(), e.getEmail(), this.getIdentifiers(this.ourContext)));
        }
    }

    public void removeMember(Group g) {
        this.loadData();
        if (this.groups.remove(g)) {
            this.groupsChanged = true;
            this.ourContext.addEvent(new Event(16, 6, this.getID(), 6, g.getID(), g.getName(), this.getIdentifiers(this.ourContext)));
        }
    }

    public boolean isMember(EPerson e) {
        if (this.getID() == 0) {
            return true;
        }
        this.loadData();
        return this.epeople.contains(e);
    }

    public boolean isMember(Group g) {
        this.loadData();
        return this.groups.contains(g);
    }

    public static boolean isMember(Context c, int groupid) throws SQLException {
        if (groupid == 0) {
            return true;
        }
        EPerson currentuser = c.getCurrentUser();
        return Group.epersonInGroup(c, groupid, currentuser);
    }

    public static Group[] allMemberGroups(Context c, EPerson e) throws SQLException {
        ArrayList<Group> groupList = new ArrayList<Group>();
        Set<Integer> myGroups = Group.allMemberGroupIDs(c, e);
        Iterator<Integer> i = myGroups.iterator();
        while (i.hasNext()) {
            groupList.add(Group.find(c, i.next()));
        }
        return groupList.toArray(new Group[groupList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> allMemberGroupIDs(Context c, EPerson e) throws SQLException {
        HashSet<Integer> groupIDs = new HashSet<Integer>();
        if (e != null) {
            try (TableRowIterator tri = DatabaseManager.queryTable(c, "epersongroup2eperson", "SELECT * FROM epersongroup2eperson WHERE eperson_id= ?", e.getID());){
                while (tri.hasNext()) {
                    TableRow row = tri.next();
                    int childID = row.getIntColumn("eperson_group_id");
                    groupIDs.add(childID);
                }
            }
        }
        if (c.getCurrentUser() == null || c.getCurrentUser() != null && c.getCurrentUser().getID() == e.getID()) {
            Group[] specialGroups;
            for (Group special : specialGroups = c.getSpecialGroups()) {
                groupIDs.add(special.getID());
            }
        }
        groupIDs.add(0);
        StringBuilder groupQuery = new StringBuilder();
        groupQuery.append("SELECT * FROM group2groupcache WHERE ");
        Iterator i = groupIDs.iterator();
        Object[] parameters = new Object[groupIDs.size()];
        int idx = 0;
        while (i.hasNext()) {
            int groupID = (Integer)i.next();
            parameters[idx++] = groupID;
            groupQuery.append("child_id= ? ");
            if (!i.hasNext()) continue;
            groupQuery.append(" OR ");
        }
        try (TableRowIterator tri = DatabaseManager.queryTable(c, "group2groupcache", groupQuery.toString(), parameters);){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                int parentID = row.getIntColumn("parent_id");
                groupIDs.add(parentID);
            }
        }
        return groupIDs;
    }

    public static EPerson[] allMembers(Context c, Group g) throws SQLException {
        ArrayList<EPerson> epersonList = new ArrayList<EPerson>();
        Set<Integer> myEpeople = Group.allMemberIDs(c, g);
        Iterator<Integer> i = myEpeople.iterator();
        while (i.hasNext()) {
            epersonList.add(EPerson.find(c, i.next()));
        }
        return epersonList.toArray(new EPerson[epersonList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Integer> allMemberIDs(Context c, Group g) throws SQLException {
        HashSet<Integer> epeopleIDs = new HashSet<Integer>();
        HashSet<Integer> groupIDs = new HashSet<Integer>();
        try (TableRowIterator tri = DatabaseManager.queryTable(c, "group2groupcache", "SELECT * FROM group2groupcache WHERE parent_id= ? ", g.getID());){
            while (tri.hasNext()) {
                TableRow row = tri.next();
                int childID = row.getIntColumn("child_id");
                groupIDs.add(childID);
            }
        }
        Object[] parameters = new Object[groupIDs.size() + 1];
        int idx = 0;
        Iterator i = groupIDs.iterator();
        parameters[idx++] = g.getID();
        StringBuilder epersonQuery = new StringBuilder();
        epersonQuery.append("SELECT * FROM epersongroup2eperson WHERE ");
        epersonQuery.append("eperson_group_id= ? ");
        if (i.hasNext()) {
            epersonQuery.append(" OR ");
        }
        while (i.hasNext()) {
            int groupID = (Integer)i.next();
            parameters[idx++] = groupID;
            epersonQuery.append("eperson_group_id= ? ");
            if (!i.hasNext()) continue;
            epersonQuery.append(" OR ");
        }
        tri = DatabaseManager.queryTable(c, "epersongroup2eperson", epersonQuery.toString(), parameters);
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                int epersonID = row.getIntColumn("eperson_id");
                epeopleIDs.add(epersonID);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return epeopleIDs;
    }

    private static boolean epersonInGroup(Context c, int groupID, EPerson e) throws SQLException {
        Set<Integer> groupIDs = Group.allMemberGroupIDs(c, e);
        return groupIDs.contains(groupID);
    }

    public static Group find(Context context, int id) throws SQLException {
        Group fromCache = (Group)context.fromCache(Group.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "epersongroup", id);
        if (row == null) {
            return null;
        }
        return new Group(context, row);
    }

    public static Group findByName(Context context, String name) throws SQLException {
        String query = "select * from epersongroup e LEFT JOIN metadatavalue m on (m.resource_id = e.eperson_group_id and m.resource_type_id = ? and m.metadata_field_id = ?) where ";
        query = DatabaseManager.isOracle() ? query + " dbms_lob.substr(m.text_value) = ?" : query + " m.text_value = ?";
        TableRow row = DatabaseManager.querySingle(context, query, 6, MetadataField.findByElement(context, MetadataSchema.find(context, "dc").getSchemaID(), "title", null).getFieldID(), name);
        if (row == null) {
            return null;
        }
        Group fromCache = (Group)context.fromCache(Group.class, row.getIntColumn("eperson_group_id"));
        if (fromCache != null) {
            return fromCache;
        }
        row.setTable("epersongroup");
        return new Group(context, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group[] findAll(Context context, int sortField) throws SQLException {
        String s;
        switch (sortField) {
            case 0: {
                s = "e.eperson_group_id";
                break;
            }
            case 1: {
                s = "m_text_value";
                break;
            }
            default: {
                s = "m_text_value";
            }
        }
        try (TableRowIterator rows = DatabaseManager.query(context, "select e.* from epersongroup e LEFT JOIN metadatavalue m on (m.resource_id = e.eperson_group_id and m.resource_type_id = ? and m.metadata_field_id = ?) order by ?", 6, MetadataField.findByElement(context, MetadataSchema.find(context, "dc").getSchemaID(), "title", null).getFieldID(), s);){
            List<TableRow> gRows = rows.toList();
            Group[] groups = new Group[gRows.size()];
            for (int i = 0; i < gRows.size(); ++i) {
                TableRow row = gRows.get(i);
                Group fromCache = (Group)context.fromCache(Group.class, row.getIntColumn("eperson_group_id"));
                groups[i] = fromCache != null ? fromCache : new Group(context, row);
            }
            Group[] groupArray = groups;
            return groupArray;
        }
    }

    public static Group[] search(Context context, String query) throws SQLException {
        return Group.search(context, query, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Group[] search(Context context, String query, int offset, int limit) throws SQLException {
        Integer int_param;
        String params = "%" + query.toLowerCase() + "%";
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("SELECT * FROM epersongroup LEFT JOIN metadatavalue m on (m.resource_id = epersongroup.eperson_group_id and m.resource_type_id = ? and m.metadata_field_id = ?) WHERE LOWER(m.text_value) LIKE LOWER(?) OR eperson_group_id = ? ");
        if (DatabaseManager.isOracle()) {
            queryBuf.append(" ORDER BY cast(m.text_value as varchar2(128))");
        } else {
            queryBuf.append(" ORDER BY m.text_value");
        }
        queryBuf.append(" ASC");
        if (DatabaseManager.isOracle()) {
            if (limit > 0 || offset > 0) {
                queryBuf.insert(0, "SELECT /*+ FIRST_ROWS(n) */ rec.*, ROWNUM rnum  FROM (");
                queryBuf.append(") ");
            }
            if (limit > 0) {
                queryBuf.append("rec WHERE rownum<=? ");
                if (offset > 0) {
                    limit += offset;
                }
            }
            if (offset > 0) {
                queryBuf.insert(0, "SELECT * FROM (");
                queryBuf.append(") WHERE rnum>?");
            }
        } else {
            if (limit > 0) {
                queryBuf.append(" LIMIT ? ");
            }
            if (offset > 0) {
                queryBuf.append(" OFFSET ? ");
            }
        }
        String dbquery = queryBuf.toString();
        try {
            int_param = Integer.valueOf(query);
        }
        catch (NumberFormatException e) {
            int_param = -1;
        }
        int metadataFieldId = MetadataField.findByElement(context, MetadataSchema.find(context, "dc").getSchemaID(), "title", null).getFieldID();
        Object[] paramArr = new Object[]{6, metadataFieldId, params, int_param};
        if (limit > 0 && offset > 0) {
            paramArr = new Object[]{6, metadataFieldId, params, int_param, limit, offset};
        } else if (limit > 0) {
            paramArr = new Object[]{6, metadataFieldId, params, int_param, limit};
        } else if (offset > 0) {
            paramArr = new Object[]{6, metadataFieldId, params, int_param, offset};
        }
        try (TableRowIterator rows = DatabaseManager.query(context, dbquery, paramArr);){
            List<TableRow> groupRows = rows.toList();
            Group[] groups = new Group[groupRows.size()];
            for (int i = 0; i < groupRows.size(); ++i) {
                TableRow row = groupRows.get(i);
                Group fromCache = (Group)context.fromCache(Group.class, row.getIntColumn("eperson_group_id"));
                groups[i] = fromCache != null ? fromCache : new Group(context, row);
            }
            Group[] groupArray = groups;
            return groupArray;
        }
    }

    public static int searchResultCount(Context context, String query) throws SQLException {
        Integer int_param;
        String params = "%" + query.toLowerCase() + "%";
        String dbquery = "SELECT count(*) as gcount FROM epersongroup LEFT JOIN metadatavalue m on (m.resource_id = epersongroup.eperson_group_id and m.resource_type_id = ? and m.metadata_field_id = ?) WHERE LOWER(m.text_value) LIKE LOWER(?) OR eperson_group_id = ? ";
        try {
            int_param = Integer.valueOf(query);
        }
        catch (NumberFormatException e) {
            int_param = -1;
        }
        TableRow row = DatabaseManager.querySingle(context, dbquery, 6, MetadataField.findByElement(context, MetadataSchema.find(context, "dc").getSchemaID(), "title", null).getFieldID(), params, int_param);
        Long count = DatabaseManager.isOracle() ? Long.valueOf(row.getIntColumn("gcount")) : Long.valueOf(row.getLongColumn("gcount"));
        return count.intValue();
    }

    public void delete() throws SQLException {
        this.ourContext.addEvent(new Event(32, 6, this.getID(), this.getName(), this.getIdentifiers(this.ourContext)));
        this.ourContext.removeCached(this, this.getID());
        AuthorizeManager.removeGroupPolicies(this.ourContext, this.getID());
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM EPersonGroup2EPerson WHERE eperson_group_id= ? ", this.getID());
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM group2groupcache WHERE parent_id= ? OR child_id= ? ", this.getID(), this.getID());
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM group2group WHERE parent_id= ? OR child_id= ? ", this.getID(), this.getID());
        this.removeMetadataFromDatabase();
        this.deleteEpersonGroup2WorkspaceItem();
        DatabaseManager.delete(this.ourContext, this.myRow);
        this.epeople.clear();
        log.info((Object)LogManager.getHeader(this.ourContext, "delete_group", "group_id=" + this.getID()));
    }

    private void deleteEpersonGroup2WorkspaceItem() throws SQLException {
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM EPersonGroup2WorkspaceItem WHERE eperson_group_id= ? ", this.getID());
    }

    public EPerson[] getMembers() {
        this.loadData();
        EPerson[] myArray = new EPerson[this.epeople.size()];
        myArray = this.epeople.toArray(myArray);
        return myArray;
    }

    public Group[] getMemberGroups() {
        this.loadData();
        Group[] myArray = new Group[this.groups.size()];
        myArray = this.groups.toArray(myArray);
        return myArray;
    }

    public boolean isEmpty() {
        boolean hasMembers;
        this.loadData();
        boolean bl = hasMembers = this.epeople.size() != 0;
        if (hasMembers) {
            return false;
        }
        for (Group subGroup : this.groups) {
            hasMembers = !subGroup.isEmpty();
            if (!hasMembers) continue;
            return false;
        }
        return !hasMembers;
    }

    @Override
    public void update() throws SQLException, AuthorizeException {
        TableRow mappingRow;
        DatabaseManager.update(this.ourContext, this.myRow);
        if (this.modifiedMetadata) {
            this.updateMetadata();
            this.clearDetails();
        }
        if (this.epeopleChanged) {
            DatabaseManager.updateQuery(this.ourContext, "delete from epersongroup2eperson where eperson_group_id= ? ", this.getID());
            for (EPerson e : this.epeople) {
                mappingRow = DatabaseManager.row("epersongroup2eperson");
                mappingRow.setColumn("eperson_id", e.getID());
                mappingRow.setColumn("eperson_group_id", this.getID());
                DatabaseManager.insert(this.ourContext, mappingRow);
            }
            this.epeopleChanged = false;
        }
        if (this.groupsChanged) {
            DatabaseManager.updateQuery(this.ourContext, "delete from group2group where parent_id= ? ", this.getID());
            for (Group g : this.groups) {
                mappingRow = DatabaseManager.row("group2group");
                mappingRow.setColumn("parent_id", this.getID());
                mappingRow.setColumn("child_id", g.getID());
                DatabaseManager.insert(this.ourContext, mappingRow);
            }
            this.rethinkGroupCache();
            this.groupsChanged = false;
        }
        log.info((Object)LogManager.getHeader(this.ourContext, "update_group", "group_id=" + this.getID()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        return this.getID() == other.getID();
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.myRow != null ? this.myRow.hashCode() : 0);
        return hash;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public String getHandle() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rethinkGroupCache() throws SQLException {
        HashMap<Integer, Set<Integer>> parents = new HashMap<Integer, Set<Integer>>();
        try (TableRowIterator tri = DatabaseManager.queryTable(this.ourContext, "group2group", "SELECT * FROM group2group", new Object[0]);){
            while (tri.hasNext()) {
                Set<Integer> children;
                TableRow row = tri.next();
                Integer parentID = row.getIntColumn("parent_id");
                Integer childID = row.getIntColumn("child_id");
                if (!parents.containsKey(parentID)) {
                    children = new HashSet<Integer>();
                    children.add(childID);
                    parents.put(parentID, children);
                    continue;
                }
                children = (Set)parents.get(parentID);
                children.add(childID);
            }
        }
        for (Map.Entry parent : parents.entrySet()) {
            Set<Integer> myChildren = this.getChildren(parents, (Integer)parent.getKey());
            ((Set)parent.getValue()).addAll(myChildren);
        }
        DatabaseManager.updateQuery(this.ourContext, "DELETE FROM group2groupcache WHERE id >= 0", new Object[0]);
        for (Map.Entry parent : parents.entrySet()) {
            int parentID = (Integer)parent.getKey();
            for (Integer child : (Set)parent.getValue()) {
                TableRow row = DatabaseManager.row("group2groupcache");
                row.setColumn("parent_id", parentID);
                row.setColumn("child_id", child);
                DatabaseManager.insert(this.ourContext, row);
            }
        }
    }

    private Set<Integer> getChildren(Map<Integer, Set<Integer>> parents, Integer parent) {
        HashSet<Integer> myChildren = new HashSet<Integer>();
        if (!parents.containsKey(parent)) {
            return myChildren;
        }
        Set<Integer> children = parents.get(parent);
        for (Integer childID : children) {
            myChildren.add(childID);
            myChildren.addAll(this.getChildren(parents, childID));
        }
        return myChildren;
    }

    @Override
    public DSpaceObject getParentObject() throws SQLException {
        if (AuthorizeConfiguration.canCollectionAdminManageAdminGroup() || AuthorizeConfiguration.canCollectionAdminManageSubmitters() || AuthorizeConfiguration.canCollectionAdminManageWorkflows() || AuthorizeConfiguration.canCommunityAdminManageAdminGroup() || AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup() || AuthorizeConfiguration.canCommunityAdminManageCollectionSubmitters() || AuthorizeConfiguration.canCommunityAdminManageCollectionWorkflows()) {
            TableRow qResult = DatabaseManager.querySingle(this.ourContext, "SELECT collection_id, workflow_step_1, workflow_step_2,  workflow_step_3, submitter, admin FROM collection  WHERE workflow_step_1 = ? OR  workflow_step_2 = ? OR  workflow_step_3 = ? OR  submitter =  ? OR  admin = ?", this.getID(), this.getID(), this.getID(), this.getID(), this.getID());
            if (qResult != null) {
                Collection collection = Collection.find(this.ourContext, qResult.getIntColumn("collection_id"));
                if (qResult.getIntColumn("workflow_step_1") == this.getID() || qResult.getIntColumn("workflow_step_2") == this.getID() || qResult.getIntColumn("workflow_step_3") == this.getID()) {
                    if (AuthorizeConfiguration.canCollectionAdminManageWorkflows()) {
                        return collection;
                    }
                    if (AuthorizeConfiguration.canCommunityAdminManageCollectionWorkflows()) {
                        return collection.getParentObject();
                    }
                }
                if (qResult.getIntColumn("submitter") == this.getID()) {
                    if (AuthorizeConfiguration.canCollectionAdminManageSubmitters()) {
                        return collection;
                    }
                    if (AuthorizeConfiguration.canCommunityAdminManageCollectionSubmitters()) {
                        return collection.getParentObject();
                    }
                }
                if (qResult.getIntColumn("admin") == this.getID()) {
                    if (AuthorizeConfiguration.canCollectionAdminManageAdminGroup()) {
                        return collection;
                    }
                    if (AuthorizeConfiguration.canCommunityAdminManageCollectionAdminGroup()) {
                        return collection.getParentObject();
                    }
                }
            } else if (AuthorizeConfiguration.canCommunityAdminManageAdminGroup() && (qResult = DatabaseManager.querySingle(this.ourContext, "SELECT community_id FROM community WHERE admin = ?", this.getID())) != null) {
                Community community = Community.find(this.ourContext, qResult.getIntColumn("community_id"));
                return community;
            }
        }
        return null;
    }

    @Override
    public void updateLastModified() {
    }

    public static void main(String[] args) throws SQLException, AuthorizeException {
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        Group.initDefaultGroupNames(context);
        context.getEvents().clear();
        context.complete();
    }

    public static void initDefaultGroupNames(Context context) throws SQLException, AuthorizeException {
        Group anonymousGroup = Group.find(context, 0);
        if (anonymousGroup == null) {
            anonymousGroup = Group.create(context);
        }
        anonymousGroup.setName("Anonymous");
        anonymousGroup.update();
        Group adminGroup = Group.find(context, 1);
        if (adminGroup == null) {
            adminGroup = Group.create(context);
        }
        adminGroup.setName("Administrator");
        adminGroup.update();
    }
}

