/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.storage.rdbms;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.dspace.storage.rdbms.DatabaseManager;

public class MigrationUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer dropDBConstraint(Connection connection, String tableName, String columnName, String constraintSuffix) throws SQLException {
        Integer checksum = -1;
        DatabaseMetaData meta = connection.getMetaData();
        String dbtype = DatabaseManager.findDbKeyword(meta);
        String constraintName = null;
        String constraintNameSQL = null;
        switch (dbtype) {
            case "postgres": {
                constraintName = StringUtils.lowerCase((String)tableName) + "_" + StringUtils.lowerCase((String)columnName) + "_" + StringUtils.lowerCase((String)constraintSuffix);
                break;
            }
            case "oracle": {
                constraintNameSQL = "SELECT CONSTRAINT_NAME FROM USER_CONS_COLUMNS WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
                break;
            }
            case "h2": {
                constraintNameSQL = "SELECT DISTINCT CONSTRAINT_NAME FROM information_schema.constraints WHERE table_name = ? AND column_list = ?";
                break;
            }
            default: {
                throw new SQLException("DBMS " + dbtype + " is unsupported in this migration.");
            }
        }
        if (constraintNameSQL != null) {
            PreparedStatement statement = connection.prepareStatement(constraintNameSQL);
            statement.setString(1, StringUtils.upperCase((String)tableName));
            statement.setString(2, StringUtils.upperCase((String)columnName));
            try {
                ResultSet results = statement.executeQuery();
                if (results.next()) {
                    constraintName = results.getString("CONSTRAINT_NAME");
                }
                results.close();
            }
            finally {
                statement.close();
            }
        }
        if (constraintName != null && !constraintName.isEmpty()) {
            String dropConstraintSQL = "ALTER TABLE " + tableName + " DROP CONSTRAINT " + constraintName;
            try (PreparedStatement statement = connection.prepareStatement(dropConstraintSQL);){
                statement.execute();
            }
            checksum = dropConstraintSQL.length();
        }
        return checksum;
    }
}

