/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.dspace.authority.AuthorityValue;
import org.dspace.content.authority.SolrAuthority;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class AuthorityValueFinder {
    private static Logger log = Logger.getLogger(AuthorityValueFinder.class);

    public AuthorityValue findByUID(Context context, String authorityID) {
        String queryString = "id:" + authorityID;
        List<AuthorityValue> findings = this.find(context, queryString);
        return findings.size() > 0 ? findings.get(0) : null;
    }

    public List<AuthorityValue> findByValue(Context context, String schema, String element, String qualifier, String value) {
        String field = this.fieldParameter(schema, element, qualifier);
        String queryString = "value:" + value + " AND field:" + field;
        return this.find(context, queryString);
    }

    public AuthorityValue findByOrcidID(Context context, String orcid_id) {
        String queryString = "orcid_id:" + orcid_id;
        List<AuthorityValue> findings = this.find(context, queryString);
        return findings.size() > 0 ? findings.get(0) : null;
    }

    public List<AuthorityValue> findByName(Context context, String schema, String element, String qualifier, String name) {
        String field = this.fieldParameter(schema, element, qualifier);
        String queryString = "first_name:" + name + " OR last_name:" + name + " OR name_variant:" + name + " AND field:" + field;
        return this.find(context, queryString);
    }

    public List<AuthorityValue> findByAuthorityMetadata(Context context, String schema, String element, String qualifier, String value) {
        String field = this.fieldParameter(schema, element, qualifier);
        String queryString = "all_Labels:" + value + " AND field:" + field;
        return this.find(context, queryString);
    }

    public List<AuthorityValue> findOrcidHolders(Context context) {
        String queryString = "orcid_id:*";
        return this.find(context, queryString);
    }

    public List<AuthorityValue> findAll(Context context) {
        String queryString = "*:*";
        return this.find(context, queryString);
    }

    private List<AuthorityValue> find(Context context, String queryString) {
        ArrayList<AuthorityValue> findings = new ArrayList<AuthorityValue>();
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(this.filtered(queryString));
            log.debug((Object)("AuthorityValueFinder makes the query: " + queryString));
            QueryResponse queryResponse = SolrAuthority.getSearchService().search(solrQuery);
            if (queryResponse != null && queryResponse.getResults() != null && 0L < queryResponse.getResults().getNumFound()) {
                for (SolrDocument document : queryResponse.getResults()) {
                    AuthorityValue authorityValue = AuthorityValue.fromSolr(document);
                    findings.add(authorityValue);
                    log.debug((Object)("AuthorityValueFinder found: " + authorityValue.getValue()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)LogManager.getHeader(context, "Error while retrieving AuthorityValue from solr", "query: " + queryString), (Throwable)e);
        }
        return findings;
    }

    private String filtered(String queryString) throws InstantiationException, IllegalAccessException {
        String instanceFilter = "-deleted:true";
        if (StringUtils.isNotBlank((String)instanceFilter)) {
            queryString = queryString + " AND " + instanceFilter;
        }
        return queryString;
    }

    private String fieldParameter(String schema, String element, String qualifier) {
        return schema + "_" + element + (qualifier != null ? "_" + qualifier : "");
    }
}

