/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.indexer;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.authority.indexer.AuthorityIndexClient;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;

public class AuthorityConsumer
implements Consumer {
    private static final Logger log = Logger.getLogger(AuthorityConsumer.class);
    private Set<Integer> itemsToUpdateAuthority = null;
    private Set<Integer> itemsToReindex = null;

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        DSpaceObject dso;
        if (this.itemsToUpdateAuthority == null) {
            this.itemsToUpdateAuthority = new HashSet<Integer>();
            this.itemsToReindex = new HashSet<Integer>();
        }
        if ((dso = event.getSubject(ctx)) instanceof Item) {
            Item item = (Item)dso;
            if (item.isArchived() && !this.itemsToReindex.contains(item.getID())) {
                this.itemsToReindex.add(item.getID());
            }
            if ("ARCHIVED: true".equals(event.getDetail())) {
                this.itemsToUpdateAuthority.add(item.getID());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Context ctx) throws Exception {
        if (this.itemsToUpdateAuthority == null) {
            return;
        }
        try {
            Item item;
            ctx.turnOffAuthorisationSystem();
            for (Integer id : this.itemsToUpdateAuthority) {
                item = Item.find(ctx, id);
                AuthorityIndexClient.indexItem(ctx, item);
            }
            for (Integer id : this.itemsToReindex) {
                item = Item.find(ctx, id);
                AuthorityIndexClient.indexItem(ctx, item);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while consuming the authority consumer", (Throwable)e);
        }
        finally {
            this.itemsToUpdateAuthority = null;
            this.itemsToReindex = null;
            ctx.restoreAuthSystemState();
        }
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

