/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import edu.harvard.hul.ois.mets.Agent;
import edu.harvard.hul.ois.mets.Div;
import edu.harvard.hul.ois.mets.Loctype;
import edu.harvard.hul.ois.mets.Mets;
import edu.harvard.hul.ois.mets.MetsHdr;
import edu.harvard.hul.ois.mets.Mptr;
import edu.harvard.hul.ois.mets.Name;
import edu.harvard.hul.ois.mets.Role;
import edu.harvard.hul.ois.mets.StructMap;
import edu.harvard.hul.ois.mets.Type;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.PCData;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Site;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.AbstractMETSDisseminator;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.license.CreativeCommons;

public class DSpaceAIPDisseminator
extends AbstractMETSDisseminator {
    private static final Logger log = Logger.getLogger(DSpaceAIPDisseminator.class);
    public static final String PROFILE_1_0 = "http://www.dspace.org/schema/aip/mets_aip_1_0.xsd";
    public static final String PARENT_DIV_TYPE = "AIP Parent Link";
    private static final String DSPACE_DEPOSIT_LICENSE_MDTYPE = "DSpaceDepositLicense:DSPACE_DEPLICENSE";
    private static final String CREATIVE_COMMONS_RDF_MDTYPE = "CreativeCommonsRDF:DSPACE_CCRDF";
    private static final String CREATIVE_COMMONS_TEXT_MDTYPE = "CreativeCommonsText:DSPACE_CCTXT";
    private PackageParameters disseminateParams = null;
    private List<String> filterBundles = new ArrayList<String>();
    private boolean excludeBundles = true;

    @Override
    public void disseminate(Context context, DSpaceObject dso, PackageParameters params, File pkgFile) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        this.disseminateParams = params;
        boolean disseminate = true;
        if (this.disseminateParams.containsKey("updatedAfter") && dso.getType() == 2) {
            Date afterDate = Utils.parseISO8601Date(this.disseminateParams.getProperty("updatedAfter"));
            if (afterDate == null) {
                throw new IOException("Invalid date passed in via 'updatedAfter' option. Date must be in ISO-8601 format, and include both a day and time (e.g. 2010-01-01T00:00:00).");
            }
            Item i = (Item)dso;
            disseminate = i.getLastModified().after(afterDate);
        }
        if (disseminate) {
            super.disseminate(context, dso, params, pkgFile);
        }
    }

    @Override
    public String getProfile() {
        return PROFILE_1_0;
    }

    @Override
    public String bundleToFileGrp(String bname) {
        return bname;
    }

    @Override
    public MetsHdr makeMetsHdr(Context context, DSpaceObject dso, PackageParameters params) {
        MetsHdr metsHdr = new MetsHdr();
        if (dso.getType() == 2) {
            metsHdr.setLASTMODDATE(((Item)dso).getLastModified());
        }
        Agent agent = new Agent();
        agent.setROLE(Role.CUSTODIAN);
        agent.setTYPE(Type.OTHER);
        agent.setOTHERTYPE("DSpace Archive");
        Name name = new Name();
        name.getContent().add(new PCData(Site.getSiteHandle()));
        agent.getContent().add(name);
        metsHdr.getContent().add(agent);
        Agent agentCreator = new Agent();
        agentCreator.setROLE(Role.CREATOR);
        agentCreator.setTYPE(Type.OTHER);
        agentCreator.setOTHERTYPE("DSpace Software");
        Name creatorName = new Name();
        creatorName.getContent().add(new PCData("DSpace " + Util.getSourceVersion()));
        agentCreator.getContent().add(creatorName);
        metsHdr.getContent().add(agentCreator);
        return metsHdr;
    }

    @Override
    public String[] getDmdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        String dmdTypes = ConfigurationManager.getProperty("aip.disseminate.dmd");
        if (dmdTypes == null) {
            String[] result = new String[]{"MODS", "DIM"};
            return result;
        }
        return dmdTypes.split("\\s*,\\s*");
    }

    @Override
    public String[] getTechMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        String techTypes = ConfigurationManager.getProperty("aip.disseminate.techMD");
        if (techTypes == null) {
            if (dso.getType() == 0) {
                String[] result = new String[]{"PREMIS"};
                return result;
            }
            return new String[0];
        }
        return techTypes.split("\\s*,\\s*");
    }

    @Override
    public String[] getSourceMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        String sourceTypes = ConfigurationManager.getProperty("aip.disseminate.sourceMD");
        if (sourceTypes == null) {
            String[] result = new String[]{"AIP-TECHMD"};
            return result;
        }
        return sourceTypes.split("\\s*,\\s*");
    }

    @Override
    public String[] getDigiprovMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        String dpTypes = ConfigurationManager.getProperty("aip.disseminate.digiprovMD");
        if (dpTypes == null) {
            return new String[0];
        }
        return dpTypes.split("\\s*,\\s*");
    }

    @Override
    public String[] getRightsMdTypes(Context context, DSpaceObject dso, PackageParameters params) throws SQLException, IOException, AuthorizeException {
        ArrayList<String> result = new ArrayList<String>();
        String rTypes = ConfigurationManager.getProperty("aip.disseminate.rightsMD");
        if (rTypes == null) {
            if (dso.getType() == 2) {
                if (PackageUtils.findDepositLicense(context, (Item)dso) != null) {
                    result.add(DSPACE_DEPOSIT_LICENSE_MDTYPE);
                }
                if (CreativeCommons.getLicenseRdfBitstream((Item)dso) != null) {
                    result.add(CREATIVE_COMMONS_RDF_MDTYPE);
                } else if (CreativeCommons.getLicenseTextBitstream((Item)dso) != null) {
                    result.add(CREATIVE_COMMONS_TEXT_MDTYPE);
                }
            }
        } else {
            return rTypes.split("\\s*,\\s*");
        }
        result.add("METSRights");
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void addStructMap(Context context, DSpaceObject dso, PackageParameters params, Mets mets) throws SQLException, IOException, AuthorizeException, MetsException {
        String parentHandle = null;
        switch (dso.getType()) {
            case 2: {
                parentHandle = ((Item)dso).getOwningCollection().getHandle();
                break;
            }
            case 3: {
                parentHandle = ((Collection)dso).getCommunities()[0].getHandle();
                break;
            }
            case 4: {
                Community parent = ((Community)dso).getParentCommunity();
                parentHandle = parent == null ? Site.getSiteHandle() : parent.getHandle();
            }
        }
        if (parentHandle != null) {
            StructMap structMap = new StructMap();
            structMap.setID(this.gensym("struct"));
            structMap.setTYPE("LOGICAL");
            structMap.setLABEL("Parent");
            Div div0 = new Div();
            div0.setID(this.gensym("div"));
            div0.setTYPE(PARENT_DIV_TYPE);
            div0.setLABEL("Parent of this DSpace Object");
            Mptr mptr = new Mptr();
            mptr.setID(this.gensym("mptr"));
            mptr.setLOCTYPE(Loctype.HANDLE);
            mptr.setXlinkHref(parentHandle);
            div0.getContent().add(mptr);
            structMap.getContent().add(div0);
            mets.getContent().add(structMap);
        }
    }

    @Override
    public boolean includeBundle(Bundle bundle) {
        List<String> bundleList = this.getBundleList();
        if (bundleList.size() == 1 && bundleList.get(0).equalsIgnoreCase("all") && !this.excludeBundles) {
            return true;
        }
        boolean inList = this.filterBundles.contains(bundle.getName());
        return this.excludeBundles ? !inList : inList;
    }

    protected List<String> getBundleList() {
        if (this.filterBundles != null && !this.filterBundles.isEmpty()) {
            return this.filterBundles;
        }
        String bundleList = this.disseminateParams.getProperty("filterBundles");
        if (bundleList == null || bundleList.isEmpty()) {
            bundleList = this.disseminateParams.getProperty("includeBundles", "+all");
            String string = bundleList = bundleList.startsWith("+") ? bundleList : "+".concat(bundleList);
        }
        if (bundleList.startsWith("+")) {
            this.excludeBundles = false;
            bundleList = bundleList.substring(1);
        }
        this.filterBundles = Arrays.asList(bundleList.split(","));
        return this.filterBundles;
    }

    @Override
    public String getParameterHelp() {
        String parentHelp = super.getParameterHelp();
        return parentHelp + "\n\n" + "* filterBundles=[bundleList]      " + "List of bundles specifying which Bundles should be included in an AIP. If this list starts with a '+' symbol," + " then it represents a list of bundles to *include* in the AIP.  By default, the list represents a list of bundles" + " to *exclude* from the AIP.";
    }
}

