/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.dspace.core.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseManager {
    private static final Logger log = LoggerFactory.getLogger(LicenseManager.class);
    private static String license;

    public static void writeLicenseFile(String licenseFile, String newLicense) {
        try {
            FileOutputStream fos = new FileOutputStream(licenseFile);
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            PrintWriter out = new PrintWriter(osr);
            out.print(newLicense);
            out.close();
        }
        catch (IOException e) {
            log.warn("license_write: " + e.getLocalizedMessage());
        }
        license = newLicense;
    }

    public static String getLicenseText(String licenseFile) {
        FileInputStream is = null;
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            String lineIn;
            is = new FileInputStream(licenseFile);
            ir = new InputStreamReader((InputStream)is, "UTF-8");
            br = new BufferedReader(ir);
            license = "";
            while ((lineIn = br.readLine()) != null) {
                license = license + lineIn + '\n';
            }
        }
        catch (IOException e) {
            log.error("Can't load configuration", (Throwable)e);
            throw new IllegalStateException("Failed to read default license.", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException ioe) {}
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ioe) {}
            }
        }
        return license;
    }

    public static String getDefaultSubmissionLicense() {
        if (null == license) {
            LicenseManager.init();
        }
        return license;
    }

    private static void init() {
        File licenseFile = new File(ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "default.license");
        FileInputStream fir = null;
        InputStreamReader ir = null;
        BufferedReader br = null;
        try {
            String lineIn;
            fir = new FileInputStream(licenseFile);
            ir = new InputStreamReader((InputStream)fir, "UTF-8");
            br = new BufferedReader(ir);
            license = "";
            while ((lineIn = br.readLine()) != null) {
                license = license + lineIn + '\n';
            }
            br.close();
        }
        catch (IOException e) {
            log.error("Can't load license: " + licenseFile.toString(), (Throwable)e);
            throw new IllegalStateException("Cannot load license: " + licenseFile.toString(), e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException ioe) {}
            }
            if (fir != null) {
                try {
                    fir.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

