/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.authority.AuthorityValue;

public class PersonAuthorityValue
extends AuthorityValue {
    private String firstName;
    private String lastName;
    private List<String> nameVariants = new ArrayList<String>();
    private String institution;
    private List<String> emails = new ArrayList<String>();

    public PersonAuthorityValue() {
    }

    public PersonAuthorityValue(SolrDocument document) {
        super(document);
    }

    public String getName() {
        String name = "";
        if (StringUtils.isNotBlank((String)this.lastName)) {
            name = this.lastName;
            if (StringUtils.isNotBlank((String)this.firstName)) {
                name = name + ", ";
            }
        }
        if (StringUtils.isNotBlank((String)this.firstName)) {
            name = name + this.firstName;
        }
        return name;
    }

    public void setName(String name) {
        String[] split;
        if (StringUtils.isNotBlank((String)name) && (split = name.split(",")).length > 0) {
            this.setLastName(split[0].trim());
            if (split.length > 1) {
                this.setFirstName(split[1].trim());
            }
        }
        if (!StringUtils.equals((String)this.getValue(), (String)name)) {
            this.setValue(name);
        }
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        this.setName(value);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public List<String> getNameVariants() {
        return this.nameVariants;
    }

    public void addNameVariant(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            this.nameVariants.add(name);
        }
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public List<String> getEmails() {
        return this.emails;
    }

    public void addEmail(String email) {
        if (StringUtils.isNotBlank((String)email)) {
            this.emails.add(email);
        }
    }

    @Override
    public SolrInputDocument getSolrInputDocument() {
        SolrInputDocument doc = super.getSolrInputDocument();
        if (StringUtils.isNotBlank((String)this.getFirstName())) {
            doc.addField("first_name", (Object)this.getFirstName());
        }
        if (StringUtils.isNotBlank((String)this.getLastName())) {
            doc.addField("last_name", (Object)this.getLastName());
        }
        for (String nameVariant : this.getNameVariants()) {
            doc.addField("name_variant", (Object)nameVariant);
        }
        for (String email : this.emails) {
            doc.addField("email", (Object)email);
        }
        doc.addField("institution", (Object)this.getInstitution());
        return doc;
    }

    @Override
    public void setValues(SolrDocument document) {
        Collection emails;
        super.setValues(document);
        this.firstName = ObjectUtils.toString((Object)document.getFieldValue("first_name"));
        this.lastName = ObjectUtils.toString((Object)document.getFieldValue("last_name"));
        this.nameVariants = new ArrayList<String>();
        Collection document_name_variant = document.getFieldValues("name_variant");
        if (document_name_variant != null) {
            for (Object name_variants : document_name_variant) {
                this.addNameVariant(String.valueOf(name_variants));
            }
        }
        if (document.getFieldValue("institution") != null) {
            this.institution = String.valueOf(document.getFieldValue("institution"));
        }
        if ((emails = document.getFieldValues("email")) != null) {
            for (Object email : emails) {
                this.addEmail(String.valueOf(email));
            }
        }
    }

    @Override
    public Map<String, String> choiceSelectMap() {
        Map<String, String> map = super.choiceSelectMap();
        if (StringUtils.isNotBlank((String)this.getFirstName())) {
            map.put("first-name", this.getFirstName());
        } else {
            map.put("first-name", "/");
        }
        if (StringUtils.isNotBlank((String)this.getLastName())) {
            map.put("last-name", this.getLastName());
        } else {
            map.put("last-name", "/");
        }
        if (!this.getEmails().isEmpty()) {
            boolean added = false;
            for (String email : this.getEmails()) {
                if (added || !StringUtils.isNotBlank((String)email)) continue;
                map.put("email", email);
                added = true;
            }
        }
        if (StringUtils.isNotBlank((String)this.getInstitution())) {
            map.put("institution", this.getInstitution());
        }
        return map;
    }

    @Override
    public String getAuthorityType() {
        return "person";
    }

    @Override
    public String generateString() {
        return "will be generated::" + this.getAuthorityType() + "::" + this.getName();
    }

    @Override
    public AuthorityValue newInstance(String info) {
        PersonAuthorityValue authorityValue = new PersonAuthorityValue();
        authorityValue.setValue(info);
        return authorityValue;
    }

    @Override
    public String toString() {
        return "PersonAuthorityValue{firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", nameVariants=" + this.nameVariants + ", institution='" + this.institution + '\'' + ", emails=" + this.emails + "} " + super.toString();
    }

    @Override
    public boolean hasTheSameInformationAs(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.hasTheSameInformationAs(o)) {
            return false;
        }
        PersonAuthorityValue that = (PersonAuthorityValue)o;
        if (this.emails != null ? !this.emails.equals(that.emails) : that.emails != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(that.firstName) : that.firstName != null) {
            return false;
        }
        if (this.institution != null ? !this.institution.equals(that.institution) : that.institution != null) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(that.lastName) : that.lastName != null) {
            return false;
        }
        return !(this.nameVariants != null ? !this.nameVariants.equals(that.nameVariants) : that.nameVariants != null);
    }
}

