/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import org.dspace.browse.BrowseCreateDAO;
import org.dspace.browse.BrowseDAO;
import org.dspace.browse.BrowseDAOUtils;
import org.dspace.browse.BrowseDAOUtilsOracle;
import org.dspace.browse.BrowseDAOUtilsPostgres;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseItemDAO;
import org.dspace.browse.BrowseItemDAOOracle;
import org.dspace.browse.BrowseItemDAOPostgres;
import org.dspace.browse.SolrBrowseCreateDAO;
import org.dspace.browse.SolrBrowseDAO;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;

public class BrowseDAOFactory {
    public static BrowseDAO getInstance(Context context) throws BrowseException {
        String className = ConfigurationManager.getProperty("browseDAO.class");
        if (className == null) {
            return new SolrBrowseDAO(context);
        }
        try {
            return (BrowseDAO)Class.forName(ConfigurationManager.getProperty("browseDAO.class")).getConstructor(Context.class).newInstance(context);
        }
        catch (Exception e) {
            throw new BrowseException("The configuration for browseDAO is invalid: " + className, e);
        }
    }

    public static BrowseCreateDAO getCreateInstance(Context context) throws BrowseException {
        String className = ConfigurationManager.getProperty("browseCreateDAO.class");
        if (className == null) {
            return new SolrBrowseCreateDAO(context);
        }
        try {
            return (BrowseCreateDAO)Class.forName(ConfigurationManager.getProperty("browseCreateDAO.class")).getConstructor(Context.class).newInstance(context);
        }
        catch (Exception e) {
            throw new BrowseException("The configuration for browseCreateDAO is invalid: " + className, e);
        }
    }

    public static BrowseItemDAO getItemInstance(Context context) throws BrowseException {
        if (!DatabaseManager.isOracle()) {
            return new BrowseItemDAOPostgres(context);
        }
        return new BrowseItemDAOOracle(context);
    }

    public static BrowseDAOUtils getUtils(Context context) throws BrowseException {
        if (!DatabaseManager.isOracle()) {
            return new BrowseDAOUtilsPostgres();
        }
        return new BrowseDAOUtilsOracle();
    }
}

