/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.core.Context;
import org.jdom.Element;
import org.jdom.Namespace;

public class DIMIngestionCrosswalk
implements IngestionCrosswalk {
    private static final Namespace DIM_NS = Namespace.getNamespace((String)"http://www.dspace.org/xmlns/dspace/dim");

    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> metadata) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Element first = metadata.get(0);
        if (first.getName().equals("dim") && metadata.size() == 1) {
            this.ingest(context, dso, first);
        } else if (first.getName().equals("field") && first.getParentElement() != null) {
            this.ingest(context, dso, first.getParentElement());
        } else {
            Element wrapper = new Element("wrap", metadata.get(0).getNamespace());
            wrapper.addContent(metadata);
            this.ingest(context, dso, wrapper);
        }
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, Element root) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("DIMIngestionCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        if (root == null) {
            System.err.println("The element received by ingest was null");
            return;
        }
        List metadata = root.getChildren("field", DIM_NS);
        for (Element field : metadata) {
            item.addMetadata(field.getAttributeValue("mdschema"), field.getAttributeValue("element"), field.getAttributeValue("qualifier"), field.getAttributeValue("lang"), field.getText());
        }
    }
}

