/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.curate.Distributive;
import org.dspace.curate.Mutative;
import org.dspace.disseminate.CitationDocument;

@Distributive
@Mutative
public class CitationPage
extends AbstractCurationTask {
    private static Logger log = Logger.getLogger(CitationPage.class);
    private int status = -2;
    private String result = null;
    private StringBuilder resBuilder;
    private static final String DISPLAY_BUNDLE_NAME = "DISPLAY";
    private static final String PRESERVATION_BUNDLE_NAME = "PRESERVATION";

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        this.resBuilder = new StringBuilder();
        this.distribute(dso);
        this.result = this.resBuilder.toString();
        this.setResult(this.result);
        this.report(this.result);
        return this.status;
    }

    @Override
    protected void performItem(Item item) throws SQLException {
        Bundle[] dBundles = item.getBundles(DISPLAY_BUNDLE_NAME);
        Bundle dBundle = null;
        if (dBundles == null || dBundles.length == 0) {
            try {
                dBundle = item.createBundle(DISPLAY_BUNDLE_NAME);
            }
            catch (AuthorizeException e) {
                log.error((Object)("User not authroized to create bundle on item \"" + item.getName() + "\": " + e.getMessage()));
            }
        } else {
            dBundle = dBundles[0];
        }
        HashMap<String, Bitstream> displayMap = new HashMap<String, Bitstream>();
        for (Bitstream bs : dBundle.getBitstreams()) {
            displayMap.put(bs.getName(), bs);
        }
        Object[] pBundles = item.getBundles(PRESERVATION_BUNDLE_NAME);
        Bundle pBundle = null;
        Bundle[] bundles = null;
        if (pBundles != null && pBundles.length > 0) {
            pBundle = pBundles[0];
            bundles = (Bundle[])ArrayUtils.addAll((Object[])item.getBundles("ORIGINAL"), (Object[])pBundles);
        } else {
            try {
                pBundle = item.createBundle(PRESERVATION_BUNDLE_NAME);
            }
            catch (AuthorizeException e) {
                log.error((Object)("User not authroized to create bundle on item \"" + item.getName() + "\": " + e.getMessage()));
            }
            bundles = item.getBundles("ORIGINAL");
        }
        for (Bundle bundle : bundles) {
            Bitstream[] bitstreams;
            for (Bitstream bitstream : bitstreams = bundle.getBitstreams()) {
                BitstreamFormat format = bitstream.getFormat();
                CitationDocument citationDocument = new CitationDocument();
                if (CitationDocument.canGenerateCitationVersion(bitstream)) {
                    this.resBuilder.append(item.getHandle() + " - " + bitstream.getName() + " is citable.");
                    try {
                        File citedDocument = citationDocument.makeCitedDocument(bitstream);
                        this.addCitedPageToItem(citedDocument, bundle, pBundle, dBundle, displayMap, item, bitstream);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        StackTraceElement[] stackTrace = e.getStackTrace();
                        StringBuilder stack = new StringBuilder();
                        int numLines = Math.min(stackTrace.length, 12);
                        for (int j = 0; j < numLines; ++j) {
                            stack.append("\t" + stackTrace[j].toString() + "\n");
                        }
                        if (stackTrace.length > numLines) {
                            stack.append("\t. . .\n");
                        }
                        log.error((Object)(e.toString() + " -> \n" + stack.toString()));
                        this.resBuilder.append(", but there was an error generating the PDF.\n");
                        this.status = -1;
                    }
                    continue;
                }
                this.resBuilder.append(item.getHandle() + " - " + bitstream.getName() + " is not citable.\n");
                this.status = 0;
            }
        }
    }

    private void addCitedPageToItem(File citedTemp, Bundle bundle, Bundle pBundle, Bundle dBundle, Map<String, Bitstream> displayMap, Item item, Bitstream bitstream) throws SQLException, AuthorizeException, IOException {
        if (bundle.getID() != pBundle.getID()) {
            pBundle.addBitstream(bitstream);
            bundle.removeBitstream(bitstream);
            Bitstream[] originalBits = bundle.getBitstreams();
            if (originalBits == null || originalBits.length == 0) {
                item.removeBundle(bundle);
            }
        }
        FileInputStream inp = new FileInputStream(citedTemp);
        if (displayMap.containsKey(bitstream.getName())) {
            dBundle.removeBitstream(displayMap.get(bitstream.getName()));
        }
        Bitstream citedBitstream = dBundle.createBitstream(inp);
        ((InputStream)inp).close();
        citedBitstream.setName(bitstream.getName());
        citedBitstream.setFormat(bitstream.getFormat());
        citedBitstream.setDescription(bitstream.getDescription());
        this.resBuilder.append(" Added " + citedBitstream.getName() + " to the " + DISPLAY_BUNDLE_NAME + " bundle.\n");
        item.update();
        this.status = 0;
    }
}

