/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.util.List;
import org.apache.solr.common.SolrInputDocument;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.SolrServiceIndexPlugin;

public class SolrServiceSpellIndexingPlugin
implements SolrServiceIndexPlugin {
    @Override
    public void additionalIndex(Context context, DSpaceObject dso, SolrInputDocument document) {
        if (dso instanceof Item) {
            Item item = (Item)dso;
            Metadatum[] dcValues = item.getMetadata("*", "*", "*", "*");
            List<String> toIgnoreMetadataFields = SearchUtils.getIgnoredMetadataFields(item.getType());
            for (Metadatum dcValue : dcValues) {
                String field;
                String unqualifiedField = field = dcValue.schema + "." + dcValue.element;
                String value = dcValue.value;
                if (value == null) continue;
                if (dcValue.qualifier != null && !dcValue.qualifier.trim().equals("")) {
                    field = field + "." + dcValue.qualifier;
                }
                if (toIgnoreMetadataFields.contains(field)) continue;
                document.addField("a_spell", (Object)dcValue.value);
            }
        }
    }
}

