/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.event;

import org.apache.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.event.ConsumerProfile;
import org.dspace.event.Dispatcher;
import org.dspace.event.Event;

public class BasicDispatcher
extends Dispatcher {
    private static Logger log = Logger.getLogger(BasicDispatcher.class);

    public BasicDispatcher(String name) {
        super(name);
    }

    @Override
    public void addConsumerProfile(ConsumerProfile cp) throws IllegalArgumentException {
        if (this.consumers.containsKey(cp.getName())) {
            throw new IllegalArgumentException("This dispatcher already has a consumer named \"" + cp.getName() + "\"");
        }
        this.consumers.put(cp.getName(), cp);
        if (log.isDebugEnabled()) {
            int n = 0;
            for (int[] f : cp.getFilters()) {
                log.debug((Object)("Adding Consumer=\"" + cp.getName() + "\", instance=" + cp.getConsumer().toString() + ", filter[" + String.valueOf(n) + "]=(ObjMask=" + String.valueOf(f[0]) + ", EventMask=" + String.valueOf(f[1]) + ")"));
                ++n;
            }
        }
    }

    @Override
    public void dispatch(Context ctx) {
        if (!this.consumers.isEmpty()) {
            if (!ctx.hasEvents()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing queue of " + String.valueOf(ctx.getEvents().size()) + " events."));
            }
            String tid = "TX" + Utils.generateKey();
            while (ctx.hasEvents()) {
                Event event = ctx.pollEvent();
                event.setDispatcher(this.getIdentifier());
                event.setTransactionID(tid);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Iterating over " + String.valueOf(this.consumers.values().size()) + " consumers..."));
                }
                for (ConsumerProfile cp : this.consumers.values()) {
                    if (!event.pass(cp.getFilters())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Sending event to \"" + cp.getName() + "\": " + event.toString()));
                    }
                    try {
                        cp.getConsumer().consume(ctx, event);
                        event.setBitSet(cp.getName());
                    }
                    catch (Exception e) {
                        log.error((Object)("Consumer(\"" + cp.getName() + "\").consume threw: " + e.toString()), (Throwable)e);
                    }
                }
            }
            for (ConsumerProfile cp : this.consumers.values()) {
                if (cp == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Calling end for consumer \"" + cp.getName() + "\""));
                }
                try {
                    cp.getConsumer().end(ctx);
                }
                catch (Exception e) {
                    log.error((Object)("Error in Consumer(\"" + cp.getName() + "\").end: " + e.toString()), (Throwable)e);
                }
            }
        }
    }
}

