/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.Util;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.Metadatum;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.content.authority.MetadataAuthorityManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSQuery;
import org.dspace.search.IndexingTask;
import org.dspace.sort.OrderFormat;
import org.dspace.sort.SortOption;

@Deprecated
public class DSIndexer {
    private static final Logger log = Logger.getLogger(DSIndexer.class);
    private static final String LAST_INDEXED_FIELD = "DSIndexer.lastIndexed";
    private static final String DOCUMENT_STATUS_FIELD = "DSIndexer.status";
    private static final long WRITE_LOCK_TIMEOUT = 30000L;
    private static Thread delayedIndexFlusher = null;
    private static int indexFlushDelay = ConfigurationManager.getIntProperty("search.index.delay", -1);
    private static int batchFlushAfterDocuments = ConfigurationManager.getIntProperty("search.batch.documents", 20);
    private static boolean batchProcessingMode = false;
    static final Version luceneVersion = Version.LATEST;
    private static String indexDirectory = ConfigurationManager.getProperty("search.dir");
    private static int maxfieldlength = -1;
    private static volatile Analyzer analyzer = null;
    private static IndexConfig[] indexConfigArr = new IndexConfig[]{new IndexConfig("author", "dc", "contributor", "*", "text"), new IndexConfig("author", "dc", "creator", "*", "text"), new IndexConfig("author", "dc", "description", "statementofresponsibility", "text"), new IndexConfig("title", "dc", "title", "*", "text"), new IndexConfig("keyword", "dc", "subject", "*", "text"), new IndexConfig("abstract", "dc", "description", "abstract", "text"), new IndexConfig("abstract", "dc", "description", "tableofcontents", "text"), new IndexConfig("series", "dc", "relation", "ispartofseries", "text"), new IndexConfig("mimetype", "dc", "format", "mimetype", "text"), new IndexConfig("sponsor", "dc", "description", "sponsorship", "text"), new IndexConfig("identifier", "dc", "identifier", "*", "text")};
    private static Map<String, IndexingTask> queuedTaskMap;

    public static void setBatchProcessingMode(boolean mode) {
        batchProcessingMode = mode;
        if (!mode) {
            DSIndexer.flushIndexingTaskQueue();
        }
    }

    public static void indexContent(Context context, DSpaceObject dso) throws SQLException, DCInputsReaderException {
        DSIndexer.indexContent(context, dso, false);
    }

    public static void indexContent(Context context, DSpaceObject dso, boolean force) throws SQLException, DCInputsReaderException {
        try {
            IndexingTask task = DSIndexer.prepareIndexingTask(context, dso, force);
            if (task != null) {
                DSIndexer.processIndexingTask(task);
            }
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public static void unIndexContent(Context context, DSpaceObject dso) throws SQLException, IOException {
        try {
            DSIndexer.unIndexContent(context, dso.getHandle());
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            DSIndexer.emailException(exception);
        }
    }

    public static void unIndexContent(Context context, String handle) throws SQLException, IOException {
        if (handle != null) {
            IndexingTask task = new IndexingTask(IndexingTask.Action.DELETE, new Term("handle", handle), null);
            if (task != null) {
                DSIndexer.processIndexingTask(task);
            }
        } else {
            log.warn((Object)"unindex of content with null handle attempted");
        }
    }

    public static void reIndexContent(Context context, DSpaceObject dso) throws SQLException, IOException {
        try {
            DSIndexer.indexContent(context, dso);
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            DSIndexer.emailException(exception);
        }
    }

    public static void createIndex(Context c) throws SQLException, IOException {
        DSIndexer.openIndex(true).close();
        DSIndexer.updateIndex(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void optimizeIndex(Context c) throws SQLException, IOException {
        try (IndexWriter writer = DSIndexer.openIndex(false);){
            DSIndexer.flushIndexingTaskQueue(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SQLException, IOException {
        Date startTime = new Date();
        try {
            DSIndexer.setBatchProcessingMode(true);
            Context context = new Context();
            context.setIgnoreAuthorization(true);
            String usage = "org.dspace.search.DSIndexer [-cbhof[r <item handle>]] or nothing to update/clean an existing index.";
            Options options = new Options();
            HelpFormatter formatter = new HelpFormatter();
            CommandLine line = null;
            OptionBuilder.withArgName((String)"item handle");
            OptionBuilder.hasArg((boolean)true);
            OptionBuilder.withDescription((String)"remove an Item, Collection or Community from index based on its handle");
            options.addOption(OptionBuilder.create((String)"r"));
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"optimize existing index");
            options.addOption(OptionBuilder.create((String)"o"));
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"clean existing index removing any documents that no longer exist in the db");
            options.addOption(OptionBuilder.create((String)"c"));
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"(re)build index, wiping out current one if it exists");
            options.addOption(OptionBuilder.create((String)"b"));
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"if updating existing index, force each handle to be reindexed even if uptodate");
            options.addOption(OptionBuilder.create((String)"f"));
            OptionBuilder.isRequired((boolean)false);
            OptionBuilder.withDescription((String)"print this help message");
            options.addOption(OptionBuilder.create((String)"h"));
            try {
                line = new PosixParser().parse(options, args);
            }
            catch (Exception e) {
                formatter.printHelp(usage, e.getMessage(), options, "");
                System.exit(1);
            }
            if (line.hasOption("h")) {
                formatter.printHelp(usage, options);
                System.exit(1);
            }
            if (line.hasOption("r")) {
                log.info((Object)("Removing " + line.getOptionValue("r") + " from Index"));
                DSIndexer.unIndexContent(context, line.getOptionValue("r"));
            } else if (line.hasOption("o")) {
                log.info((Object)"Optimizing Index");
                DSIndexer.optimizeIndex(context);
            } else if (line.hasOption("c")) {
                log.info((Object)"Cleaning Index");
                DSIndexer.cleanIndex(context);
            } else if (line.hasOption("b")) {
                log.info((Object)"(Re)building index from scratch.");
                DSIndexer.createIndex(context);
            } else {
                log.info((Object)"Updating and Cleaning Index");
                DSIndexer.cleanIndex(context);
                DSIndexer.updateIndex(context, line.hasOption("f"));
            }
            log.info((Object)"Done with indexing");
        }
        finally {
            DSIndexer.setBatchProcessingMode(false);
            Date endTime = new Date();
            System.out.println("Started: " + startTime.getTime());
            System.out.println("Ended: " + endTime.getTime());
            System.out.println("Elapsed time: " + (endTime.getTime() - startTime.getTime()) / 1000L + " secs (" + (endTime.getTime() - startTime.getTime()) + " msecs)");
        }
    }

    public static void updateIndex(Context context) {
        DSIndexer.updateIndex(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateIndex(Context context, boolean force) {
        try {
            try (ItemIterator items = null;){
                items = Item.findAll(context);
                while (items.hasNext()) {
                    Item item = items.next();
                    DSIndexer.indexContent(context, item);
                    item.decache();
                }
            }
            for (Collection collection : Collection.findAll(context)) {
                DSIndexer.indexContent(context, collection);
                context.removeCached(collection, collection.getID());
            }
            for (DSpaceObject dSpaceObject : Community.findAll(context)) {
                DSIndexer.indexContent(context, dSpaceObject);
                context.removeCached(dSpaceObject, ((Community)dSpaceObject).getID());
            }
            DSIndexer.optimizeIndex(context);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void cleanIndex(Context context) throws IOException, SQLException {
        IndexReader reader = DSQuery.getIndexReader();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        for (int i = 0; i < reader.numDocs(); ++i) {
            if (!liveDocs.get(i)) {
                log.debug((Object)("Encountered deleted doc: " + i));
                continue;
            }
            Document doc = reader.document(i);
            String handle = doc.get("handle");
            if (StringUtils.isEmpty((String)handle)) continue;
            DSpaceObject o = HandleManager.resolveToObject(context, handle);
            if (o == null) {
                log.info((Object)("Deleting: " + handle));
                DSIndexer.unIndexContent(context, handle);
                continue;
            }
            context.removeCached(o, o.getID());
            log.debug((Object)("Keeping: " + handle));
        }
    }

    static Analyzer getAnalyzer() {
        if (analyzer == null) {
            String analyzerClassName = ConfigurationManager.getProperty("search.analyzer");
            if (analyzerClassName == null) {
                analyzerClassName = "org.dspace.search.DSAnalyzer";
            }
            try {
                Class<?> analyzerClass = Class.forName(analyzerClassName);
                Constructor<?> constructor = analyzerClass.getDeclaredConstructor(Version.class);
                constructor.setAccessible(true);
                analyzer = (Analyzer)constructor.newInstance(luceneVersion);
            }
            catch (Exception e) {
                log.fatal((Object)LogManager.getHeader(null, "no_search_analyzer", "search.analyzer=" + analyzerClassName), (Throwable)e);
                throw new IllegalStateException(e.toString());
            }
        }
        return analyzer;
    }

    static IndexingTask prepareIndexingTask(Context context, DSpaceObject dso, boolean force) throws SQLException, IOException, DCInputsReaderException {
        String handle = HandleManager.findHandle(context, dso);
        Term term = new Term("handle", handle);
        IndexingTask action = null;
        switch (dso.getType()) {
            case 2: {
                Item item = (Item)dso;
                if (item.isArchived() && !item.isWithdrawn()) {
                    if (!DSIndexer.requiresIndexing(term, ((Item)dso).getLastModified()) && !force) break;
                    log.info((Object)("Writing Item: " + handle + " to Index"));
                    action = new IndexingTask(IndexingTask.Action.UPDATE, term, DSIndexer.buildDocumentForItem(context, (Item)dso));
                    break;
                }
                action = new IndexingTask(IndexingTask.Action.DELETE, term, null);
                break;
            }
            case 3: {
                log.info((Object)("Writing Collection: " + handle + " to Index"));
                action = new IndexingTask(IndexingTask.Action.UPDATE, term, DSIndexer.buildDocumentForCollection((Collection)dso));
                break;
            }
            case 4: {
                log.info((Object)("Writing Community: " + handle + " to Index"));
                action = new IndexingTask(IndexingTask.Action.UPDATE, term, DSIndexer.buildDocumentForCommunity((Community)dso));
                break;
            }
            default: {
                log.error((Object)"Only Items, Collections and Communities can be Indexed");
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processIndexingTask(IndexingTask task) throws IOException {
        if (batchProcessingMode) {
            DSIndexer.addToIndexingTaskQueue(task);
        } else if (indexFlushDelay > 0) {
            DSIndexer.addToIndexingTaskQueue(task);
            DSIndexer.startDelayedIndexFlusher();
        } else {
            IndexWriter writer = null;
            try {
                writer = DSIndexer.openIndex(false);
                DSIndexer.executeIndexingTask(writer, task);
            }
            finally {
                if (task.getDocument() != null) {
                    DSIndexer.closeAllReaders(task.getDocument());
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Unable to close IndexWriter", (Throwable)e);
                    }
                }
            }
        }
    }

    private static void executeIndexingTask(IndexWriter writer, IndexingTask action) throws IOException {
        if (action != null) {
            if (action.isDelete()) {
                if (action.getDocument() != null) {
                    writer.updateDocument(action.getTerm(), (Iterable)action.getDocument());
                } else {
                    writer.deleteDocuments(new Term[]{action.getTerm()});
                }
            } else {
                writer.updateDocument(action.getTerm(), (Iterable)action.getDocument());
            }
        }
    }

    static synchronized void addToIndexingTaskQueue(IndexingTask action) {
        if (action != null) {
            queuedTaskMap.put(action.getTerm().text(), action);
            if (queuedTaskMap.size() >= batchFlushAfterDocuments) {
                DSIndexer.flushIndexingTaskQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void flushIndexingTaskQueue() {
        if (queuedTaskMap.size() > 0) {
            IndexWriter writer = null;
            try {
                writer = DSIndexer.openIndex(false);
                DSIndexer.flushIndexingTaskQueue(writer);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ex) {
                        log.error((Object)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void flushIndexingTaskQueue(IndexWriter writer) {
        for (IndexingTask action : queuedTaskMap.values()) {
            try {
                DSIndexer.executeIndexingTask(writer, action);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
            finally {
                if (action.getDocument() == null) continue;
                DSIndexer.closeAllReaders(action.getDocument());
            }
        }
        queuedTaskMap.clear();
        if (delayedIndexFlusher != null) {
            delayedIndexFlusher.interrupt();
            delayedIndexFlusher = null;
        }
    }

    private static void emailException(Exception exception) {
        try {
            String recipient = ConfigurationManager.getProperty("alert.recipient");
            if (StringUtils.isNotBlank((String)recipient)) {
                String stackTrace;
                Email email = Email.getEmail(I18nUtil.getEmailFilename(Locale.getDefault(), "internal_error"));
                email.addRecipient(recipient);
                email.addArgument(ConfigurationManager.getProperty("dspace.url"));
                email.addArgument(new Date());
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    pw.flush();
                    stackTrace = sw.toString();
                } else {
                    stackTrace = "No exception";
                }
                email.addArgument(stackTrace);
                email.send();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to send email alert", (Throwable)e);
        }
    }

    private static boolean requiresIndexing(Term t, Date lastModified) throws SQLException, IOException {
        Bits liveDocs;
        boolean reindexItem = false;
        boolean inIndex = false;
        IndexReader ir = DSQuery.getIndexReader();
        DocsEnum docs = MultiFields.getTermDocsEnum((IndexReader)ir, (Bits)(liveDocs = MultiFields.getLiveDocs((IndexReader)ir)), (String)t.field(), (BytesRef)t.bytes());
        if (docs != null) {
            int id;
            while ((id = docs.nextDoc()) != Integer.MAX_VALUE) {
                inIndex = true;
                Document doc = ir.document(id);
                IndexableField lastIndexed = doc.getField(LAST_INDEXED_FIELD);
                if (lastIndexed != null && Long.parseLong(lastIndexed.stringValue()) >= lastModified.getTime()) continue;
                reindexItem = true;
            }
        }
        return reindexItem || !inIndex;
    }

    private static IndexWriter openIndex(boolean wipeExisting) throws IOException {
        FSDirectory dir = FSDirectory.open((File)new File(indexDirectory));
        LimitTokenCountAnalyzer decoratorAnalyzer = null;
        decoratorAnalyzer = maxfieldlength == -1 ? new LimitTokenCountAnalyzer(DSIndexer.getAnalyzer(), Integer.MAX_VALUE) : new LimitTokenCountAnalyzer(DSIndexer.getAnalyzer(), maxfieldlength);
        IndexWriterConfig iwc = new IndexWriterConfig(luceneVersion, (Analyzer)decoratorAnalyzer);
        if (wipeExisting) {
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        IndexWriter writer = new IndexWriter((Directory)dir, iwc);
        return writer;
    }

    private static String buildItemLocationString(Item myitem) throws SQLException {
        Community[] communities = myitem.getCommunities();
        Collection[] collections = myitem.getCollections();
        StringBuffer location = new StringBuffer();
        int i = 0;
        for (i = 0; i < communities.length; ++i) {
            location.append(" m").append(communities[i].getID());
        }
        for (i = 0; i < collections.length; ++i) {
            location.append(" l").append(collections[i].getID());
        }
        return location.toString();
    }

    private static String buildCollectionLocationString(Collection target) throws SQLException {
        Community[] communities = target.getCommunities();
        StringBuffer location = new StringBuffer();
        int i = 0;
        for (i = 0; i < communities.length; ++i) {
            location.append(" m").append(communities[i].getID());
        }
        return location.toString();
    }

    private static Document buildDocumentForCommunity(Community community) throws SQLException, IOException {
        Document doc = DSIndexer.buildDocument(4, community.getID(), community.getHandle(), null);
        String name = community.getMetadata("name");
        if (name != null) {
            doc.add((IndexableField)new Field("name", name, Field.Store.NO, Field.Index.ANALYZED));
            doc.add((IndexableField)new Field("default", name, Field.Store.NO, Field.Index.ANALYZED));
        }
        return doc;
    }

    private static Document buildDocumentForCollection(Collection collection) throws SQLException, IOException {
        String location_text = DSIndexer.buildCollectionLocationString(collection);
        Document doc = DSIndexer.buildDocument(3, collection.getID(), collection.getHandle(), location_text);
        String name = collection.getMetadata("name");
        if (name != null) {
            doc.add((IndexableField)new Field("name", name, Field.Store.NO, Field.Index.ANALYZED));
            doc.add((IndexableField)new Field("default", name, Field.Store.NO, Field.Index.ANALYZED));
        }
        return doc;
    }

    private static Document buildDocumentForItem(Context context, Item item) throws SQLException, IOException, DCInputsReaderException {
        int j;
        String handle = HandleManager.findHandle(context, item);
        String location = DSIndexer.buildItemLocationString(item);
        Document doc = DSIndexer.buildDocument(2, item.getID(), handle, location);
        log.debug((Object)("Building Item: " + handle));
        if (indexConfigArr.length > 0) {
            for (int i = 0; i < indexConfigArr.length; ++i) {
                Metadatum[] mydc = DSIndexer.indexConfigArr[i].qualifier != null && DSIndexer.indexConfigArr[i].qualifier.equals("*") ? item.getMetadata(DSIndexer.indexConfigArr[i].schema, DSIndexer.indexConfigArr[i].element, "*", "*") : item.getMetadata(DSIndexer.indexConfigArr[i].schema, DSIndexer.indexConfigArr[i].element, DSIndexer.indexConfigArr[i].qualifier, "*");
                if ("inputform".equalsIgnoreCase(DSIndexer.indexConfigArr[i].type)) {
                    ArrayList<String> newValues = new ArrayList<String>();
                    Locale[] supportedLocales = I18nUtil.getSupportedLocales();
                    for (int k = 0; k < supportedLocales.length; ++k) {
                        List<String> displayValues = Util.getControlledVocabulariesDisplayValueLocalized(item, mydc, DSIndexer.indexConfigArr[i].schema, DSIndexer.indexConfigArr[i].element, DSIndexer.indexConfigArr[i].qualifier, supportedLocales[k]);
                        if (displayValues == null || displayValues.isEmpty()) continue;
                        for (int d = 0; d < displayValues.size(); ++d) {
                            newValues.add(displayValues.get(d));
                        }
                    }
                    if (newValues != null) {
                        for (int m = 0; m < newValues.size(); ++m) {
                            if ("".equals(newValues.get(m))) continue;
                            String toAdd = (String)newValues.get(m);
                            doc.add((IndexableField)new Field(DSIndexer.indexConfigArr[i].indexName, toAdd, Field.Store.NO, Field.Index.ANALYZED));
                        }
                    }
                }
                for (j = 0; j < mydc.length; ++j) {
                    Date d;
                    if (StringUtils.isEmpty((String)mydc[j].value)) continue;
                    if ("timestamp".equalsIgnoreCase(DSIndexer.indexConfigArr[i].type)) {
                        d = DSIndexer.toDate(mydc[j].value);
                        if (d != null) {
                            doc.add((IndexableField)new Field(DSIndexer.indexConfigArr[i].indexName, DateTools.dateToString((Date)d, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.NO, Field.Index.NOT_ANALYZED));
                            doc.add((IndexableField)new Field(DSIndexer.indexConfigArr[i].indexName + ".year", DateTools.dateToString((Date)d, (DateTools.Resolution)DateTools.Resolution.YEAR), Field.Store.NO, Field.Index.NOT_ANALYZED));
                        }
                    } else if ("date".equalsIgnoreCase(DSIndexer.indexConfigArr[i].type)) {
                        d = DSIndexer.toDate(mydc[j].value);
                        if (d != null) {
                            doc.add((IndexableField)new Field(DSIndexer.indexConfigArr[i].indexName, DateTools.dateToString((Date)d, (DateTools.Resolution)DateTools.Resolution.DAY), Field.Store.NO, Field.Index.NOT_ANALYZED));
                            doc.add((IndexableField)new Field(DSIndexer.indexConfigArr[i].indexName + ".year", DateTools.dateToString((Date)d, (DateTools.Resolution)DateTools.Resolution.YEAR), Field.Store.NO, Field.Index.NOT_ANALYZED));
                        }
                    } else {
                        List<String> variants = null;
                        if (mydc[j].authority != null && mydc[j].confidence >= MetadataAuthorityManager.getManager().getMinConfidence(mydc[j].schema, mydc[j].element, mydc[j].qualifier)) {
                            variants = ChoiceAuthorityManager.getManager().getVariants(mydc[j].schema, mydc[j].element, mydc[j].qualifier, mydc[j].authority, mydc[j].language);
                            doc.add((IndexableField)new Field(DSIndexer.indexConfigArr[i].indexName + "_authority", mydc[j].authority, Field.Store.NO, Field.Index.NOT_ANALYZED));
                            boolean valueAlreadyIndexed = false;
                            if (variants != null) {
                                for (String var : variants) {
                                    doc.add((IndexableField)new Field(DSIndexer.indexConfigArr[i].indexName, var, Field.Store.NO, Field.Index.ANALYZED));
                                    if (var.equals(mydc[j].value)) {
                                        valueAlreadyIndexed = true;
                                        continue;
                                    }
                                    doc.add((IndexableField)new Field("default", var, Field.Store.NO, Field.Index.ANALYZED));
                                }
                            }
                            if (!valueAlreadyIndexed) {
                                doc.add((IndexableField)new Field(DSIndexer.indexConfigArr[i].indexName, mydc[j].value, Field.Store.NO, Field.Index.ANALYZED));
                            }
                        } else {
                            doc.add((IndexableField)new Field(DSIndexer.indexConfigArr[i].indexName, mydc[j].value, Field.Store.NO, Field.Index.ANALYZED));
                        }
                    }
                    doc.add((IndexableField)new Field("default", mydc[j].value, Field.Store.NO, Field.Index.ANALYZED));
                }
            }
        }
        log.debug((Object)"  Added Metadata");
        try {
            for (SortOption so : SortOption.getSortOptions()) {
                String[] somd = so.getMdBits();
                Metadatum[] dcv = item.getMetadata(somd[0], somd[1], somd[2], "*");
                if (dcv.length <= 0) continue;
                String value = OrderFormat.makeSortString(dcv[0].value, dcv[0].language, so.getType());
                doc.add((IndexableField)new Field("sort_" + so.getName(), value, Field.Store.NO, Field.Index.NOT_ANALYZED));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.debug((Object)"  Added Sorting");
        try {
            Bundle[] myBundles = item.getBundles();
            for (int i = 0; i < myBundles.length; ++i) {
                if (myBundles[i].getName() == null || !myBundles[i].getName().equals("TEXT")) continue;
                Bitstream[] myBitstreams = myBundles[i].getBitstreams();
                for (j = 0; j < myBitstreams.length; ++j) {
                    try {
                        doc.add((IndexableField)new Field("default", (Reader)new BufferedReader(new InputStreamReader(myBitstreams[j].retrieve()))));
                        log.debug((Object)("  Added BitStream: " + myBitstreams[j].getStoreNumber() + "\t" + myBitstreams[j].getSequenceID() + "   " + myBitstreams[j].getName()));
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.info((Object)("Wrote Item: " + handle + " to Index"));
        return doc;
    }

    private static Document buildDocument(int type, int id, String handle, String location) {
        Document doc = new Document();
        doc.add((IndexableField)new Field(LAST_INDEXED_FIELD, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((IndexableField)new Field(DOCUMENT_STATUS_FIELD, "archived", Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((IndexableField)new Field("type", Integer.toString(type), Field.Store.YES, Field.Index.NO));
        doc.add((IndexableField)new Field("search.resourcetype", Integer.toString(type), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((IndexableField)new Field("search.resourceid", Integer.toString(id), Field.Store.YES, Field.Index.NO));
        if (handle != null) {
            doc.add((IndexableField)new Field("handletext", handle, Field.Store.YES, Field.Index.ANALYZED));
            doc.add((IndexableField)new Field("handle", handle, Field.Store.YES, Field.Index.NOT_ANALYZED));
            doc.add((IndexableField)new Field("default", handle, Field.Store.NO, Field.Index.ANALYZED));
        }
        if (location != null) {
            doc.add((IndexableField)new Field("location", location, Field.Store.NO, Field.Index.ANALYZED));
            doc.add((IndexableField)new Field("default", location, Field.Store.NO, Field.Index.ANALYZED));
        }
        return doc;
    }

    private static Document buildDocumentForDeletedHandle(String handle) {
        Document doc = new Document();
        doc.add((IndexableField)new Field(LAST_INDEXED_FIELD, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((IndexableField)new Field(DOCUMENT_STATUS_FIELD, "deleted", Field.Store.YES, Field.Index.NOT_ANALYZED));
        return doc;
    }

    private static Document buildDocumentForWithdrawnItem(Item item) {
        Document doc = new Document();
        doc.add((IndexableField)new Field(LAST_INDEXED_FIELD, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((IndexableField)new Field(DOCUMENT_STATUS_FIELD, "withdrawn", Field.Store.YES, Field.Index.NOT_ANALYZED));
        return doc;
    }

    private static void closeAllReaders(Document doc) {
        if (doc != null) {
            int count = 0;
            List fields = doc.getFields();
            if (fields != null) {
                for (Field field : fields) {
                    Reader r = field.readerValue();
                    if (r == null) continue;
                    try {
                        r.close();
                        ++count;
                    }
                    catch (IOException e) {
                        log.error((Object)"Unable to close reader", (Throwable)e);
                    }
                }
            }
            if (count > 0) {
                log.debug((Object)("closed " + count + " readers"));
            }
        }
    }

    private static Date toDate(String t) {
        SimpleDateFormat[] dfArr;
        switch (t.length()) {
            case 4: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy")};
                break;
            }
            case 6: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMM")};
                break;
            }
            case 7: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM")};
                break;
            }
            case 8: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy MMM")};
                break;
            }
            case 10: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd")};
                break;
            }
            case 11: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy MMM dd")};
                break;
            }
            case 20: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")};
                break;
            }
            default: {
                dfArr = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")};
            }
        }
        for (SimpleDateFormat df : dfArr) {
            try {
                df.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                df.setLenient(false);
                return df.parse(t);
            }
            catch (ParseException pe) {
                log.error((Object)"Unable to parse date format", (Throwable)pe);
            }
        }
        return null;
    }

    private static synchronized void startDelayedIndexFlusher() {
        if (delayedIndexFlusher != null && !delayedIndexFlusher.isAlive()) {
            delayedIndexFlusher = null;
        }
        if (delayedIndexFlusher == null && queuedTaskMap.size() > 0) {
            delayedIndexFlusher = new Thread(new DelayedIndexFlushThread());
            delayedIndexFlusher.start();
        }
    }

    static {
        if (ConfigurationManager.getProperty("search.maxfieldlength") != null) {
            maxfieldlength = ConfigurationManager.getIntProperty("search.maxfieldlength");
        }
        ArrayList<String> indexConfigList = new ArrayList<String>();
        int i = 1;
        while (ConfigurationManager.getProperty("search.index." + i) != null) {
            indexConfigList.add(ConfigurationManager.getProperty("search.index." + i));
            ++i;
        }
        if (indexConfigList.size() > 0) {
            indexConfigArr = new IndexConfig[indexConfigList.size()];
            for (i = 0; i < indexConfigList.size(); ++i) {
                DSIndexer.indexConfigArr[i] = new IndexConfig();
                String index = (String)indexConfigList.get(i);
                String[] configLine = index.split(":");
                DSIndexer.indexConfigArr[i].indexName = configLine[0];
                String[] parts = configLine[1].split("\\.");
                switch (parts.length) {
                    case 3: {
                        DSIndexer.indexConfigArr[i].qualifier = parts[2];
                    }
                    case 2: {
                        DSIndexer.indexConfigArr[i].schema = parts[0];
                        DSIndexer.indexConfigArr[i].element = parts[1];
                        break;
                    }
                    default: {
                        log.warn((Object)("Malformed configuration line: search.index." + i));
                        throw new IllegalStateException("Malformed configuration line: search.index." + i);
                    }
                }
                if (configLine.length <= 2) continue;
                DSIndexer.indexConfigArr[i].type = configLine[2];
            }
        }
        IndexWriterConfig.setDefaultWriteLockTimeout((long)30000L);
        try {
            if (!DirectoryReader.indexExists((Directory)FSDirectory.open((File)new File(indexDirectory)))) {
                if (!new File(indexDirectory).mkdirs()) {
                    log.error((Object)("Unable to create index directory: " + indexDirectory));
                }
                DSIndexer.openIndex(true).close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create search index: " + e.getMessage(), e);
        }
        queuedTaskMap = new HashMap<String, IndexingTask>();
    }

    private static class DelayedIndexFlushThread
    implements Runnable {
        private DelayedIndexFlushThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(indexFlushDelay);
                DSIndexer.flushIndexingTaskQueue();
            }
            catch (InterruptedException e) {
                log.debug((Object)e);
            }
        }
    }

    private static class IndexConfig {
        String indexName;
        String schema;
        String element;
        String qualifier = null;
        String type = "text";

        IndexConfig() {
        }

        IndexConfig(String indexName, String schema, String element, String qualifier, String type) {
            this.indexName = indexName;
            this.schema = schema;
            this.element = element;
            this.qualifier = qualifier;
            this.type = type;
        }
    }
}

