/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import java.util.Set;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Item;
import org.dspace.content.Metadatum;
import org.dspace.core.Context;
import org.dspace.storage.bitstore.BitstreamStorageManager;

public abstract class AbstractVersionProvider {
    private Set<String> ignoredMetadataFields;

    protected void copyMetadata(Item itemNew, Item nativeItem) {
        Metadatum[] md;
        for (Metadatum aMd : md = nativeItem.getMetadata("*", "*", "*", "*")) {
            String unqualifiedMetadataField = aMd.schema + "." + aMd.element;
            String qualifiedMetadataField = unqualifiedMetadataField + (aMd.qualifier == null ? "" : "." + aMd.qualifier);
            if (this.getIgnoredMetadataFields().contains(qualifiedMetadataField) || this.getIgnoredMetadataFields().contains(unqualifiedMetadataField + "." + "*")) continue;
            itemNew.addMetadata(aMd.schema, aMd.element, aMd.qualifier, aMd.language, aMd.value, aMd.authority, aMd.confidence);
        }
    }

    protected void createBundlesAndAddBitstreams(Context c, Item itemNew, Item nativeItem) throws SQLException, AuthorizeException {
        for (Bundle nativeBundle : nativeItem.getBundles()) {
            Bundle bundleNew = itemNew.createBundle(nativeBundle.getName());
            for (Bitstream nativeBitstream : nativeBundle.getBitstreams()) {
                Bitstream bitstreamNew = this.createBitstream(c, nativeBitstream);
                bundleNew.addBitstream(bitstreamNew);
                if (nativeBundle.getPrimaryBitstreamID() != nativeBitstream.getID()) continue;
                bundleNew.setPrimaryBitstreamID(bitstreamNew.getID());
            }
        }
    }

    protected Bitstream createBitstream(Context context, Bitstream nativeBitstream) throws AuthorizeException, SQLException {
        Metadatum[] bitstreamMeta;
        int idNew = BitstreamStorageManager.clone(context, nativeBitstream.getID());
        Bitstream newBitstream = Bitstream.find(context, idNew);
        for (Metadatum value : bitstreamMeta = nativeBitstream.getMetadata("*", "*", "*", "*")) {
            newBitstream.addMetadata(value.schema, value.element, value.qualifier, value.language, value.value, value.authority, value.confidence);
        }
        newBitstream.updateMetadata();
        return newBitstream;
    }

    public void setIgnoredMetadataFields(Set<String> ignoredMetadataFields) {
        this.ignoredMetadataFields = ignoredMetadataFields;
    }

    public Set getIgnoredMetadataFields() {
        return this.ignoredMetadataFields;
    }
}

