/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authority.orcid.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.dspace.authority.orcid.model.Bio;
import org.dspace.authority.orcid.model.BioExternalIdentifier;
import org.dspace.authority.orcid.model.BioName;
import org.dspace.authority.orcid.model.BioResearcherUrl;
import org.dspace.authority.orcid.xml.Converter;
import org.dspace.authority.orcid.xml.XMLErrors;
import org.dspace.authority.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLtoBio
extends Converter {
    private static Logger log = Logger.getLogger(XMLtoBio.class);
    protected String ORCID_BIO = "//orcid-bio";
    protected String ORCID = "parent::*/orcid-identifier/path";
    protected String PERSONAL_DETAILS = "personal-details";
    protected String GIVEN_NAMES = this.PERSONAL_DETAILS + "/given-names";
    protected String FAMILY_NAME = this.PERSONAL_DETAILS + "/family-name";
    protected String CREDIT_NAME = this.PERSONAL_DETAILS + "/credit-name";
    protected String OTHER_NAMES = this.PERSONAL_DETAILS + "/other-names";
    protected String OTHER_NAME = this.OTHER_NAMES + "/other-name";
    protected String CONTACT_DETAILS = "contact-details";
    protected String COUNTRY = this.CONTACT_DETAILS + "/address/country";
    protected String KEYWORDS = "keywords";
    protected String KEYWORD = this.KEYWORDS + "/keyword";
    protected String EXTERNAL_IDENTIFIERS = "external-identifiers";
    protected String EXTERNAL_IDENTIFIER = this.EXTERNAL_IDENTIFIERS + "/external-identifier";
    protected String EXTERNAL_ID_ORCID = "external-id-orcid";
    protected String EXTERNAL_ID_COMMNON_NAME = "external-id-common-name";
    protected String EXTERNAL_ID_REFERENCE = "external-id-reference";
    protected String EXTERNAL_ID_URL = "external-id-url";
    protected String RESEARCHER_URLS = "researcher-urls";
    protected String RESEARCHER_URL = "researcher-urls/researcher-url";
    protected String URL_NAME = "url-name";
    protected String URL = "url";
    protected String BIOGRAPHY = this.ORCID_BIO + "/biography";
    protected String AFFILIATIONS = this.ORCID_BIO + "/affiliation";
    protected String ORCID_NOT_FOUND = "ORCID [\\d-]* not found";

    public List<Bio> convert(Document xml) {
        ArrayList<Bio> result = new ArrayList<Bio>();
        if (XMLErrors.check(xml)) {
            try {
                Iterator<Node> iterator = XMLUtils.getNodeListIterator(xml, this.ORCID_BIO);
                while (iterator.hasNext()) {
                    Bio bio = this.convertBio(iterator.next());
                    result.add(bio);
                }
            }
            catch (XPathExpressionException e) {
                log.error((Object)"Error in xpath syntax", (Throwable)e);
            }
        } else {
            this.processError(xml);
        }
        return result;
    }

    private Bio convertBio(Node node) {
        Bio bio = new Bio();
        this.setOrcid(node, bio);
        this.setPersonalDetails(node, bio);
        this.setContactDetails(node, bio);
        this.setKeywords(node, bio);
        this.setExternalIdentifiers(node, bio);
        this.setResearcherUrls(node, bio);
        this.setBiography(node, bio);
        return bio;
    }

    @Override
    protected void processError(Document xml) {
        String errorMessage = XMLErrors.getErrorMessage(xml);
        if (errorMessage.matches(this.ORCID_NOT_FOUND)) {
            // empty if block
        }
        log.error((Object)("The orcid-message reports an error: " + errorMessage));
    }

    private void setOrcid(Node node, Bio bio) {
        try {
            String orcid = XMLUtils.getTextContent(node, this.ORCID);
            bio.setOrcid(orcid);
        }
        catch (XPathExpressionException e) {
            log.debug((Object)"Error in finding the biography in bio xml.", (Throwable)e);
        }
    }

    protected void setBiography(Node xml, Bio bio) {
        try {
            String biography = XMLUtils.getTextContent(xml, this.BIOGRAPHY);
            bio.setBiography(biography);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error in finding the biography in bio xml.", (Throwable)e);
        }
    }

    protected void setResearcherUrls(Node xml, Bio bio) {
        try {
            NodeList researcher_urls = XMLUtils.getNodeList(xml, this.RESEARCHER_URL);
            if (researcher_urls != null) {
                for (int i = 0; i < researcher_urls.getLength(); ++i) {
                    Node researcher_url = researcher_urls.item(i);
                    if (researcher_url.getNodeType() == 3) continue;
                    String url_name = XMLUtils.getTextContent(researcher_url, this.URL_NAME);
                    String url = XMLUtils.getTextContent(researcher_url, this.URL);
                    BioResearcherUrl researcherUrl = new BioResearcherUrl(url_name, url);
                    bio.addResearcherUrl(researcherUrl);
                }
            }
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error in finding the researcher url in bio xml.", (Throwable)e);
        }
    }

    protected void setExternalIdentifiers(Node xml, Bio bio) {
        try {
            Iterator<Node> iterator = XMLUtils.getNodeListIterator(xml, this.EXTERNAL_IDENTIFIER);
            while (iterator.hasNext()) {
                Node external_identifier = iterator.next();
                String id_orcid = XMLUtils.getTextContent(external_identifier, this.EXTERNAL_ID_ORCID);
                String id_common_name = XMLUtils.getTextContent(external_identifier, this.EXTERNAL_ID_COMMNON_NAME);
                String id_reference = XMLUtils.getTextContent(external_identifier, this.EXTERNAL_ID_REFERENCE);
                String id_url = XMLUtils.getTextContent(external_identifier, this.EXTERNAL_ID_URL);
                BioExternalIdentifier externalIdentifier = new BioExternalIdentifier(id_orcid, id_common_name, id_reference, id_url);
                bio.addExternalIdentifier(externalIdentifier);
            }
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error in finding the external identifier in bio xml.", (Throwable)e);
        }
    }

    protected void setKeywords(Node xml, Bio bio) {
        try {
            NodeList keywords = XMLUtils.getNodeList(xml, this.KEYWORD);
            if (keywords != null) {
                for (int i = 0; i < keywords.getLength(); ++i) {
                    String[] split;
                    String keyword = keywords.item(i).getTextContent();
                    for (String k : split = keyword.split(",")) {
                        bio.addKeyword(k.trim());
                    }
                }
            }
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error in finding the keywords in bio xml.", (Throwable)e);
        }
    }

    protected void setContactDetails(Node xml, Bio bio) {
        try {
            String country = XMLUtils.getTextContent(xml, this.COUNTRY);
            bio.setCountry(country);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error in finding the country in bio xml.", (Throwable)e);
        }
    }

    protected void setPersonalDetails(Node xml, Bio bio) {
        BioName name = bio.getName();
        try {
            String givenNames = XMLUtils.getTextContent(xml, this.GIVEN_NAMES);
            name.setGivenNames(givenNames);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error in finding the given names in bio xml.", (Throwable)e);
        }
        try {
            String familyName = XMLUtils.getTextContent(xml, this.FAMILY_NAME);
            name.setFamilyName(familyName);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error in finding the family name in bio xml.", (Throwable)e);
        }
        try {
            String creditName = XMLUtils.getTextContent(xml, this.CREDIT_NAME);
            name.setCreditName(creditName);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error in finding the credit name in bio xml.", (Throwable)e);
        }
        try {
            Iterator<Node> iterator = XMLUtils.getNodeListIterator(xml, this.OTHER_NAME);
            while (iterator.hasNext()) {
                Node otherName = iterator.next();
                String textContent = otherName.getTextContent();
                name.getOtherNames().add(textContent.trim());
            }
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error in finding the other names in bio xml.", (Throwable)e);
        }
    }
}

