/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.StreamDisseminationCrosswalk;
import org.dspace.content.packager.PackageUtils;
import org.dspace.core.Context;
import org.dspace.core.Utils;

public class LicenseStreamDisseminationCrosswalk
implements StreamDisseminationCrosswalk {
    private static Logger log = Logger.getLogger(LicenseStreamDisseminationCrosswalk.class);

    @Override
    public boolean canDisseminate(Context context, DSpaceObject dso) {
        try {
            return dso.getType() == 2 && PackageUtils.findDepositLicense(context, (Item)dso) != null;
        }
        catch (Exception e) {
            log.error((Object)"Failed getting Deposit license", (Throwable)e);
            return false;
        }
    }

    @Override
    public void disseminate(Context context, DSpaceObject dso, OutputStream out) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Bitstream licenseBs;
        if (dso.getType() == 2 && (licenseBs = PackageUtils.findDepositLicense(context, (Item)dso)) != null) {
            Utils.copy(licenseBs.retrieve(), out);
            out.close();
        }
    }

    @Override
    public String getMIMEType() {
        return "text/plain";
    }
}

