/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.util.ArrayList;
import java.util.List;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.VersionHistoryDAO;

public class VersionHistoryImpl
implements VersionHistory {
    private int versionHistoryId;
    private List<Version> versions;
    private Context myContext;
    private TableRow myRow;

    protected VersionHistoryImpl(VersionHistoryDAO vhDAO) {
    }

    protected VersionHistoryImpl(Context c, TableRow row) {
        this.myContext = c;
        this.myRow = row;
        c.cache(this, row.getIntColumn("versionhistory_id"));
    }

    @Override
    public int getVersionHistoryId() {
        return this.myRow.getIntColumn("versionhistory_id");
    }

    @Override
    public Version getPrevious(Version version) {
        int index = this.versions.indexOf(version);
        if (index + 1 == this.versions.size()) {
            return null;
        }
        return this.versions.get(index + 1);
    }

    @Override
    public Version getNext(Version version) {
        int index = this.versions.indexOf(version);
        if (index == 0) {
            return null;
        }
        return this.versions.get(index - 1);
    }

    @Override
    public Version getVersion(Item item) {
        for (Version v : this.versions) {
            if (v.getItem().getID() != item.getID()) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean hasNext(Item item) {
        Version version = this.getVersion(item);
        return this.hasNext(version);
    }

    @Override
    public boolean hasNext(Version version) {
        return this.getNext(version) != null;
    }

    @Override
    public List<Version> getVersions() {
        return this.versions;
    }

    public void setVersions(List<Version> versions) {
        this.versions = versions;
    }

    @Override
    public void add(Version version) {
        if (this.versions == null) {
            this.versions = new ArrayList<Version>();
        }
        this.versions.add(0, version);
    }

    @Override
    public Version getLatestVersion() {
        if (this.versions == null || this.versions.size() == 0) {
            return null;
        }
        return this.versions.get(0);
    }

    @Override
    public Version getFirstVersion() {
        if (this.versions == null || this.versions.size() == 0) {
            return null;
        }
        return this.versions.get(this.versions.size() - 1);
    }

    @Override
    public boolean isFirstVersion(Version version) {
        Version first = this.versions.get(this.versions.size() - 1);
        return first.equals(version);
    }

    @Override
    public boolean isLastVersion(Version version) {
        Version last = this.versions.get(0);
        return last.equals(version);
    }

    @Override
    public void remove(Version version) {
        this.versions.remove(version);
    }

    @Override
    public boolean isEmpty() {
        return this.versions.size() == 0;
    }

    @Override
    public int size() {
        return this.versions.size();
    }

    protected TableRow getMyRow() {
        return this.myRow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionHistoryImpl that = (VersionHistoryImpl)o;
        return this.versionHistoryId == that.versionHistoryId;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.getVersionHistoryId() ^ this.getVersionHistoryId() >>> 32);
        return hash;
    }
}

