/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mediafilter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.app.mediafilter.MediaFilterManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Utils;

public class XPDF2Thumbnail
extends MediaFilter {
    private static Logger log = Logger.getLogger(XPDF2Thumbnail.class);
    private static final int MAX_PX = 800;
    private static final int MAX_DPI = 100;
    private static final String[] XPDF_PDFTOPPM_COMMAND = new String[]{"@COMMAND@", "-q", "-f", "1", "-l", "1", "-r", "@DPI@", "@FILE@", "@OUTPUTFILE@"};
    private static final String[] XPDF_PDFINFO_COMMAND = new String[]{"@COMMAND@", "-f", "1", "-l", "1", "-box", "@FILE@"};
    private String pdftoppmPath = null;
    private String pdfinfoPath = null;
    private static final Pattern MEDIABOX_PATT = Pattern.compile("^Page\\s+\\d+\\s+MediaBox:\\s+([\\.\\d-]+)\\s+([\\.\\d-]+)\\s+([\\.\\d-]+)\\s+([\\.\\d-]+)");
    private int xmax = 0;
    private static final int DEFAULT_XMAX = 500;

    @Override
    public String getFilteredName(String oldFilename) {
        return oldFilename + ".jpg";
    }

    @Override
    public String getBundleName() {
        return "THUMBNAIL";
    }

    @Override
    public String getFormatString() {
        return "JPEG";
    }

    @Override
    public String getDescription() {
        return "Generated Thumbnail";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getDestinationStream(InputStream sourceStream) throws Exception {
        float xmax = ConfigurationManager.getIntProperty("thumbnail.maxwidth");
        float ymax = ConfigurationManager.getIntProperty("thumbnail.maxheight");
        boolean blurring = ConfigurationManager.getBooleanProperty("thumbnail.blurring");
        boolean hqscaling = ConfigurationManager.getBooleanProperty("thumbnail.hqscaling");
        if (this.pdftoppmPath == null || this.pdfinfoPath == null) {
            this.pdftoppmPath = ConfigurationManager.getProperty("xpdf.path.pdftoppm");
            this.pdfinfoPath = ConfigurationManager.getProperty("xpdf.path.pdfinfo");
            if (this.pdftoppmPath == null) {
                throw new IllegalStateException("No value for key \"xpdf.path.pdftoppm\" in DSpace configuration!  Should be path to XPDF pdftoppm executable.");
            }
            if (this.pdfinfoPath == null) {
                throw new IllegalStateException("No value for key \"xpdf.path.pdfinfo\" in DSpace configuration!  Should be path to XPDF pdfinfo executable.");
            }
            if (xmax == 0.0f) {
                xmax = 500.0f;
            }
        }
        File sourceTmp = File.createTempFile("DSfilt", ".pdf");
        sourceTmp.deleteOnExit();
        int status = 0;
        BufferedImage source = null;
        try {
            FileOutputStream sto = new FileOutputStream(sourceTmp);
            Utils.copy(sourceStream, sto);
            ((OutputStream)sto).close();
            sourceStream.close();
            int dpi = 0;
            String[] pdfinfoCmd = (String[])XPDF_PDFINFO_COMMAND.clone();
            pdfinfoCmd[0] = this.pdfinfoPath;
            pdfinfoCmd[pdfinfoCmd.length - 1] = sourceTmp.toString();
            try (BufferedReader lr = null;){
                MatchResult mediaBox = null;
                Process pdfProc = Runtime.getRuntime().exec(pdfinfoCmd);
                lr = new BufferedReader(new InputStreamReader(pdfProc.getInputStream()));
                String line = lr.readLine();
                while (line != null) {
                    Matcher mm = MEDIABOX_PATT.matcher(line);
                    if (mm.matches()) {
                        mediaBox = mm.toMatchResult();
                    }
                    line = lr.readLine();
                }
                int istatus = pdfProc.waitFor();
                if (istatus != 0) {
                    log.error((Object)("XPDF pdfinfo proc failed, exit status=" + istatus + ", file=" + sourceTmp));
                }
                if (mediaBox == null) {
                    log.error((Object)("Sanity check: Did not find \"MediaBox\" line in output of XPDF pdfinfo, file=" + sourceTmp));
                    throw new IllegalArgumentException("Failed to get MediaBox of PDF with pdfinfo, cannot compute thumbnail.");
                }
                double x0 = Double.parseDouble(mediaBox.group(1));
                double y0 = Double.parseDouble(mediaBox.group(2));
                double x1 = Double.parseDouble(mediaBox.group(3));
                double y1 = Double.parseDouble(mediaBox.group(4));
                int maxdim = (int)Math.max(Math.abs(x1 - x0), Math.abs(y1 - y0));
                dpi = Math.min(100, 57600 / maxdim);
                log.debug((Object)("DPI: pdfinfo method got dpi=" + dpi + " for max dim=" + maxdim + " (points, 1/72\")"));
            }
            File outPrefixF = File.createTempFile("prevu", "out");
            String outPrefix = outPrefixF.toString();
            if (!outPrefixF.delete()) {
                log.error((Object)"Unable to delete output file");
            }
            Object[] pdfCmd = (String[])XPDF_PDFTOPPM_COMMAND.clone();
            pdfCmd[0] = this.pdftoppmPath;
            pdfCmd[pdfCmd.length - 3] = String.valueOf(dpi);
            pdfCmd[pdfCmd.length - 2] = sourceTmp.toString();
            pdfCmd[pdfCmd.length - 1] = outPrefix;
            File outf = new File(outPrefix + "-000001.ppm");
            log.debug((Object)("Running xpdf command: " + Arrays.deepToString(pdfCmd)));
            try {
                Process pdfProc = Runtime.getRuntime().exec((String[])pdfCmd);
                status = pdfProc.waitFor();
                if (!outf.exists()) {
                    outf = new File(outPrefix + "-00001.ppm");
                }
                if (!outf.exists()) {
                    outf = new File(outPrefix + "-0001.ppm");
                }
                if (!outf.exists()) {
                    outf = new File(outPrefix + "-001.ppm");
                }
                if (!outf.exists()) {
                    outf = new File(outPrefix + "-01.ppm");
                }
                if (!outf.exists()) {
                    outf = new File(outPrefix + "-1.ppm");
                }
                log.debug((Object)("PDFTOPPM output is: " + outf + ", exists=" + outf.exists()));
                source = ImageIO.read(outf);
            }
            catch (InterruptedException e) {
                log.error((Object)"Failed transforming file for preview: ", (Throwable)e);
                throw new IllegalArgumentException("Failed transforming file for preview: ", e);
            }
            finally {
                if (!outf.delete()) {
                    log.error((Object)"Unable to delete file");
                }
            }
        }
        finally {
            if (!sourceTmp.delete()) {
                log.error((Object)"Unable to delete temporary source");
            }
            if (status != 0) {
                log.error((Object)("PDF conversion proc failed, exit status=" + status + ", file=" + sourceTmp));
            }
        }
        if (source == null) {
            throw new IOException("Unknown failure while transforming file to preview: no image produced.");
        }
        BufferedImage buf = source;
        float xsize = buf.getWidth(null);
        float ysize = buf.getHeight(null);
        if (MediaFilterManager.isVerbose) {
            System.out.println("original size: " + xsize + "," + ysize);
        }
        if (xsize > xmax) {
            float scale_factor = xmax / xsize;
            if (MediaFilterManager.isVerbose) {
                System.out.println("x scale factor: " + scale_factor);
            }
            xsize *= scale_factor;
            ysize *= scale_factor;
            if (MediaFilterManager.isVerbose) {
                System.out.println("new size: " + xsize + "," + ysize);
            }
        }
        if (ysize > ymax) {
            float scale_factor = ymax / ysize;
            xsize *= scale_factor;
            ysize *= scale_factor;
        }
        if (MediaFilterManager.isVerbose) {
            System.out.println("created thumbnail size: " + xsize + ", " + ysize);
        }
        BufferedImage thumbnail = new BufferedImage((int)xsize, (int)ysize, 1);
        if (blurring) {
            buf = this.getBlurredInstance(buf);
        }
        if (hqscaling) {
            buf = this.getScaledInstance(buf, (int)xsize, (int)ysize, RenderingHints.VALUE_INTERPOLATION_BICUBIC, true);
        }
        Graphics2D g2d = thumbnail.createGraphics();
        g2d.drawImage(buf, 0, 0, (int)xsize, (int)ysize, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)thumbnail, "jpeg", baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }

    public String[] getInputMIMETypes() {
        return ImageIO.getReaderMIMETypes();
    }

    public String[] getInputDescriptions() {
        return null;
    }

    public String[] getInputExtensions() {
        return null;
    }

    public BufferedImage getNormalizedInstance(BufferedImage buf) {
        int type = buf.getTransparency() == 1 ? 1 : 3;
        int w = buf.getWidth();
        int h = buf.getHeight();
        BufferedImage normal = new BufferedImage(w, h, type);
        Graphics2D g2d = normal.createGraphics();
        g2d.drawImage(buf, 0, 0, w, h, Color.WHITE, null);
        g2d.dispose();
        return normal;
    }

    public BufferedImage getBlurredInstance(BufferedImage buf) {
        buf = this.getNormalizedInstance(buf);
        float[] matrix = new float[]{0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f, 0.111f};
        ConvolveOp blur = new ConvolveOp(new Kernel(3, 3, matrix));
        BufferedImage blurbuf = blur.filter(buf, null);
        return blurbuf;
    }

    public BufferedImage getScaledInstance(BufferedImage buf, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = buf.getTransparency() == 1 ? 1 : 2;
        BufferedImage scalebuf = buf;
        if (higherQuality) {
            w = buf.getWidth();
            h = buf.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2d = tmp.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2d.drawImage(scalebuf, 0, 0, w, h, Color.WHITE, null);
            g2d.dispose();
            scalebuf = tmp;
        } while (w != targetWidth || h != targetHeight);
        return scalebuf;
    }
}

